/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.response;

import android.os.Parcel;
import android.os.Parcelable;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.TransactionResponse;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.response.CitrusResponse;
import com.citrus.sdk.response.b;
import com.google.gson.annotations.SerializedName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class PaymentResponse
extends CitrusResponse
implements Parcelable {
    @SerializedName(value="id")
    protected String transactionId = null;
    @SerializedName(value="amount")
    protected Amount transactionAmount = null;
    @SerializedName(value="balance")
    protected Amount balanceAmount = null;
    @SerializedName(value="cutsomer")
    protected String customer = null;
    @SerializedName(value="merchant")
    protected String merchantName = null;
    @SerializedName(value="date")
    protected String date = null;
    protected TransactionResponse transactionResponse = null;
    private JSONObject responseParams = null;
    protected CitrusUser user = null;
    public static final Parcelable.Creator<PaymentResponse> CREATOR = new b();

    public TransactionResponse getTransactionResponse() {
        return this.transactionResponse;
    }

    PaymentResponse() {
    }

    public PaymentResponse(String string2, CitrusResponse.Status status, String string3, Amount amount, Amount amount2, CitrusUser citrusUser) {
        super(string2, status);
        this.transactionId = string3;
        this.transactionAmount = amount;
        this.balanceAmount = amount2;
        this.user = citrusUser;
    }

    public PaymentResponse(String string2, CitrusResponse.Status status, String string3, Amount amount, Amount amount2, CitrusUser citrusUser, String string4, String string5, String string6, TransactionResponse transactionResponse) {
        super(string2, status);
        this.transactionId = string3;
        this.transactionAmount = amount;
        this.balanceAmount = amount2;
        this.customer = string4;
        this.merchantName = string5;
        this.date = string6;
        this.transactionResponse = transactionResponse;
        this.user = citrusUser;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public Amount getTransactionAmount() {
        return this.transactionAmount;
    }

    public Amount getBalanceAmount() {
        return this.balanceAmount;
    }

    public CitrusUser getUser() {
        return this.user;
    }

    public String getMerchantName() {
        return this.merchantName;
    }

    public String getDate() {
        return this.date;
    }

    public String getCustomer() {
        return this.customer;
    }

    private void setResponseParams(JSONObject jSONObject) {
        this.responseParams = jSONObject;
    }

    public String getURLEncodedParams() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.responseParams != null) {
            Iterator iterator = this.responseParams.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                stringBuffer.append(string2);
                stringBuffer.append("=");
                try {
                    stringBuffer.append(URLEncoder.encode(this.responseParams.optString(string2), "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
                stringBuffer.append("&");
            }
        }
        return stringBuffer.toString();
    }

    public static PaymentResponse fromJSON(String object) {
        PaymentResponse paymentResponse = null;
        try {
            String string2;
            Object object2;
            Object object3;
            object = new JSONObject((String)object);
            String string3 = object.optString("customer", object.optString("cutsomer"));
            CitrusResponse.Status status = CitrusResponse.Status.valueOf(object.optString("status"));
            String string4 = status == CitrusResponse.Status.SUCCESSFUL ? "Transaction Successful" : object.optString("reason");
            String string5 = object.optString("date");
            String string6 = object.optString("merchant");
            Amount amount = Amount.fromJSONObject(object.optJSONObject("amount"));
            Amount amount2 = Amount.fromJSONObject(object.optJSONObject("balance"));
            HashMap<String, String> hashMap = null;
            JSONObject jSONObject = object.optJSONObject("customParams");
            if (jSONObject != null) {
                hashMap = new HashMap<String, String>();
                object3 = jSONObject.keys();
                while (object3.hasNext()) {
                    object2 = (String)object3.next();
                    string2 = jSONObject.optString((String)object2);
                    hashMap.put((String)object2, string2);
                }
            }
            string2 = (object2 = TransactionResponse.fromJSONObject((JSONObject)(object3 = object.optJSONObject("responseParams")), hashMap)) != null ? ((TransactionResponse)object2).getTransactionId() : null;
            object = ((TransactionResponse)object2).getCitrusUser();
            paymentResponse = new PaymentResponse(string4, status, string2, amount, amount2, (CitrusUser)object, string3, string6, string5, (TransactionResponse)object2);
            paymentResponse.setResponseParams((JSONObject)object3);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return paymentResponse;
    }

    public String toString() {
        return "PaymentResponse{transactionId='" + this.transactionId + '\'' + ", transactionAmount=" + this.transactionAmount + ", balanceAmount=" + this.balanceAmount + ", customer='" + this.customer + '\'' + ", merchantName='" + this.merchantName + '\'' + ", date='" + this.date + '\'' + ", transactionResponse=" + this.transactionResponse + ", user=" + this.user + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n2) {
        super.writeToParcel(parcel, n2);
        parcel.writeString(this.transactionId);
        parcel.writeParcelable((Parcelable)this.transactionAmount, 0);
        parcel.writeParcelable((Parcelable)this.balanceAmount, 0);
        parcel.writeString(this.customer);
        parcel.writeString(this.merchantName);
        parcel.writeString(this.date);
        parcel.writeParcelable((Parcelable)this.transactionResponse, 0);
        parcel.writeParcelable((Parcelable)this.user, 0);
    }

    protected PaymentResponse(Parcel parcel) {
        super(parcel);
        this.transactionId = parcel.readString();
        this.transactionAmount = (Amount)parcel.readParcelable(Amount.class.getClassLoader());
        this.balanceAmount = (Amount)parcel.readParcelable(Amount.class.getClassLoader());
        this.customer = parcel.readString();
        this.merchantName = parcel.readString();
        this.date = parcel.readString();
        this.transactionResponse = (TransactionResponse)parcel.readParcelable(TransactionResponse.class.getClassLoader());
        this.user = (CitrusUser)parcel.readParcelable(CitrusUser.class.getClassLoader());
    }
}

