/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.CitrusException;
import com.citrus.sdk.dynamicPricing.DynamicPricingResponse;
import com.citrus.sdk.payment.PaymentBill;
import com.citrus.sdk.payment.PaymentOption;
import com.citrus.sdk.payment.s;
import com.citrus.sdk.payment.t;
import com.citrus.sdk.payment.u;
import com.citrus.sdk.payment.v;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class PaymentType
implements Parcelable {
    public Amount d;
    public String e;
    public PaymentBill f = null;
    protected PaymentOption g = null;
    public List<PaymentOption> h = null;
    protected CitrusUser i = null;

    public PaymentType() {
    }

    protected PaymentType(PaymentBill paymentBill) {
        this.f = paymentBill;
        this.d = paymentBill.getAmount();
    }

    public PaymentType(Amount amount, String string, PaymentOption paymentOption, CitrusUser citrusUser) {
        this.d = amount;
        this.e = string;
        this.g = paymentOption;
        this.i = citrusUser;
    }

    public PaymentType(PaymentBill paymentBill, PaymentOption paymentOption, CitrusUser citrusUser) {
        this(paymentBill);
        this.g = paymentOption;
        this.i = citrusUser;
    }

    public PaymentType(Amount amount, String string, List<PaymentOption> list) {
        this(amount, string, null, null);
        this.h = list;
    }

    public PaymentType(PaymentBill paymentBill, List<PaymentOption> list) {
        this(paymentBill, null, null);
        this.h = list;
    }

    public Amount getAmount() {
        return this.d;
    }

    public String getUrl() {
        return this.e;
    }

    public PaymentBill getPaymentBill() {
        return this.f;
    }

    public PaymentOption getPaymentOption() {
        return this.g;
    }

    public List<PaymentOption> getPaymentOptionList() {
        return this.h;
    }

    public CitrusUser getCitrusUser() {
        return this.i;
    }

    public abstract String getIntentAction();

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeParcelable((Parcelable)this.d, 0);
        parcel.writeString(this.e);
        parcel.writeParcelable((Parcelable)this.f, 0);
        parcel.writeParcelable((Parcelable)this.g, 0);
        parcel.writeList(this.h);
        parcel.writeParcelable((Parcelable)this.i, 0);
    }

    public PaymentType(Parcel parcel) {
        this.d = (Amount)parcel.readParcelable(Amount.class.getClassLoader());
        this.e = parcel.readString();
        this.f = (PaymentBill)parcel.readParcelable(PaymentBill.class.getClassLoader());
        this.g = (PaymentOption)parcel.readParcelable(PaymentOption.class.getClassLoader());
        this.h = parcel.readArrayList(PaymentOption.class.getClassLoader());
        this.i = (CitrusUser)parcel.readParcelable(CitrusUser.class.getClassLoader());
    }

    public static class SplitPayment
    extends PaymentType {
        private boolean a = false;
        private boolean b = false;
        public static final Parcelable.Creator<SplitPayment> CREATOR = new v();

        public SplitPayment(Amount amount, String string, PaymentOption paymentOption, boolean bl2, boolean bl3) throws CitrusException {
            super(amount, string, paymentOption, null);
            this.b = bl2;
            this.a = bl3;
            if (amount == null || TextUtils.isEmpty((CharSequence)amount.getValue())) {
                throw new CitrusException("Amount should be not null or blank.");
            }
            if (!(amount.getValueAsDouble() > 0.0)) {
                throw new CitrusException("Amount should be greater than 0");
            }
            if (string == null) {
                throw new CitrusException("billUrl should be not null.");
            }
            if (!this.d.isValidAmount()) {
                throw new CitrusException("Please enter amount upto 2 decimal points only.");
            }
        }

        public SplitPayment(PaymentBill paymentBill, PaymentOption paymentOption, boolean bl2, boolean bl3) throws CitrusException {
            super(paymentBill, paymentOption, null);
            this.b = bl2;
            this.a = bl3;
            if (paymentOption == null) {
                throw new CitrusException("PaymentOption should be not null.");
            }
            if (paymentBill == null) {
                throw new CitrusException("PaymentBill should not be null.");
            }
            if (!paymentBill.getAmount().isValidAmount()) {
                throw new CitrusException("Please enter amount upto 2 decimal points only.");
            }
        }

        public SplitPayment(PGPayment pGPayment) {
            if (pGPayment.getPaymentBill() != null) {
                this.f = pGPayment.getPaymentBill();
            } else {
                this.d = pGPayment.getAmount();
                this.e = pGPayment.getUrl();
            }
            this.g = pGPayment.getPaymentOption();
            this.g.transactionAmount = pGPayment.getAmount();
        }

        public boolean isCitrusCashEnabled() {
            return this.b;
        }

        public boolean isMVCEnabled() {
            return this.a;
        }

        @Override
        public String getIntentAction() {
            return "ACTION_WALLET_PG_PAYMENT";
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n2) {
            super.writeToParcel(parcel, n2);
            parcel.writeByte(this.a ? (byte)1 : 0);
            parcel.writeByte(this.b ? (byte)1 : 0);
        }

        protected SplitPayment(Parcel parcel) {
            super(parcel);
            this.a = parcel.readByte() != 0;
            this.b = parcel.readByte() != 0;
        }
    }

    public static class PGPayment
    extends PaymentType
    implements Parcelable {
        private boolean a = false;
        private boolean b = false;
        private DynamicPricingResponse c = null;
        public static final Parcelable.Creator<PGPayment> CREATOR = new u();

        private PGPayment() {
        }

        public PGPayment(Amount amount, String string, PaymentOption paymentOption, CitrusUser citrusUser) throws CitrusException {
            super(amount, string, paymentOption, citrusUser);
            if (amount == null || TextUtils.isEmpty((CharSequence)amount.getValue())) {
                throw new CitrusException("Amount should be not null or blank.");
            }
            if (!(amount.getValueAsDouble() > 0.0)) {
                throw new CitrusException("Amount should be greater than 0");
            }
            if (string == null) {
                throw new CitrusException("billUrl should be not null.");
            }
            if (paymentOption == null) {
                throw new CitrusException("PaymentOption should be not null.");
            }
        }

        public PGPayment(DynamicPricingResponse dynamicPricingResponse) throws CitrusException {
            this(dynamicPricingResponse.getPaymentBill(), dynamicPricingResponse.getPaymentOption(), dynamicPricingResponse.getCitrusUser());
            this.b = true;
            this.c = dynamicPricingResponse;
        }

        public PGPayment(PaymentBill paymentBill, PaymentOption paymentOption) throws CitrusException {
            super(paymentBill);
            this.g = paymentOption;
            if (paymentBill == null) {
                throw new CitrusException("PaymentBill should not be null.");
            }
            if (paymentOption == null) {
                throw new CitrusException("paymentOption should not be null.");
            }
        }

        public PGPayment(PaymentBill paymentBill, PaymentOption paymentOption, CitrusUser citrusUser) throws CitrusException {
            super(paymentBill, paymentOption, citrusUser);
            this.g = paymentOption;
            this.i = citrusUser;
            if (paymentBill == null) {
                throw new CitrusException("PaymentBill should not be null.");
            }
            if (paymentOption == null) {
                throw new CitrusException("PaymentBill should not be null.");
            }
        }

        public PGPayment(SplitPayment splitPayment) throws CitrusException {
            if (splitPayment.getPaymentBill() != null) {
                this.f = splitPayment.getPaymentBill();
                this.d = this.f.getAmount();
            } else {
                this.d = splitPayment.getAmount();
                this.e = splitPayment.getUrl();
            }
            this.g = splitPayment.getPaymentOption();
        }

        public boolean isSingleHop() {
            return this.a;
        }

        public void useSingleHop(boolean bl2) {
            this.a = bl2;
        }

        public boolean isDyanmicPricingRequest() {
            return this.b;
        }

        public DynamicPricingResponse getDynamicPricingResponse() {
            return this.c;
        }

        @Override
        public final String getIntentAction() {
            return "ACTION_PG_PAYMENT";
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n2) {
            parcel.writeParcelable((Parcelable)this.g, 0);
            parcel.writeParcelable((Parcelable)this.i, 0);
            parcel.writeParcelable((Parcelable)this.d, 0);
            parcel.writeString(this.e);
            parcel.writeParcelable((Parcelable)this.f, 0);
        }

        private PGPayment(Parcel parcel) {
            this.g = (PaymentOption)parcel.readParcelable(PaymentOption.class.getClassLoader());
            this.i = (CitrusUser)parcel.readParcelable(CitrusUser.class.getClassLoader());
            this.d = (Amount)parcel.readParcelable(Amount.class.getClassLoader());
            this.e = parcel.readString();
            this.f = (PaymentBill)parcel.readParcelable(PaymentBill.class.getClassLoader());
        }

        /* synthetic */ PGPayment(Parcel parcel, byte by2) {
            this(parcel);
        }
    }

    public static class CitrusCash
    extends PaymentType
    implements Parcelable {
        public static final Parcelable.Creator<CitrusCash> CREATOR = new s();

        private CitrusCash() {
        }

        public CitrusCash(Amount amount, String string) throws CitrusException {
            super(amount, string, null, null);
            if (amount == null || TextUtils.isEmpty((CharSequence)amount.getValue())) {
                throw new CitrusException("Amount should be not null or blank.");
            }
            if (!(amount.getValueAsDouble() > 0.0)) {
                throw new CitrusException("Amount should be greater than 0");
            }
            if (string == null) {
                throw new CitrusException("billUrl should be not null.");
            }
        }

        public CitrusCash(PaymentBill paymentBill) {
            super(paymentBill);
        }

        public final void setPaymentBill(PaymentBill paymentBill) {
            this.f = paymentBill;
        }

        public final void setCitrusUser(CitrusUser citrusUser) {
            this.i = citrusUser;
        }

        public final String getPaymentJSON() {
            String string = "";
            JSONObject jSONObject = PaymentBill.toJSONObject(this.f);
            if (jSONObject != null) {
                try {
                    jSONObject.put("userDetails", (Object)CitrusUser.toJSONObject(this.i, true));
                    jSONObject.put("requestOrigin", (Object)"MSDKW");
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                string = jSONObject.toString();
            }
            return string;
        }

        @Override
        public final String getIntentAction() {
            return "ACTION_PAY_USING_CASH";
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n2) {
            parcel.writeParcelable((Parcelable)this.d, 0);
            parcel.writeString(this.e);
            parcel.writeParcelable((Parcelable)this.f, 0);
            parcel.writeParcelable((Parcelable)this.g, 0);
            parcel.writeParcelable((Parcelable)this.i, 0);
        }

        private CitrusCash(Parcel parcel) {
            this.d = (Amount)parcel.readParcelable(Amount.class.getClassLoader());
            this.e = parcel.readString();
            this.f = (PaymentBill)parcel.readParcelable(PaymentBill.class.getClassLoader());
            this.g = (PaymentOption)parcel.readParcelable(PaymentOption.class.getClassLoader());
            this.i = (CitrusUser)parcel.readParcelable(CitrusUser.class.getClassLoader());
        }

        /* synthetic */ CitrusCash(Parcel parcel, byte by2) {
            this(parcel);
        }
    }

    public static class LoadMoney
    extends PaymentType
    implements Parcelable {
        private PaymentOption a = null;
        public static final Parcelable.Creator<LoadMoney> CREATOR = new t();

        private LoadMoney() {
        }

        public LoadMoney(Amount amount, String string, PaymentOption paymentOption) throws CitrusException {
            super(amount, string, paymentOption, null);
            this.a = paymentOption;
            if (amount == null || TextUtils.isEmpty((CharSequence)amount.getValue())) {
                throw new CitrusException("Amount should be not null or blank.");
            }
            if (!(amount.getValueAsDouble() > 0.0)) {
                throw new CitrusException("Amount should be greater than 0");
            }
            if (string == null) {
                throw new CitrusException("returnUrl should be not null.");
            }
            if (paymentOption == null) {
                throw new CitrusException("PaymentOption should be not null.");
            }
        }

        @Override
        public PaymentOption getPaymentOption() {
            return this.a;
        }

        @Override
        public final String getIntentAction() {
            return "ACTION_LOAD_MONEY";
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n2) {
            parcel.writeParcelable((Parcelable)this.a, 0);
            parcel.writeParcelable((Parcelable)this.d, 0);
            parcel.writeString(this.e);
            parcel.writeParcelable((Parcelable)this.f, 0);
            parcel.writeParcelable((Parcelable)this.a, 0);
            parcel.writeParcelable((Parcelable)this.i, 0);
        }

        private LoadMoney(Parcel parcel) {
            this.a = (PaymentOption)parcel.readParcelable(PaymentOption.class.getClassLoader());
            this.d = (Amount)parcel.readParcelable(Amount.class.getClassLoader());
            this.e = parcel.readString();
            this.f = (PaymentBill)parcel.readParcelable(PaymentBill.class.getClassLoader());
            this.a = (PaymentOption)parcel.readParcelable(PaymentOption.class.getClassLoader());
            this.i = (CitrusUser)parcel.readParcelable(CitrusUser.class.getClassLoader());
        }

        /* synthetic */ LoadMoney(Parcel parcel, byte by2) {
            this(parcel);
        }
    }
}

