/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.Month;
import com.citrus.sdk.classes.Year;
import com.citrus.sdk.classes.l;
import com.citrus.sdk.payment.CardOption;
import com.citrus.sdk.payment.CitrusCash;
import com.citrus.sdk.payment.CreditCardOption;
import com.citrus.sdk.payment.DebitCardOption;
import com.citrus.sdk.payment.MVCOption;
import com.citrus.sdk.payment.NetbankingOption;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class PaymentOption
implements Parcelable {
    protected String name = null;
    protected String token = null;
    protected boolean savePaymentOption = false;
    protected Amount transactionAmount = null;
    protected l pgHealth = l.UNKNOWN;
    protected boolean defaultPaymentMode = false;
    protected boolean selected = false;
    protected boolean shown = false;
    protected String fingerPrint = null;
    private int amount;
    private String cvvText = "";

    PaymentOption() {
    }

    PaymentOption(String string, String string2) {
        this.name = string;
        this.token = string2;
    }

    PaymentOption(Amount amount, String string, String string2) {
        this.transactionAmount = amount;
        this.name = string;
        this.token = string2;
    }

    public static PaymentOption fromJSONObject(JSONObject jSONObject) {
        return PaymentOption.fromJSONObject(jSONObject, false);
    }

    public static PaymentOption fromJSONObject(JSONObject object, boolean bl2) {
        String string;
        String string2;
        String string3;
        CardOption.CardScheme cardScheme;
        String string4;
        String string5;
        String string6;
        String string7;
        Object object2;
        PaymentOption paymentOption = null;
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = "";
        boolean bl3 = false;
        if (bl2) {
            object2 = object.optString("paymentMode");
            string7 = object.optString("name");
            string6 = object.optString("savedCardToken");
            string5 = object.optString("cardExpiryDate");
            string4 = object.optString("cardNumber");
            cardScheme = CardOption.CardScheme.getCardScheme(object.optString("cardScheme"));
            string3 = object.optString("fingerPrint");
            string2 = object.optString("bank");
            string = "";
            string10 = object.optString("amount");
            string11 = object.optString("campaignCode");
            string12 = object.optString("maxBalance");
            bl3 = object.optBoolean("defaultPaymentMode", false);
        } else {
            object2 = object.optString("type");
            string7 = object.optString("name");
            string6 = object.optString("token");
            string = object.optString("owner");
            string5 = object.optString("expiryDate");
            string4 = object.optString("number");
            cardScheme = CardOption.CardScheme.getCardScheme(object.optString("scheme"));
            string3 = object.optString("fingerPrint");
            string2 = object.optString("bank");
        }
        if (!TextUtils.isEmpty((CharSequence)string5) && string5.length() > 2) {
            string8 = TextUtils.substring((CharSequence)string5, (int)0, (int)2);
            string9 = TextUtils.substring((CharSequence)string5, (int)2, (int)string5.length());
        }
        if (TextUtils.equals((CharSequence)"credit", (CharSequence)object2) || TextUtils.equals((CharSequence)"CREDIT_CARD", (CharSequence)object2)) {
            paymentOption = new CreditCardOption(string, string4, null, Month.getMonth(string8), Year.getYear(string9));
            super.setName(string7);
            super.setToken(string6);
            ((CardOption)paymentOption).setCardScheme(cardScheme);
        } else if (TextUtils.equals((CharSequence)"debit", (CharSequence)object2) || TextUtils.equals((CharSequence)"DEBIT_CARD", (CharSequence)object2)) {
            paymentOption = new DebitCardOption(string, string4, null, Month.getMonth(string8), Year.getYear(string9));
            super.setName(string7);
            super.setToken(string6);
            ((DebitCardOption)paymentOption).setCardScheme(cardScheme);
        } else if (TextUtils.equals((CharSequence)"netbanking", (CharSequence)object2) || TextUtils.equals((CharSequence)"NET_BANKING", (CharSequence)object2)) {
            paymentOption = new NetbankingOption(string7, string6, string2);
        } else if (TextUtils.equals((CharSequence)"MVC", (CharSequence)object2)) {
            object = new Amount(string12);
            object2 = new Amount(string10);
            paymentOption = new MVCOption((Amount)object2, string11, (Amount)object);
        } else if (TextUtils.equals((CharSequence)"PREPAID_CARD", (CharSequence)object2)) {
            object = new Amount(string12);
            object2 = new Amount(string10);
            paymentOption = new CitrusCash((Amount)object2, (Amount)object);
        }
        paymentOption.setDefaultPaymentMode(bl3);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            paymentOption.setFingerPrint(string3);
        }
        return paymentOption;
    }

    public Amount getTransactionAmount() {
        return this.transactionAmount;
    }

    public void setTransactionAmount(Amount amount) {
        this.transactionAmount = amount;
    }

    public String getName() {
        return this.name;
    }

    private void setName(String string) {
        this.name = string;
    }

    public String getToken() {
        return this.token;
    }

    private void setToken(String string) {
        this.token = string;
    }

    public boolean isSavePaymentOption() {
        return this.savePaymentOption;
    }

    public void setSavePaymentOption(boolean bl2) {
        this.savePaymentOption = bl2;
    }

    public l getPgHealth() {
        return this.pgHealth;
    }

    protected void setPgHealth(l l2) {
        this.pgHealth = l2;
    }

    public void setFingerPrint(String string) {
        this.fingerPrint = string;
    }

    public String getFingerPrint() {
        return this.fingerPrint;
    }

    public boolean isDefaultPaymentMode() {
        return this.defaultPaymentMode;
    }

    void setDefaultPaymentMode(boolean bl2) {
        this.defaultPaymentMode = bl2;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isShown() {
        return this.shown;
    }

    public int getCashAmount() {
        return this.amount;
    }

    public void setCashAmount(int n2) {
        this.amount = n2;
    }

    public String getCvvText() {
        return this.cvvText;
    }

    public void setCvvText(String string) {
        this.cvvText = string;
    }

    public abstract String getSavePaymentOptionObject();

    public abstract String getSaveDefaultPaymentOptionObject();

    public abstract JSONObject getMOTOPaymentOptionObject() throws JSONException;

    public abstract JSONObject getWalletChargePaymentOptionObject() throws JSONException;

    public abstract Drawable getOptionIcon(Context var1);

    public abstract String getDynamicPricingPaymentMode();

    public String toString() {
        return "PaymentOption{name='" + this.name + '\'' + ", token='" + this.token + '\'' + ", defaultPaymentMode=" + this.defaultPaymentMode + ", selected=" + this.selected + '}';
    }

    public boolean equals(Object object) {
        boolean bl2 = false;
        if (object == null || object.getClass() != this.getClass()) {
            bl2 = false;
        } else if (this.name.equalsIgnoreCase(((PaymentOption)(object = (PaymentOption)object)).getName())) {
            bl2 = true;
        }
        return bl2;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.name);
        parcel.writeString(this.token);
        parcel.writeByte(this.savePaymentOption ? (byte)1 : 0);
        parcel.writeParcelable((Parcelable)this.transactionAmount, 0);
        parcel.writeInt(this.pgHealth == null ? -1 : this.pgHealth.ordinal());
        parcel.writeByte(this.defaultPaymentMode ? (byte)1 : 0);
        parcel.writeByte(this.selected ? (byte)1 : 0);
        parcel.writeByte(this.shown ? (byte)1 : 0);
        parcel.writeString(this.fingerPrint);
        parcel.writeInt(this.amount);
        parcel.writeString(this.cvvText);
    }

    protected PaymentOption(Parcel parcel) {
        this.name = parcel.readString();
        this.token = parcel.readString();
        this.savePaymentOption = parcel.readByte() != 0;
        this.transactionAmount = (Amount)parcel.readParcelable(Amount.class.getClassLoader());
        int n2 = parcel.readInt();
        this.pgHealth = n2 == -1 ? null : l.values()[n2];
        this.defaultPaymentMode = parcel.readByte() != 0;
        this.selected = parcel.readByte() != 0;
        this.shown = parcel.readByte() != 0;
        this.fingerPrint = parcel.readString();
        this.amount = parcel.readInt();
        this.cvvText = parcel.readString();
    }

    public final boolean isTokenizedPayment() {
        return !TextUtils.isEmpty((CharSequence)this.token);
    }
}

