/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.payment.PaymentOption;
import com.citrus.sdk.payment.m;
import org.json.JSONException;
import org.json.JSONObject;

public final class CitrusCash
extends PaymentOption {
    private CitrusUser a = null;
    private Amount b = null;
    public static final Parcelable.Creator<CitrusCash> CREATOR = new m();

    public CitrusCash(String string, String string2) {
        super(string, string2);
    }

    public CitrusCash(Amount amount) {
        this.transactionAmount = amount;
        this.name = "Citrus Cash : \u20b9 " + amount.getValueAsDouble();
    }

    CitrusCash(Amount amount, Amount amount2) {
        this(amount);
        this.b = amount2;
        this.name = "Citrus Cash Balance : \u20b9 " + amount2.getValueAsDouble();
    }

    public CitrusCash(Amount amount, CitrusUser citrusUser) {
        this(amount);
        this.a = citrusUser;
    }

    public final Amount getMaxBalance() {
        return this.b;
    }

    public final Amount getMaxBalanceRounded() {
        int n2 = (int)Math.floor(this.b.getValueAsDouble());
        return new Amount(String.valueOf(n2));
    }

    @Override
    public final Drawable getOptionIcon(Context context) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getResources().getDrawable(context.getResources().getIdentifier("citrus_cash", "drawable", context.getPackageName()), null);
        }
        int n2 = context.getResources().getIdentifier("citrus_cash", "drawable", context.getPackageName());
        context = Build.VERSION.SDK_INT >= 21 ? context.getResources().getDrawable(n2, null) : context.getResources().getDrawable(n2);
        return context;
    }

    @Override
    public final String getSavePaymentOptionObject() {
        return null;
    }

    @Override
    public final String getDynamicPricingPaymentMode() {
        return "PREPAID_CARD";
    }

    @Override
    public final String getSaveDefaultPaymentOptionObject() {
        return null;
    }

    @Override
    public final JSONObject getMOTOPaymentOptionObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("type", (Object)"paymentOptionToken");
        JSONObject jSONObject2 = new JSONObject();
        if (this.a != null) {
            jSONObject2.put("holder", (Object)this.a.getEmailId());
        } else {
            jSONObject2.put("holder", (Object)"");
        }
        jSONObject2.put("number", (Object)"1234561234561234");
        jSONObject2.put("scheme", (Object)"CPAY");
        jSONObject2.put("type", (Object)"prepaid");
        jSONObject2.put("cvv", (Object)"000");
        jSONObject2.put("expiry", (Object)"04/2030");
        jSONObject.put("paymentMode", (Object)jSONObject2);
        return jSONObject;
    }

    @Override
    public final JSONObject getWalletChargePaymentOptionObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.transactionAmount != null) {
            jSONObject.put("paymentMode", (Object)"PREPAID_CARD");
            jSONObject.put("amount", (Object)String.valueOf(this.transactionAmount.getValueAsDouble()));
            jSONObject.put("currency", (Object)this.transactionAmount.getCurrency());
        }
        return jSONObject;
    }

    @Override
    public final String toString() {
        return super.toString() + "CitrusCash{Balance amount='" + this.b.getValueAsDouble() + '\'' + '}';
    }

    public final void setName(String string) {
        this.name = string;
    }

    @Override
    public final int describeContents() {
        return 0;
    }

    @Override
    public final void writeToParcel(Parcel parcel, int n2) {
        super.writeToParcel(parcel, n2);
        parcel.writeParcelable((Parcelable)this.a, 0);
    }

    protected CitrusCash(Parcel parcel) {
        super(parcel);
        this.a = (CitrusUser)parcel.readParcelable(CitrusUser.class.getClassLoader());
    }
}

