/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.dynamicPricing;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.payment.PaymentOption;
import java.util.Map;

public abstract class DynamicPricingRequestType {
    protected Amount originalAmount;
    protected PaymentOption paymentOption;
    protected CitrusUser citrusUser;
    protected Map<String, String> extraParameters;

    public DynamicPricingRequestType(@NonNull Amount amount, @NonNull PaymentOption paymentOption, CitrusUser citrusUser) throws IllegalArgumentException {
        this(amount, paymentOption, citrusUser, null);
    }

    public DynamicPricingRequestType(@NonNull Amount amount, @NonNull PaymentOption paymentOption, CitrusUser citrusUser, Map<String, String> map) throws IllegalArgumentException {
        this.originalAmount = amount;
        this.paymentOption = paymentOption;
        this.citrusUser = citrusUser;
        this.extraParameters = map;
        if (amount == null) {
            throw new IllegalArgumentException("originalAmount should not be null");
        }
        if (paymentOption == null) {
            throw new IllegalArgumentException("paymentOption should not be null");
        }
    }

    public Amount getOriginalAmount() {
        return this.originalAmount;
    }

    public PaymentOption getPaymentOption() {
        return this.paymentOption;
    }

    public CitrusUser getCitrusUser() {
        return this.citrusUser;
    }

    public Map<String, String> getExtraParameters() {
        return this.extraParameters;
    }

    public abstract String getDPOperationName();

    public static class ValidateRule
    extends DynamicPricingRequestType {
        private String ruleName;
        private Amount alteredAmount;

        public ValidateRule(@NonNull Amount amount, @NonNull PaymentOption paymentOption, @NonNull String string, @NonNull Amount amount2, CitrusUser citrusUser) throws IllegalArgumentException {
            this(amount, paymentOption, string, amount2, citrusUser, null);
        }

        public ValidateRule(@NonNull Amount amount, @NonNull PaymentOption paymentOption, @NonNull String string, @NonNull Amount amount2, CitrusUser citrusUser, Map<String, String> map) throws IllegalArgumentException {
            super(amount, paymentOption, citrusUser, map);
            this.ruleName = string;
            this.alteredAmount = amount2;
            if (TextUtils.isEmpty((CharSequence)string)) {
                throw new IllegalArgumentException("ruleName should not be null.");
            }
            if (amount2 == null) {
                throw new IllegalArgumentException("alteredAmount should not be null.");
            }
        }

        public String getRuleName() {
            return this.ruleName;
        }

        public Amount getAlteredAmount() {
            return this.alteredAmount;
        }

        @Override
        public String getDPOperationName() {
            return "validateRule";
        }
    }

    public static class CalculatePrice
    extends DynamicPricingRequestType {
        private String ruleName;

        public CalculatePrice(@NonNull Amount amount, @NonNull PaymentOption paymentOption, @NonNull String string, CitrusUser citrusUser) throws IllegalArgumentException {
            this(amount, paymentOption, string, citrusUser, null);
        }

        public CalculatePrice(@NonNull Amount amount, @NonNull PaymentOption paymentOption, @NonNull String string, CitrusUser citrusUser, Map<String, String> map) throws IllegalArgumentException {
            super(amount, paymentOption, citrusUser, map);
            this.ruleName = string;
            if (TextUtils.isEmpty((CharSequence)string)) {
                throw new IllegalArgumentException("ruleName should not be null.");
            }
        }

        public String getRuleName() {
            return this.ruleName;
        }

        @Override
        public String getDPOperationName() {
            return "calculatePricing";
        }
    }

    public static class SearchAndApplyRule
    extends DynamicPricingRequestType {
        public SearchAndApplyRule(@NonNull Amount amount, @NonNull PaymentOption paymentOption, CitrusUser citrusUser) throws IllegalArgumentException {
            this(amount, paymentOption, citrusUser, null);
        }

        public SearchAndApplyRule(@NonNull Amount amount, @NonNull PaymentOption paymentOption, CitrusUser citrusUser, Map<String, String> map) throws IllegalArgumentException {
            super(amount, paymentOption, citrusUser, map);
        }

        @Override
        public String getDPOperationName() {
            return "searchAndApply";
        }
    }
}

