/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.classes;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.citrus.sdk.classes.c;
import java.text.DecimalFormat;
import org.json.JSONException;
import org.json.JSONObject;

public class Amount
implements Parcelable,
Comparable<Amount> {
    private final String a;
    private final String b;
    public static final Parcelable.Creator<Amount> CREATOR = new c();

    public Amount(String string) {
        this.a = string;
        this.b = "INR";
    }

    public Amount(String string, String string2) {
        this.a = string;
        this.b = string2;
    }

    public String getValue() {
        if (!TextUtils.isEmpty((CharSequence)this.a)) {
            return this.a.replaceFirst("^0+(?!$)", "");
        }
        return this.a;
    }

    public String getCurrency() {
        return this.b;
    }

    public String getValueAsFormattedDouble(String string) throws NumberFormatException {
        return new DecimalFormat(string).format(this.getValueAsDouble());
    }

    public double getValueAsDouble() throws NumberFormatException {
        double d2 = 0.0;
        if (!TextUtils.isEmpty((CharSequence)this.a)) {
            d2 = Double.parseDouble(this.a);
        }
        return d2;
    }

    public static Amount fromJSON(String string) {
        Amount amount = null;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                amount = Amount.fromJSONObject(new JSONObject(string));
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return amount;
    }

    public static Amount fromJSONObject(JSONObject object) {
        Amount amount = null;
        if (object != null) {
            String string = object.optString("value");
            object = object.optString("currency");
            if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)object)) {
                amount = new Amount(string, (String)object);
            }
        }
        return amount;
    }

    public static String toJSON(Amount amount) {
        if ((amount = Amount.toJSONObject(amount)) != null) {
            return amount.toString();
        }
        return null;
    }

    public static JSONObject toJSONObject(Amount amount) {
        JSONObject jSONObject = null;
        if (amount != null) {
            try {
                jSONObject = new JSONObject();
                jSONObject.put("value", (Object)amount.a);
                jSONObject.put("currency", (Object)amount.b);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return jSONObject;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.a);
        parcel.writeString(this.b);
    }

    private Amount(Parcel parcel) {
        this.a = parcel.readString();
        this.b = parcel.readString();
    }

    public String toString() {
        return "Amount{value='" + this.a + '\'' + ", currency='" + this.b + '\'' + '}';
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Amount) {
            object = (Amount)object;
            return this.getValueAsDouble() == ((Amount)object).getValueAsDouble() && this.b.equalsIgnoreCase(((Amount)object).getCurrency());
        }
        return false;
    }

    @Override
    public int compareTo(Amount amount) {
        if (this.getValueAsDouble() > amount.getValueAsDouble()) {
            return 1;
        }
        if (this.getValueAsDouble() < amount.getValueAsDouble()) {
            return -1;
        }
        return 0;
    }

    public boolean isValidAmount() {
        String[] stringArray = this.a.split("\\.");
        if (stringArray.length > 1) {
            return stringArray[1].length() <= 2;
        }
        return true;
    }

    /* synthetic */ Amount(Parcel parcel, byte by2) {
        this(parcel);
    }
}

