/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Base64;
import android.widget.Toast;
import com.citrus.sdk.Callback;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.Environment;
import com.citrus.sdk.PaymentDistribution;
import com.citrus.sdk.TransactionResponse;
import com.citrus.sdk.b.b;
import com.citrus.sdk.bh;
import com.citrus.sdk.bi;
import com.citrus.sdk.bj;
import com.citrus.sdk.bk;
import com.citrus.sdk.bl;
import com.citrus.sdk.bn;
import com.citrus.sdk.bo;
import com.citrus.sdk.bp;
import com.citrus.sdk.bq;
import com.citrus.sdk.bu;
import com.citrus.sdk.bv;
import com.citrus.sdk.bx;
import com.citrus.sdk.by;
import com.citrus.sdk.cc;
import com.citrus.sdk.cd;
import com.citrus.sdk.ce;
import com.citrus.sdk.cf;
import com.citrus.sdk.cg;
import com.citrus.sdk.ch;
import com.citrus.sdk.ci;
import com.citrus.sdk.classes.AccessToken;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.CashoutInfo;
import com.citrus.sdk.classes.CitrusConfig;
import com.citrus.sdk.classes.CitrusException;
import com.citrus.sdk.classes.CitrusUMResponse;
import com.citrus.sdk.classes.LinkUserExtendedResponse;
import com.citrus.sdk.classes.LinkUserPasswordType;
import com.citrus.sdk.classes.LinkUserResponse;
import com.citrus.sdk.classes.MemberInfo;
import com.citrus.sdk.classes.PGHealthResponse;
import com.citrus.sdk.classes.d;
import com.citrus.sdk.classes.f;
import com.citrus.sdk.classes.g;
import com.citrus.sdk.classes.h;
import com.citrus.sdk.classes.j;
import com.citrus.sdk.classes.o;
import com.citrus.sdk.classes.q;
import com.citrus.sdk.classes.s;
import com.citrus.sdk.cm;
import com.citrus.sdk.cn;
import com.citrus.sdk.cu;
import com.citrus.sdk.cv;
import com.citrus.sdk.dj;
import com.citrus.sdk.du;
import com.citrus.sdk.dx;
import com.citrus.sdk.dynamicPricing.DynamicPricingRequestType;
import com.citrus.sdk.dynamicPricing.DynamicPricingResponse;
import com.citrus.sdk.ei;
import com.citrus.sdk.em;
import com.citrus.sdk.login.AccessType;
import com.citrus.sdk.payment.CardOption;
import com.citrus.sdk.payment.CreditCardOption;
import com.citrus.sdk.payment.DebitCardOption;
import com.citrus.sdk.payment.MerchantPaymentOption;
import com.citrus.sdk.payment.NetbankingOption;
import com.citrus.sdk.payment.PaymentBill;
import com.citrus.sdk.payment.PaymentOption;
import com.citrus.sdk.payment.PaymentType;
import com.citrus.sdk.response.BindUserResponse;
import com.citrus.sdk.response.CitrusError;
import com.citrus.sdk.response.CitrusLogger;
import com.citrus.sdk.response.CitrusResponse;
import com.citrus.sdk.response.PaymentResponse;
import com.citrus.sdk.response.SubscriptionResponse;
import com.facebook.android.crypto.keychain.SharedPrefsBackedKeyChain;
import com.facebook.crypto.Crypto;
import com.facebook.crypto.Entity;
import com.facebook.crypto.exception.CryptoInitializationException;
import com.facebook.crypto.exception.KeyChainException;
import com.facebook.crypto.keychain.KeyChain;
import com.facebook.crypto.util.NativeCryptoLibrary;
import com.facebook.crypto.util.SystemNativeCryptoLibrary;
import com.orhanobut.logger.Logger;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CitrusClient
implements cm {
    private String signinId;
    private String signinSecret;
    private String signupId;
    private String signupSecret;
    private String vanity;
    private String merchantName;
    private Environment environment = Environment.SANDBOX;
    private Amount balanceAmount;
    private static CitrusClient instance;
    private final Context mContext;
    private MerchantPaymentOption merchantPaymentOption = null;
    private com.citrus.c.b oauthToken = null;
    private BroadcastReceiver paymentEventReceiver = null;
    private boolean initialized = false;
    private boolean showDummyScreen = false;
    private boolean autoOtpReading = false;
    private cu retrofitAPIWrapper = null;
    private PaymentOption persistPaymentOption = null;
    private boolean checkPrepaidTokenValidityCalled = false;
    private Crypto crypto = null;
    private q updateSubscriptionRequest = null;
    private ei subscriptionRequest = null;
    private SubscriptionResponse activeSubscription = null;
    public static boolean isCitrusNativeLibraryLoaded;
    public static boolean isFacebookNativeLibraryLoaded;
    public boolean isUserLoggedIn = false;
    private int mAUTO_load_type$18afc017 = 0;

    public Crypto getCrypto() {
        return this.crypto;
    }

    public q getUpdateSubscriptionRequest() {
        return this.updateSubscriptionRequest;
    }

    public ei getSubscriptionRequest() {
        return this.subscriptionRequest;
    }

    private CitrusClient(Context context) {
        this.mContext = context;
        this.retrofitAPIWrapper = cu.a(context);
        CitrusConfig.getInstance().setConfigChangeListener(this);
    }

    public void enableLog(boolean bl2) {
        if (bl2) {
            CitrusLogger.enableLogs();
            return;
        }
        CitrusLogger.disableLogs();
    }

    public void showDummyScreenWhilePayments(boolean bl2) {
        this.showDummyScreen = bl2;
    }

    public boolean isShowDummyScreenWhilePayments() {
        return this.showDummyScreen;
    }

    public boolean isAutoOtpReading() {
        return this.autoOtpReading;
    }

    public void enableAutoOtpReading(boolean bl2) {
        this.autoOtpReading = bl2;
    }

    public native String getEncryptionKey();

    public int getAUTO_load_type$5a427896() {
        return this.mAUTO_load_type$18afc017;
    }

    public void destroy() {
        this.initialized = false;
        this.signinId = null;
        this.signinSecret = null;
        this.signupId = null;
        this.signupSecret = null;
        this.vanity = null;
        this.environment = null;
        this.oauthToken = null;
        this.isUserLoggedIn = false;
        this.checkPrepaidTokenValidityCalled = false;
        this.retrofitAPIWrapper.b();
    }

    public void cancelAllRequests() {
        this.retrofitAPIWrapper.b();
    }

    public void init(@NonNull String string, @NonNull String string2, @NonNull String string3, @NonNull String string4, @NonNull String string5, @NonNull Environment environment) {
        if (!this.initialized) {
            this.oauthToken = new com.citrus.c.b(this.mContext);
            this.signupId = string;
            this.signupSecret = string2;
            this.signinId = string3;
            this.signinSecret = string4;
            this.vanity = string5;
            if (this.validate()) {
                this.retrofitAPIWrapper.a(string, string2, string3, string4, string5, environment);
            }
            if (!CitrusLogger.isEnableLogs()) {
                CitrusLogger.disableLogs();
            }
            if (environment == null) {
                this.environment = Environment.SANDBOX;
            }
            this.environment = environment;
            this.saveSDKEnvironment();
            this.isUserSignedIn(new bh(this));
            this.initialized = true;
        }
        if (environment != Environment.PRODUCTION) {
            Toast.makeText((Context)this.mContext, (CharSequence)("Environment is *** " + environment.toString()), (int)1).show();
        }
    }

    private void fetchPGHealthForAllBanks() {
        this.retrofitAPIWrapper.a.d();
    }

    private void saveSDKEnvironment() {
        if (this.oauthToken.a() == Environment.NONE) {
            this.oauthToken.a(this.environment);
            Logger.d((String)"NO ENVIRONMENT EXISTS earlier", (Object[])new Object[0]);
            return;
        }
        if (this.oauthToken.a() == this.environment) {
            Logger.d((String)"PREVIOUS AND CURRENT ENVIRONMENT IS SAME", (Object[])new Object[0]);
            return;
        }
        this.signOut(new bx(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CitrusClient getInstance(Context context) {
        if (instance != null) return instance;
        Class<CitrusClient> clazz = CitrusClient.class;
        synchronized (CitrusClient.class) {
            if (instance != null) return instance;
            instance = new CitrusClient(context);
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return instance;
        }
    }

    private void validateLinkUserCredentials(String string, String string2, Callback callback) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.sendError(callback, new CitrusError("Email ID should not be null.", CitrusResponse.Status.FAILED));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.sendError(callback, new CitrusError("Mobile number should not be null.", CitrusResponse.Status.FAILED));
            return;
        }
        if (!s.a((CharSequence)string) && !s.d(string2)) {
            this.sendError(callback, new CitrusError("Invalid Credentials entered.", CitrusResponse.Status.FAILED));
            return;
        }
        if (!s.a((CharSequence)string)) {
            this.sendError(callback, new CitrusError("Email is not in proper format.", CitrusResponse.Status.FAILED));
            return;
        }
        if (!s.d(string2)) {
            this.sendError(callback, new CitrusError("Mobile number is not in proper format.", CitrusResponse.Status.FAILED));
            return;
        }
        this.sendResponse(callback, true);
    }

    private void validateLinkBindUserCredentials(String string, String string2, AccessType accessType, Callback callback) {
        if (!s.a((CharSequence)string) && !s.d(string2)) {
            this.sendError(callback, new CitrusError("Invalid Credentials entered.", CitrusResponse.Status.FAILED));
            return;
        }
        if (!s.a((CharSequence)string)) {
            this.sendError(callback, new CitrusError("Email is not in proper format.", CitrusResponse.Status.FAILED));
            return;
        }
        if (!s.d(string2)) {
            this.sendError(callback, new CitrusError("Mobile number is not in proper format.", CitrusResponse.Status.FAILED));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string2) && accessType == AccessType.FULL) {
            this.sendError(callback, new CitrusError("Mobile No is required for Full Access.", CitrusResponse.Status.FAILED));
            return;
        }
        this.sendResponse(callback, true);
    }

    public synchronized void linkUserExtended(String string, String string2, Callback<LinkUserExtendedResponse> callback) {
        this.validateLinkUserCredentials(string, string2, new cc(this, string, string2, callback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkUserExtendedSignIn(LinkUserExtendedResponse linkUserExtendedResponse, LinkUserPasswordType object, String string, Callback<CitrusResponse> callback) {
        String string2 = linkUserExtendedResponse.getInputEmail();
        if (string == null || string.equalsIgnoreCase("")) {
            this.sendError(callback, new CitrusError(linkUserExtendedResponse.getLinkUserMessage(), CitrusResponse.Status.FAILED));
            return;
        }
        if (object == LinkUserPasswordType.None) {
            this.sendError(callback, new CitrusError(linkUserExtendedResponse.getLinkUserMessage(), CitrusResponse.Status.FAILED));
            return;
        }
        int n2 = linkUserExtendedResponse.formatResponseCode();
        switch (object) {
            case Otp: {
                if (n2 == 1 || n2 == 6 || n2 == 2 || n2 == 7) {
                    Logger.d((String)"old sigin, otp", (Object[])new Object[0]);
                    this.signInWithOTP(linkUserExtendedResponse, string, callback);
                    return;
                }
                if (n2 == 3 || n2 == 4 || n2 == 5 || n2 == 10 || n2 == 11 || n2 == 12) {
                    Logger.d((String)"verify and sigin, otp", (Object[])new Object[0]);
                    object = this;
                    synchronized (object) {
                        this.linkUserExtendedVerifyMobileAndSignIn(linkUserExtendedResponse, string, callback);
                        return;
                    }
                }
                if (n2 != 8 && n2 != 9) break;
                Logger.d((String)"Update mobile sigin, e-otp", (Object[])new Object[0]);
                object = com.citrus.c.a.onetimepass.toString();
                CitrusClient citrusClient = this;
                synchronized (citrusClient) {
                    this.linkUserExtendedVerifyEOTPAndUpdateMobile(string2, (String)object, string, linkUserExtendedResponse, callback);
                    return;
                }
            }
            case Password: {
                if (n2 == 1 || n2 == 6 || n2 == 2 || n2 == 5) {
                    Logger.d((String)"old sigin, password", (Object[])new Object[0]);
                    this.signIn(string2, string, callback);
                    return;
                }
                if (n2 != 8) break;
                Logger.d((String)"Update mobile sigin, password", (Object[])new Object[0]);
                object = com.citrus.c.a.password.toString();
                CitrusClient citrusClient = this;
                synchronized (citrusClient) {
                    this.linkUserExtendedVerifyEOTPAndUpdateMobile(string2, (String)object, string, linkUserExtendedResponse, callback);
                    return;
                }
            }
        }
    }

    public void linkUserExtendedVerifyEOTPAndUpdateMobile(String object, String string, String string2, LinkUserExtendedResponse object2, Callback<CitrusResponse> object3) {
        Callback<CitrusResponse> callback = object3;
        object3 = object2;
        object2 = string2;
        string2 = string;
        string = object;
        object = this.retrofitAPIWrapper;
        ((cu)object).b.a(string, string2, (String)object2, (LinkUserExtendedResponse)object3, new cv((cu)object, callback));
        this.checkPrepaidTokenValidityCalled = true;
        this.isUserLoggedIn = true;
    }

    public synchronized void linkUserExtendedVerifyMobileAndSignIn(LinkUserExtendedResponse object, String object2, Callback<CitrusResponse> object3) {
        Callback<CitrusResponse> callback = object3;
        object3 = object2;
        object2 = object;
        object = this.retrofitAPIWrapper;
        ((cu)object).b.a((LinkUserExtendedResponse)object2, (String)object3, new dj((cu)object, callback));
        this.checkPrepaidTokenValidityCalled = true;
        this.isUserLoggedIn = true;
    }

    public synchronized void isCitrusMember(String string, String string2, Callback<Boolean> callback) {
        this.retrofitAPIWrapper.b(string, string2, callback);
    }

    public synchronized void getMemberInfo(String string, String string2, Callback<MemberInfo> callback) {
        this.retrofitAPIWrapper.c(string, string2, callback);
    }

    public synchronized void bindUser(String string, String string2, Callback<String> callback) {
        this.retrofitAPIWrapper.a(string, string2, callback);
    }

    public synchronized void bindUserByMobile(String string, String string2, Callback<BindUserResponse> callback) {
        this.retrofitAPIWrapper.d(string, string2, callback);
    }

    public synchronized void linkUserWithOTP(String string, String string2, boolean bl2, Callback<LinkUserResponse> callback) {
        this.retrofitAPIWrapper.a(string, string2, bl2, callback);
    }

    public synchronized void signIn(String string, String string2, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.f(string, string2, callback);
        this.checkPrepaidTokenValidityCalled = true;
        this.isUserLoggedIn = true;
    }

    public synchronized void signInWithMobileNo(String string, String string2, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.g(string, string2, callback);
        this.checkPrepaidTokenValidityCalled = true;
        this.isUserLoggedIn = true;
    }

    public synchronized void signInWithOTP(LinkUserExtendedResponse object, String string, Callback<CitrusResponse> callback) {
        object = ((LinkUserExtendedResponse)object).getLinkUserMobile();
        this.retrofitAPIWrapper.h((String)object, string, callback);
        this.checkPrepaidTokenValidityCalled = true;
        this.isUserLoggedIn = true;
    }

    public synchronized void signOut(Callback<CitrusResponse> callback) {
        this.isUserLoggedIn = false;
        this.checkPrepaidTokenValidityCalled = false;
        this.activeSubscription = null;
        this.retrofitAPIWrapper.c(callback);
    }

    public synchronized void signUp(String string, String string2, String string3, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.a(string, string2, string3, callback);
    }

    public synchronized void resetPassword(String string, @NonNull Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.a(string, callback);
    }

    public synchronized void updateMobile(String string, Callback<String> callback) {
        this.retrofitAPIWrapper.b(string, callback);
    }

    public synchronized void verifyMobile(String string, Callback<String> callback) {
        this.retrofitAPIWrapper.c(string, callback);
    }

    public synchronized void getWallet(Callback<List<PaymentOption>> callback) {
        this.retrofitAPIWrapper.j(callback);
    }

    public synchronized void getWalletWithDefaultBank(Callback<List<PaymentOption>> callback, com.citrus.sdk.b b2) {
        this.retrofitAPIWrapper.k(callback);
    }

    @Deprecated
    public synchronized void activatePrepaidUser(Callback<Amount> callback) {
        this.retrofitAPIWrapper.f(callback);
    }

    public synchronized void getProfileInfo(Callback<CitrusUser> callback) {
        this.retrofitAPIWrapper.b(callback);
    }

    public synchronized void getBalance(Callback<Amount> callback) {
        this.retrofitAPIWrapper.e(callback);
    }

    public synchronized void savePaymentOption(PaymentOption paymentOption, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.a(paymentOption, callback);
    }

    private synchronized void saveCard(PaymentOption paymentOption, Callback<com.citrus.sdk.a> callback) {
        if (CitrusConfig.getInstance().isOneTapPaymentEnabled() && this.isOneTapPaymentSupported()) {
            this.retrofitAPIWrapper.b(paymentOption, callback);
        }
    }

    public synchronized void deletePaymentOption(PaymentOption paymentOption, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.c(paymentOption, callback);
    }

    public synchronized void getBill(String string, Amount amount, String string2, Callback<PaymentBill> callback) {
        this.retrofitAPIWrapper.a(string, amount, string2, callback);
    }

    public synchronized void performDynamicPricing(@NonNull DynamicPricingRequestType dynamicPricingRequestType, @NonNull String string, @NonNull Callback<DynamicPricingResponse> callback) {
        this.retrofitAPIWrapper.a(dynamicPricingRequestType, string, callback);
    }

    public synchronized void performDynamicPricing(@NonNull DynamicPricingRequestType dynamicPricingRequestType, @NonNull PaymentBill paymentBill, @NonNull Callback<DynamicPricingResponse> callback) {
        this.retrofitAPIWrapper.a(dynamicPricingRequestType, paymentBill, callback);
    }

    public synchronized void sendMoney(Amount amount, CitrusUser citrusUser, String string, Callback<PaymentResponse> callback) {
        this.retrofitAPIWrapper.a(amount, citrusUser, string, callback);
    }

    public synchronized void sendMoneyToMoblieNo(Amount amount, String string, String string2, Callback<PaymentResponse> callback) {
        this.retrofitAPIWrapper.a(amount, string, string2, callback);
    }

    public void getPrepaidToken(Callback<AccessToken> callback) {
        this.retrofitAPIWrapper.a(callback);
    }

    public synchronized void getMerchantPaymentOptions(Callback<MerchantPaymentOption> callback) {
        this.retrofitAPIWrapper.h(callback);
    }

    public synchronized void getLoadMoneyPaymentOptions(Callback<MerchantPaymentOption> callback) {
        this.retrofitAPIWrapper.i(callback);
    }

    public synchronized void isUserSignedIn(Callback<Boolean> callback) {
        this.getPrepaidToken(new cd(this, callback));
    }

    public synchronized void loadMoney(PaymentType.LoadMoney loadMoney, Callback<TransactionResponse> callback) {
        if (loadMoney != null) {
            PaymentOption paymentOption;
            this.persistPaymentOption = paymentOption = loadMoney.getPaymentOption();
            if (paymentOption instanceof CardOption && !((CardOption)paymentOption).validateCard()) {
                this.sendError(callback, new CitrusError(((CardOption)paymentOption).getCardValidityFailureReasons(), CitrusResponse.Status.FAILED));
                this.subscriptionRequest = null;
                this.mAUTO_load_type$18afc017 = 0;
                return;
            }
            if (!this.validatePaymentOptionForMerchant(paymentOption, this.retrofitAPIWrapper.a(loadMoney))) {
                this.sendError(callback, new CitrusError("This Payment Option is not Supported. Please use another payment option.", CitrusResponse.Status.FAILED));
                return;
            }
        }
        if (this.mAUTO_load_type$18afc017 == 0) {
            this.mAUTO_load_type$18afc017 = a.LAZY_AUTO_LOAD$18afc017;
        }
        this.createAutoLoadRequest(loadMoney.getPaymentOption());
        this.registerReceiver(callback, new IntentFilter(loadMoney.getIntentAction()));
        this.startCitrusActivity(loadMoney, false);
    }

    public synchronized void loadMoneyWithOneTap(PaymentType.LoadMoney loadMoney, Callback<TransactionResponse> callback) {
        if (loadMoney != null) {
            if (loadMoney.getPaymentOption() instanceof CardOption) {
                if (loadMoney.getPaymentOption().getFingerPrint() == null) {
                    this.sendError(callback, new CitrusError("This payment is available only for saved cards", CitrusResponse.Status.FAILED));
                    return;
                }
                if (this.getCVVOfFingerPrint((CardOption)loadMoney.getPaymentOption()) == null) {
                    this.sendError(callback, new CitrusError("CVV does not exist for this saved Card", CitrusResponse.Status.FAILED));
                    return;
                }
                ((CardOption)loadMoney.getPaymentOption()).setCardCVV(this.getCVVOfFingerPrint((CardOption)loadMoney.getPaymentOption()));
                this.persistPaymentOption = loadMoney.getPaymentOption();
                this.loadMoney(loadMoney, callback);
                return;
            }
            this.sendError(callback, new CitrusError("One tap payment is available only for Card Payment", CitrusResponse.Status.FAILED));
            return;
        }
        this.sendError(callback, new CitrusError("PaymentOption is null.", CitrusResponse.Status.FAILED));
    }

    public synchronized void pgPayment(PaymentType.PGPayment pGPayment, Callback<TransactionResponse> callback) {
        if (pGPayment != null) {
            PaymentOption paymentOption;
            this.persistPaymentOption = paymentOption = pGPayment.getPaymentOption();
            if (paymentOption instanceof CardOption && !((CardOption)paymentOption).validateCard()) {
                this.sendError(callback, new CitrusError(((CardOption)paymentOption).getCardValidityFailureReasons(), CitrusResponse.Status.FAILED));
                return;
            }
            if (!this.validatePaymentOptionForMerchant(paymentOption, this.retrofitAPIWrapper.a(pGPayment))) {
                this.sendError(callback, new CitrusError("This Payment Option is not Supported. Please use another payment option.", CitrusResponse.Status.FAILED));
                return;
            }
        }
        this.registerReceiver(callback, new IntentFilter(pGPayment.getIntentAction()));
        this.startCitrusActivity(pGPayment, false);
    }

    public synchronized void pgPaymentWithOneTap(PaymentType.PGPayment pGPayment, Callback<TransactionResponse> callback) {
        if (pGPayment != null) {
            if (pGPayment.getPaymentOption() instanceof CardOption) {
                if (pGPayment.getPaymentOption().getFingerPrint() == null) {
                    this.sendError(callback, new CitrusError("This payment is available only for saved cards", CitrusResponse.Status.FAILED));
                    return;
                }
                if (this.getCVVOfFingerPrint((CardOption)pGPayment.getPaymentOption()) == null) {
                    this.sendError(callback, new CitrusError("CVV does not exist for this saved Card", CitrusResponse.Status.FAILED));
                    return;
                }
                ((CardOption)pGPayment.getPaymentOption()).setCardCVV(this.getCVVOfFingerPrint((CardOption)pGPayment.getPaymentOption()));
                this.persistPaymentOption = pGPayment.getPaymentOption();
                this.pgPayment(pGPayment, callback);
                return;
            }
            this.sendError(callback, new CitrusError("One tap payment is available only for Card Payment", CitrusResponse.Status.FAILED));
            return;
        }
        this.sendError(callback, new CitrusError("PaymentOption is null.", CitrusResponse.Status.FAILED));
    }

    @Deprecated
    public synchronized void pgPayment(DynamicPricingResponse object, Callback<TransactionResponse> callback) {
        if (object != null) {
            Object object2 = ((DynamicPricingResponse)object).getPaymentBill();
            try {
                object2 = new PaymentType.PGPayment((PaymentBill)object2, ((DynamicPricingResponse)object).getPaymentOption(), ((DynamicPricingResponse)object).getCitrusUser());
                this.registerReceiver(callback, new IntentFilter(((PaymentType.PGPayment)object2).getIntentAction()));
                this.startCitrusActivity((PaymentType)object2, (DynamicPricingResponse)object, false);
                return;
            }
            catch (CitrusException citrusException) {
                object = citrusException;
                citrusException.printStackTrace();
                this.sendError(callback, new CitrusError(((Throwable)object).getMessage(), CitrusResponse.Status.FAILED));
                return;
            }
        }
        this.sendError(callback, new CitrusError("Dynamic Pricing Response can not be null", CitrusResponse.Status.FAILED));
    }

    private synchronized void walletPGCharge(em em2, Callback<TransactionResponse> callback) {
        BigDecimal bigDecimal;
        PaymentOption paymentOption = em2.a;
        if (paymentOption != null) {
            if (paymentOption instanceof CardOption && !((CardOption)paymentOption).validateCard()) {
                this.sendError(callback, new CitrusError(((CardOption)paymentOption).getCardValidityFailureReasons(), CitrusResponse.Status.FAILED));
                return;
            }
            if (!this.validatePaymentOptionForMerchant(paymentOption, this.retrofitAPIWrapper.a(em2))) {
                this.sendError(callback, new CitrusError("This Payment Option is not Supported. Please use another payment option.", CitrusResponse.Status.FAILED));
                return;
            }
        }
        em em3 = em2;
        BigDecimal bigDecimal2 = new BigDecimal(em3.d.getValue());
        BigDecimal bigDecimal3 = BigDecimal.ZERO;
        if (em3.a != null && em3.a.getTransactionAmount() != null) {
            bigDecimal = new BigDecimal(em3.a.getTransactionAmount().getValue());
            bigDecimal3 = bigDecimal3.add(bigDecimal);
        }
        if (em3.c != null && em3.c.getTransactionAmount() != null) {
            bigDecimal = new BigDecimal(em3.c.getTransactionAmount().getValue());
            bigDecimal3 = bigDecimal3.add(bigDecimal);
        }
        if (em3.b != null && em3.b.getTransactionAmount() != null) {
            bigDecimal = new BigDecimal(em3.b.getTransactionAmount().getValue());
            bigDecimal3 = bigDecimal3.add(bigDecimal);
        }
        if (!(bigDecimal2.compareTo(bigDecimal3) == 0)) {
            this.sendError(callback, new CitrusError("Total Transaction of all the payment options should be equal to actual transaction amount.", CitrusResponse.Status.FAILED));
            return;
        }
        this.persistPaymentOption = paymentOption;
        this.registerReceiver(callback, new IntentFilter(em2.getIntentAction()));
        this.startCitrusActivity(em2, false);
    }

    public synchronized void makePayment(PaymentType.PGPayment pGPayment, Callback<TransactionResponse> callback) {
        if (pGPayment != null) {
            PaymentOption paymentOption;
            this.persistPaymentOption = paymentOption = pGPayment.getPaymentOption();
            if (paymentOption instanceof CardOption && !((CardOption)paymentOption).validateCard()) {
                this.sendError(callback, new CitrusError(((CardOption)paymentOption).getCardValidityFailureReasons(), CitrusResponse.Status.FAILED));
                return;
            }
            if (!this.validatePaymentOptionForMerchant(paymentOption, this.retrofitAPIWrapper.a(pGPayment))) {
                this.sendError(callback, new CitrusError("This Payment Option is not Supported. Please use another payment option.", CitrusResponse.Status.FAILED));
                return;
            }
        }
        this.registerReceiver(callback, new IntentFilter(pGPayment.getIntentAction()));
        this.startCitrusActivity(pGPayment, true);
    }

    public synchronized void makePaymentWithOneTap(PaymentType.PGPayment pGPayment, Callback<TransactionResponse> callback) {
        if (pGPayment != null) {
            PaymentOption paymentOption = pGPayment.getPaymentOption();
            if (paymentOption instanceof CardOption) {
                CardOption cardOption = (CardOption)paymentOption;
                if (cardOption.getFingerPrint() == null) {
                    this.sendError(callback, new CitrusError("This payment is available only for saved cards", CitrusResponse.Status.FAILED));
                    return;
                }
                if (this.getCVVOfFingerPrint(cardOption) == null) {
                    this.sendError(callback, new CitrusError("CVV does not exist for this saved Card", CitrusResponse.Status.FAILED));
                    return;
                }
                ((CardOption)paymentOption).setCardCVV(this.getCVVOfFingerPrint(cardOption));
                this.persistPaymentOption = paymentOption;
            }
            if (paymentOption instanceof CardOption && !((CardOption)paymentOption).validateCard()) {
                this.sendError(callback, new CitrusError(((CardOption)paymentOption).getCardValidityFailureReasons(), CitrusResponse.Status.FAILED));
                return;
            }
        }
        this.registerReceiver(callback, new IntentFilter(pGPayment.getIntentAction()));
        this.startCitrusActivity(pGPayment, true);
    }

    private void isEnoughPrepaidBalance(Amount amount, Callback<Boolean> callback) {
        this.getBalance(new ce(this, amount, callback));
    }

    @Deprecated
    public synchronized void prepaidPay(PaymentType.CitrusCash citrusCash, Callback<PaymentResponse> callback) {
        this.getProfileInfo(new cf(this, citrusCash, callback));
    }

    private void proceedWithNewPrepaidPay(PaymentType.CitrusCash citrusCash, Callback<PaymentResponse> callback) {
        if (!this.checkPrepaidTokenValidityCalled) {
            this.checkPrepaymentTokenValidity(new cg(this, citrusCash, callback));
            this.checkPrepaidTokenValidityCalled = true;
            return;
        }
        this.retrofitAPIWrapper.a(citrusCash, callback);
    }

    private void checkPrepaymentTokenValidity(Callback<Boolean> callback) {
        this.retrofitAPIWrapper.d(callback);
    }

    public synchronized void cashout(@NonNull CashoutInfo cashoutInfo, Callback<PaymentResponse> callback) {
        this.retrofitAPIWrapper.a(cashoutInfo, callback);
    }

    public synchronized void getCashoutInfo(Callback<CashoutInfo> callback) {
        this.retrofitAPIWrapper.g(callback);
    }

    public synchronized void saveCashoutInfo(CashoutInfo cashoutInfo, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.b(cashoutInfo, callback);
    }

    public synchronized void getPGHealth(PaymentOption paymentOption, Callback<PGHealthResponse> callback) {
        this.retrofitAPIWrapper.e(paymentOption, callback);
    }

    public void getBINDetails(CardOption cardOption, Callback<g> callback) {
        this.retrofitAPIWrapper.a(cardOption, callback);
    }

    public com.citrus.sdk.otp.a getNetBankForOTP() {
        return this.retrofitAPIWrapper.c;
    }

    public void resetNetBankForOTP() {
        this.retrofitAPIWrapper.c = com.citrus.sdk.otp.a.UNKNOWN;
    }

    public synchronized String getUserEmailId() {
        CitrusUser citrusUser = this.getCitrusUser();
        if (citrusUser != null) {
            return citrusUser.getEmailId();
        }
        return null;
    }

    public synchronized String getUserMobileNumber() {
        CitrusUser citrusUser = this.getCitrusUser();
        if (citrusUser != null) {
            return citrusUser.getMobileNo();
        }
        return null;
    }

    public synchronized CitrusUser getCitrusUser() {
        return this.retrofitAPIWrapper.b.e;
    }

    private void unregisterReceiver(BroadcastReceiver broadcastReceiver) {
        LocalBroadcastManager.getInstance((Context)this.mContext).unregisterReceiver(broadcastReceiver);
    }

    private void startCitrusActivity(PaymentType paymentType, DynamicPricingResponse dynamicPricingResponse, boolean bl2) {
        this.getProfileInfo(new ch(this, paymentType, dynamicPricingResponse, bl2));
    }

    private void startCitrusActivity(PaymentType paymentType, boolean bl2) {
        if (!bl2 && paymentType instanceof PaymentType.PGPayment && ((PaymentType.PGPayment)paymentType).isSingleHop()) {
            bl2 = true;
        }
        this.startCitrusActivity(paymentType, null, bl2);
    }

    private <T> void registerReceiver(Callback<T> callback, IntentFilter intentFilter) {
        this.paymentEventReceiver = new ci(this, callback);
        LocalBroadcastManager.getInstance((Context)this.mContext).registerReceiver(this.paymentEventReceiver, intentFilter);
    }

    private synchronized boolean validate() {
        if (!(TextUtils.isEmpty((CharSequence)this.signinId) || TextUtils.isEmpty((CharSequence)this.signinSecret) || TextUtils.isEmpty((CharSequence)this.signupId) || TextUtils.isEmpty((CharSequence)this.signupSecret) || TextUtils.isEmpty((CharSequence)this.vanity))) {
            return true;
        }
        throw new IllegalArgumentException("Please make sure SignIn Id, SignIn Secret, SignUp Id, SignUp Secret & Vanity are not blank");
    }

    private <T> void sendResponse(Callback callback, T t2) {
        if (callback != null) {
            callback.success(t2);
        }
    }

    private void sendError(Callback callback, CitrusError citrusError) {
        if (callback != null) {
            callback.error(citrusError);
        }
    }

    public synchronized void resetUserPassword(String string, @NonNull Callback<CitrusUMResponse> callback) {
        this.retrofitAPIWrapper.d(string, callback);
    }

    public synchronized void setDefaultPaymentOption(PaymentOption paymentOption, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.d(paymentOption, callback);
    }

    public synchronized void signUpUser(String string, String string2, String string3, String string4, String string5, String string6, boolean bl2, boolean bl3, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.a(string, string2, string3, string4, string5, string6, bl2, bl3, callback);
    }

    public synchronized void changePassword(String string, String string2, Callback<CitrusUMResponse> callback) {
        this.retrofitAPIWrapper.i(string, string2, callback);
    }

    public synchronized void updateProfileInfo(String string, String string2, Callback<CitrusUMResponse> callback) {
        this.retrofitAPIWrapper.j(string, string2, callback);
    }

    public synchronized void sendOneTimePassword(String string, String string2, String string3, Callback<CitrusUMResponse> callback) {
        this.retrofitAPIWrapper.b(string, string2, string3, callback);
    }

    public synchronized void getCardType(String string, Callback<h> callback) {
        this.retrofitAPIWrapper.e(string, callback);
    }

    public synchronized void getMerchantName(Callback<String> callback) {
        this.retrofitAPIWrapper.m(callback);
    }

    public synchronized void makeWalletPGPayment(String string, Callback<b> callback) {
        this.retrofitAPIWrapper.h(string, callback);
    }

    public synchronized void makeMOTOPayment(String string, Callback<o> callback) {
        this.retrofitAPIWrapper.f(string, callback);
    }

    synchronized void newMakePayment(String string, Callback<String> callback) {
        this.retrofitAPIWrapper.g(string, callback);
    }

    public synchronized void getPrepaidBill(Amount amount, String string, Callback<j> callback) {
        this.retrofitAPIWrapper.a(amount, string, callback);
    }

    public String getSigninId() {
        return this.signinId;
    }

    public void setSigninId(String string) {
        this.signinId = string;
    }

    public String getSigninSecret() {
        return this.signinSecret;
    }

    public void setSigninSecret(String string) {
        this.signinSecret = string;
    }

    public String getSignupId() {
        return this.signupId;
    }

    public void setSignupId(String string) {
        this.signupId = string;
    }

    public String getSignupSecret() {
        return this.signupSecret;
    }

    public void setSignupSecret(String string) {
        this.signupSecret = string;
    }

    public String getVanity() {
        return this.vanity;
    }

    public void setVanity(String string) {
        this.vanity = string;
    }

    public String getMerchantName() {
        return this.merchantName;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    private String generateDeviceSpecificKeys() {
        String string = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
        String string2 = Build.BOARD + Build.BRAND + Build.CPU_ABI + Build.DEVICE + Build.DISPLAY + Build.FINGERPRINT + Build.HOST + Build.ID + Build.MANUFACTURER + Build.MODEL + Build.PRODUCT + Build.TAGS + Build.TYPE + Build.USER;
        return string2 + string;
    }

    private void initCrypto() {
        this.crypto = new Crypto((KeyChain)new SharedPrefsBackedKeyChain(this.mContext), (NativeCryptoLibrary)new SystemNativeCryptoLibrary());
        if (this.crypto.isAvailable()) {
            isFacebookNativeLibraryLoaded = true;
            return;
        }
        isFacebookNativeLibraryLoaded = false;
        this.crypto = null;
    }

    private void saveCVV(String object, String object2) {
        if (!(CitrusConfig.getInstance().isOneTapPaymentEnabled() && isFacebookNativeLibraryLoaded && isCitrusNativeLibraryLoaded)) {
            return;
        }
        Object object3 = this.generateDeviceSpecificKeys() + (String)object + this.getEncryptionKey();
        object3 = new Entity((String)object3);
        try {
            object = this.crypto.encrypt(((String)object).getBytes(), (Entity)object3);
            byte[] byArray = this.crypto.encrypt(((String)object2).getBytes(), (Entity)object3);
            this.crypto.encrypt(((String)object2).getBytes(), (Entity)object3);
            object3 = byArray;
            object2 = object;
            object = this.oauthToken;
            object2 = Base64.encodeToString((byte[])object2, (int)0);
            object3 = Base64.encodeToString((byte[])object3, (int)0);
            object = ((com.citrus.c.b)object).a.edit();
            object.putString((String)object2, (String)object3);
            object.commit();
            return;
        }
        catch (KeyChainException keyChainException) {
            Logger.d((String)"KeyChainException ", (Object[])new Object[0]);
            return;
        }
        catch (CryptoInitializationException cryptoInitializationException) {
            Logger.d((String)"CryptoInitializationException", (Object[])new Object[0]);
            return;
        }
        catch (IOException iOException) {
            Logger.d((String)"IOException", (Object[])new Object[0]);
            return;
        }
    }

    private String getCVVOfFingerPrint(CardOption object) {
        String string = null;
        try {
            if (!(CitrusConfig.getInstance().isOneTapPaymentEnabled() && isFacebookNativeLibraryLoaded && isCitrusNativeLibraryLoaded)) {
                return null;
            }
            String string2 = this.generateDeviceSpecificKeys() + ((PaymentOption)object).getFingerPrint() + this.getEncryptionKey();
            Entity entity = new Entity(string2);
            byte[] byArray = this.oauthToken.a(((PaymentOption)object).getFingerPrint(), string2);
            object = byArray;
            if (byArray != null) {
                object = this.crypto.decrypt((byte[])object, entity);
                string = new String((byte[])object);
            } else {
                string = null;
            }
        }
        catch (KeyChainException keyChainException) {
            Logger.d((String)"KeyChainException ", (Object[])new Object[0]);
        }
        catch (CryptoInitializationException cryptoInitializationException) {
            Logger.d((String)"CryptoInitializationException", (Object[])new Object[0]);
        }
        catch (IOException iOException) {
            Logger.d((String)"IOException", (Object[])new Object[0]);
        }
        return string;
    }

    public synchronized boolean isOneTapPaymentEnabledForCard(CardOption cardOption) {
        if (cardOption != null) {
            return this.getCVVOfFingerPrint(cardOption) != null;
        }
        return false;
    }

    public synchronized boolean isOneTapPaymentSupported() {
        return isCitrusNativeLibraryLoaded && isFacebookNativeLibraryLoaded;
    }

    @Override
    public void onOneTapPaymentEnabled(boolean bl2) {
        if (bl2) {
            try {
                System.loadLibrary("citruslibrary");
                isCitrusNativeLibraryLoaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                isCitrusNativeLibraryLoaded = false;
            }
            this.initCrypto();
            if (this.isOneTapPaymentSupported()) {
                Logger.d((String)"This device supports One Tap Payment.", (Object[])new Object[0]);
                return;
            }
            Logger.d((String)"This device does not support One Tap Payment.", (Object[])new Object[0]);
        }
    }

    private synchronized boolean validatePaymentOptionForMerchant(PaymentOption object, MerchantPaymentOption set) {
        if (object != null) {
            if (set != null) {
                if (object instanceof CreditCardOption) {
                    object = ((CreditCardOption)object).getCardScheme();
                    if ((set = ((MerchantPaymentOption)((Object)set)).getCreditCardSchemeSet()) != null) {
                        return set.contains(object);
                    }
                    return true;
                }
                if (object instanceof DebitCardOption) {
                    object = ((DebitCardOption)object).getCardScheme();
                    if ((set = ((MerchantPaymentOption)((Object)set)).getDebitCardSchemeSet()) != null) {
                        return set.contains(object);
                    }
                    return true;
                }
                if (object instanceof NetbankingOption) {
                    if (!((PaymentOption)object).isTokenizedPayment()) {
                        return (set = ((MerchantPaymentOption)((Object)set)).getBankCIDSet()) == null || set.contains(((NetbankingOption)object).getBankCID());
                    }
                    return ((MerchantPaymentOption)((Object)set)).getNetbankingOptionList().contains(object);
                }
            }
            return true;
        }
        return false;
    }

    void makeBlazeCardPayment(String string, Callback<f> callback) {
        cu.c();
    }

    void makeBlazeCardTokenizedPayment(String string, Callback<f> callback) {
        cu.d();
    }

    void cancelBCTransaction(String string, Callback<d> callback) {
        cu.e();
    }

    public void simpliPay(PaymentType paymentType, Callback<TransactionResponse> callback) {
        if (paymentType instanceof PaymentType.SplitPayment) {
            if (!this.preValidation(paymentType.getPaymentOption(), this.retrofitAPIWrapper.a(paymentType), callback)) {
                return;
            }
            if (!this.updateOneTapPaymentOption(paymentType.getPaymentOption(), callback)) {
                return;
            }
            this.createWalletPGPaymentOption(paymentType, callback);
            return;
        }
        if (paymentType instanceof PaymentType.LoadMoney) {
            if (!this.preValidation(paymentType.getPaymentOption(), this.retrofitAPIWrapper.a(paymentType), callback)) {
                return;
            }
            if (!this.updateOneTapPaymentOption(paymentType.getPaymentOption(), callback)) {
                return;
            }
            this.loadMoney((PaymentType.LoadMoney)paymentType, callback);
            return;
        }
        if (paymentType instanceof PaymentType.CitrusCash) {
            if (!this.validateLogin(callback)) {
                return;
            }
            try {
                paymentType = paymentType.getPaymentBill() == null ? new PaymentType.SplitPayment(paymentType.getAmount(), paymentType.getUrl(), null, true, false) : new PaymentType.SplitPayment(paymentType.getPaymentBill(), null, true, false);
                this.createWalletPGPaymentOption(paymentType, callback);
                return;
            }
            catch (CitrusException citrusException) {
                citrusException.printStackTrace();
                return;
            }
        }
        if (paymentType instanceof PaymentType.PGPayment) {
            if (!this.validatePaymentOptions((paymentType = (PaymentType.PGPayment)paymentType).getPaymentOption(), this.retrofitAPIWrapper.a(paymentType), callback)) {
                return;
            }
            if (!this.updateOneTapPaymentOption(paymentType.getPaymentOption(), callback)) {
                return;
            }
            if (this.isUserLoggedIn && paymentType.getPaymentOption().isTokenizedPayment() && !((PaymentType.PGPayment)paymentType).isDyanmicPricingRequest()) {
                paymentType = new PaymentType.SplitPayment((PaymentType.PGPayment)paymentType);
                this.createWalletPGPaymentOption(paymentType, callback);
                return;
            }
            if (((PaymentType.PGPayment)paymentType).isDyanmicPricingRequest()) {
                this.pgPayment(((PaymentType.PGPayment)paymentType).getDynamicPricingResponse(), callback);
                return;
            }
            this.pgPayment((PaymentType.PGPayment)paymentType, callback);
        }
    }

    private void createWalletPGPaymentOption(PaymentType paymentType, Callback<TransactionResponse> callback) {
        if (((PaymentType.SplitPayment)paymentType).isCitrusCashEnabled() || ((PaymentType.SplitPayment)paymentType).isMVCEnabled()) {
            this.getWallet(new bi(this, paymentType, callback));
            return;
        }
        if (paymentType.getPaymentOption().isTokenizedPayment()) {
            ArrayList<PaymentOption> arrayList = new ArrayList<PaymentOption>();
            if (paymentType.getPaymentOption().getTransactionAmount() == null) {
                paymentType.getPaymentOption().setTransactionAmount(paymentType.getAmount());
            }
            arrayList.add(paymentType.getPaymentOption());
            try {
                paymentType = new em((PaymentType.SplitPayment)paymentType, arrayList);
                this.walletPGCharge((em)paymentType, callback);
                return;
            }
            catch (CitrusException citrusException) {
                citrusException.printStackTrace();
                return;
            }
        }
        try {
            this.pgPayment(new PaymentType.PGPayment((PaymentType.SplitPayment)paymentType), callback);
            return;
        }
        catch (CitrusException citrusException) {
            citrusException.printStackTrace();
            return;
        }
    }

    boolean validateLogin(Callback callback) {
        if (!this.isUserLoggedIn) {
            this.sendError(callback, new CitrusError("Have you Signed In? Token not found!!!", CitrusResponse.Status.FAILED));
            return false;
        }
        return true;
    }

    boolean validatePaymentOptions(PaymentOption paymentOption, MerchantPaymentOption merchantPaymentOption, Callback callback) {
        if (paymentOption != null && !this.validatePaymentOptionForMerchant(paymentOption, merchantPaymentOption)) {
            this.sendError(callback, new CitrusError("This Payment Option is not Supported. Please use another payment option.", CitrusResponse.Status.FAILED));
            return false;
        }
        return true;
    }

    boolean preValidation(PaymentOption paymentOption, MerchantPaymentOption merchantPaymentOption, Callback callback) {
        if (this.validateLogin(callback)) {
            return this.validatePaymentOptions(paymentOption, merchantPaymentOption, callback);
        }
        return false;
    }

    boolean updateOneTapPaymentOption(PaymentOption paymentOption, Callback callback) {
        if (!CitrusConfig.getInstance().isOneTapPaymentEnabled()) {
            return true;
        }
        if (!(paymentOption instanceof CardOption)) {
            return true;
        }
        if (((CardOption)paymentOption).getCardScheme() == CardOption.CardScheme.MAESTRO) {
            return true;
        }
        if (((CardOption)paymentOption).getCardCVV() != null) {
            return true;
        }
        if (this.getCVVOfFingerPrint((CardOption)paymentOption) == null) {
            this.sendError(callback, new CitrusError("CVV does not exist for this saved Card", CitrusResponse.Status.FAILED));
            return false;
        }
        ((CardOption)paymentOption).setCardCVV(this.getCVVOfFingerPrint((CardOption)paymentOption));
        return true;
    }

    public void getPaymentDistribution(Amount amount, Callback<PaymentDistribution> callback) {
        this.getWallet(new bj(this, amount, callback));
    }

    public void getActiveSubscriptions(Callback<SubscriptionResponse> callback) {
        this.retrofitAPIWrapper.n(new bk(this, callback));
    }

    public void deActivateSubscription(Callback<SubscriptionResponse> callback) {
        this.isActiveSubscriptionPresent(new bl(this, callback));
    }

    private void createAutoLoadSubscription(Callback object, TransactionResponse object2) {
        object = new bn(this, (TransactionResponse)object2, (Callback)object);
        Callback callback = object;
        object2 = this.subscriptionRequest;
        object = this.retrofitAPIWrapper;
        ((cu)object).a(new du((cu)object, (ei)object2, callback));
    }

    private void updateAutoLoadSubscriptiontoHigherValue(Callback object, TransactionResponse object2) {
        object = new bo(this, (TransactionResponse)object2, (Callback)object);
        Callback callback = object;
        object2 = this.updateSubscriptionRequest;
        object = this.retrofitAPIWrapper;
        ((cu)object).a(new dx((cu)object, (q)object2, callback));
    }

    public void isActiveSubscriptionPresent(Callback<Boolean> callback) {
        if (this.activeSubscription != null) {
            callback.success(true);
            return;
        }
        this.retrofitAPIWrapper.n(new bp(this, callback));
    }

    public synchronized void autoLoadMoney(PaymentType.LoadMoney loadMoney, Amount amount, Amount amount2, Callback<SubscriptionResponse> callback) throws CitrusException {
        if (amount == null) {
            throw new CitrusException("ThresHold should not be null or empty.");
        }
        if (amount2 == null) {
            throw new CitrusException("LoadAmount should not be null or empty.");
        }
        if (amount2.compareTo(amount) < 0) {
            throw new CitrusException("LoadAmount should not be less than ThresHold amount.");
        }
        Double d2 = new Double("500");
        if (amount.getValueAsDouble() < d2) {
            throw new CitrusException("Threshold amount should not be less than 500");
        }
        Double d3 = new Double("500");
        if (amount2.getValueAsDouble() < d3) {
            throw new CitrusException("Threshold amount should not be less than 500");
        }
        PaymentOption paymentOption = loadMoney.getPaymentOption();
        if (paymentOption instanceof DebitCardOption || paymentOption instanceof NetbankingOption) {
            this.sendError(callback, new CitrusError("Auto Load available only for Credit Card Payment", CitrusResponse.Status.FAILED));
            return;
        }
        if (!Arrays.asList(cn.a).contains(((CardOption)paymentOption).getCardScheme().toString())) {
            this.sendError(callback, new CitrusError("Auto load feature is supported only for Master or Visa Credit Card.", CitrusResponse.Status.FAILED));
            return;
        }
        this.isActiveSubscriptionPresent(new bq(this, paymentOption, amount2, amount, callback, loadMoney));
    }

    public synchronized void autoLoadMoney(Amount amount, Amount amount2, Callback<SubscriptionResponse> callback) throws CitrusException {
        if (amount == null) {
            throw new CitrusException("ThresHold should not be null or empty.");
        }
        if (amount2 == null) {
            throw new CitrusException("LoadAmount should not be null or empty.");
        }
        if (amount2.compareTo(amount) < 0) {
            throw new CitrusException("LoadAmount should not be less than ThresHold amount.");
        }
        Double d2 = new Double("500");
        if (amount.getValueAsDouble() < d2) {
            throw new CitrusException("Threshold amount should not be less than 500");
        }
        Double d3 = new Double("500");
        if (amount2.getValueAsDouble() < d3) {
            throw new CitrusException("Threshold amount should not be less than 500");
        }
        if (this.subscriptionRequest == null) {
            this.sendError(callback, new CitrusError("Could not create active subscription.", CitrusResponse.Status.FAILED));
            return;
        }
        this.subscriptionRequest.h = amount2.getValue();
        this.subscriptionRequest.g = amount.getValue();
        this.createAutoLoadSubscription(callback, null);
    }

    private void createAutoLoadRequest(PaymentOption paymentOption) {
        if (paymentOption instanceof CreditCardOption && Arrays.asList(cn.a).contains(((CardOption)paymentOption).getCardScheme().toString())) {
            if (this.subscriptionRequest == null) {
                if (paymentOption.isTokenizedPayment()) {
                    this.subscriptionRequest = new ei(paymentOption.getToken());
                    return;
                }
                paymentOption = (CardOption)paymentOption;
                String string = this.getCitrusUser() != null ? (!TextUtils.isEmpty((CharSequence)this.getCitrusUser().getFirstName()) ? this.getCitrusUser().getFirstName() : s.e(((CardOption)paymentOption).getCardNumber())) : s.e(((CardOption)paymentOption).getCardNumber());
                this.subscriptionRequest = new ei(((CardOption)paymentOption).getCardNumber(), ((CardOption)paymentOption).getCardExpiry(), string);
                return;
            }
        } else {
            this.subscriptionRequest = null;
            this.mAUTO_load_type$18afc017 = 0;
        }
    }

    public void isAutoLoadAvailable(Callback<Boolean> callback) {
        this.isActiveSubscriptionPresent(new bu(this, callback));
    }

    public void updateSubScriptiontoLoweValue(Amount amount, Amount amount2, Callback<SubscriptionResponse> callback) {
        this.isActiveSubscriptionPresent(new bv(this, callback, amount2, amount));
    }

    public void updateSubscriptiontoHigherValue(PaymentType.LoadMoney loadMoney, Amount amount, Amount amount2, Callback<SubscriptionResponse> callback) throws CitrusException {
        if (amount == null) {
            throw new CitrusException("ThresHold should not be null or empty.");
        }
        if (amount2 == null) {
            throw new CitrusException("Auto Load amount should not be null or empty.");
        }
        if (amount2.compareTo(amount) < 0) {
            throw new CitrusException("Auto Load amount should not be less than ThresHold amount.");
        }
        Double d2 = new Double("500");
        if (amount.getValueAsDouble() < d2) {
            throw new CitrusException("Threshold amount should not be less than 500");
        }
        Double d3 = new Double("500");
        if (amount2.getValueAsDouble() < d3) {
            throw new CitrusException("Threshold amount should not be less than 500");
        }
        PaymentOption paymentOption = loadMoney.getPaymentOption();
        if (paymentOption instanceof DebitCardOption || paymentOption instanceof NetbankingOption) {
            this.sendError(callback, new CitrusError("Auto Load available only for Credit Card Payment", CitrusResponse.Status.FAILED));
            return;
        }
        if (!Arrays.asList(cn.a).contains(((CardOption)paymentOption).getCardScheme().toString())) {
            this.sendError(callback, new CitrusError("Auto load feature is supported only for Master or Visa Credit Card.", CitrusResponse.Status.FAILED));
            return;
        }
        this.isActiveSubscriptionPresent(new by(this, amount, callback, amount2, loadMoney));
    }

    static /* synthetic */ Environment access$000(CitrusClient citrusClient) {
        return citrusClient.environment;
    }

    static /* synthetic */ com.citrus.c.b access$100(CitrusClient citrusClient) {
        return citrusClient.oauthToken;
    }

    static /* synthetic */ cu access$200(CitrusClient citrusClient) {
        return citrusClient.retrofitAPIWrapper;
    }

    static /* synthetic */ void access$300(CitrusClient citrusClient, Callback callback, CitrusError citrusError) {
        citrusClient.sendError(callback, citrusError);
    }

    static /* synthetic */ void access$400(CitrusClient citrusClient, Callback callback, Object object) {
        citrusClient.sendResponse(callback, object);
    }

    static /* synthetic */ void access$500(CitrusClient citrusClient, PaymentType.CitrusCash citrusCash, Callback callback) {
        citrusClient.proceedWithNewPrepaidPay(citrusCash, callback);
    }

    static /* synthetic */ Context access$600(CitrusClient citrusClient) {
        return citrusClient.mContext;
    }

    static /* synthetic */ void access$700(CitrusClient citrusClient, BroadcastReceiver broadcastReceiver) {
        citrusClient.unregisterReceiver(broadcastReceiver);
    }

    static /* synthetic */ PaymentOption access$802(CitrusClient citrusClient, PaymentOption paymentOption) {
        citrusClient.persistPaymentOption = paymentOption;
        return citrusClient.persistPaymentOption;
    }

    static /* synthetic */ ei access$902(CitrusClient citrusClient, ei ei2) {
        citrusClient.subscriptionRequest = ei2;
        return citrusClient.subscriptionRequest;
    }

    static /* synthetic */ int access$1002$557a15ab(CitrusClient citrusClient, int n2) {
        citrusClient.mAUTO_load_type$18afc017 = n2;
        return citrusClient.mAUTO_load_type$18afc017;
    }

    static /* synthetic */ PaymentOption access$800(CitrusClient citrusClient) {
        return citrusClient.persistPaymentOption;
    }

    static /* synthetic */ void access$1100(CitrusClient citrusClient, String string, String string2) {
        citrusClient.saveCVV(string, string2);
    }

    static /* synthetic */ void access$1200(CitrusClient citrusClient, PaymentOption paymentOption, Callback callback) {
        citrusClient.saveCard(paymentOption, callback);
    }

    static /* synthetic */ q access$1302(CitrusClient citrusClient, q q2) {
        citrusClient.updateSubscriptionRequest = q2;
        return citrusClient.updateSubscriptionRequest;
    }

    static /* synthetic */ void access$1400(CitrusClient citrusClient, em em2, Callback callback) {
        citrusClient.walletPGCharge(em2, callback);
    }

    static /* synthetic */ SubscriptionResponse access$1502(CitrusClient citrusClient, SubscriptionResponse subscriptionResponse) {
        citrusClient.activeSubscription = subscriptionResponse;
        return citrusClient.activeSubscription;
    }

    static /* synthetic */ SubscriptionResponse access$1500(CitrusClient citrusClient) {
        return citrusClient.activeSubscription;
    }

    static /* synthetic */ void access$1600(CitrusClient citrusClient, PaymentOption paymentOption) {
        citrusClient.createAutoLoadRequest(paymentOption);
    }

    static /* synthetic */ ei access$900(CitrusClient citrusClient) {
        return citrusClient.subscriptionRequest;
    }

    static /* synthetic */ void access$1700(CitrusClient citrusClient, Callback callback, TransactionResponse transactionResponse) {
        citrusClient.createAutoLoadSubscription(callback, transactionResponse);
    }

    static /* synthetic */ int access$1000$789619f4(CitrusClient citrusClient) {
        return citrusClient.mAUTO_load_type$18afc017;
    }

    static /* synthetic */ void access$1800(CitrusClient citrusClient, Callback callback, TransactionResponse transactionResponse) {
        citrusClient.updateAutoLoadSubscriptiontoHigherValue(callback, transactionResponse);
    }

    static {
        isCitrusNativeLibraryLoaded = false;
        isFacebookNativeLibraryLoaded = false;
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ int QUICK_AUTO_LOAD$18afc017 = 1;
        public static final /* enum */ int UPDATE_AUTO_LOAD$18afc017 = 2;
        public static final /* enum */ int LAZY_AUTO_LOAD$18afc017 = 3;
        private static final /* synthetic */ int[] $VALUES$218a9c3c;

        static {
            $VALUES$218a9c3c = new int[]{QUICK_AUTO_LOAD$18afc017, UPDATE_AUTO_LOAD$18afc017, LAZY_AUTO_LOAD$18afc017};
        }
    }
}

