package com.citrus.sdk.network.request;

import android.util.Log;

import com.citrus.sdk.network.Api;
import com.citrus.sdk.network.HttpMethod;
import com.citrus.sdk.network.NetworkConstants;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by vinay on 1/4/16.
 */
public class ApiRequest {
    private static final String TAG = ApiRequest.class.getSimpleName();

    private String relativeUrl;
    private RequestBody requestBody;
    private Map<String, String> headers;
    private HttpMethod httpMethod;
    private String cancelTag;
    private Map<String, String> params;
    private String bodyContentType;
    private Class clazz;
    private String name;

    ApiRequest() {
    }

    public String getRelativeUrl() {
        return relativeUrl;
    }

    public void setRelativeUrl(String relativeUrl) {
        this.relativeUrl = relativeUrl;
    }

    public Map<String, String> getHeaders() {
        return headers;
    }

    public void addHeaders(final Map<String, String> paramHeaders) {
        if (paramHeaders != null) {
            if (headers == null) {
                headers = new HashMap<>();
            }
            headers.putAll(paramHeaders);
        }
    }

    public void addHeader(final String key, final String value) {
        if (key != null && value != null) {
            if (headers == null) {
                headers = new HashMap<>();
            }
            headers.put(key, value);
        }
    }

    public HttpMethod getHttpMethod() {
        return httpMethod;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getCancelTag() {
        return cancelTag;
    }

    public void setCancelTag(String cancelTag) {
        this.cancelTag = cancelTag;
    }

    public Map<String, String> getParams() {
        return params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public String getBodyContentType() {
        return bodyContentType;
    }

    public void setBodyContentType(String bodyContentType) {
        this.bodyContentType = bodyContentType;
    }

    public Class getClazz() {
        return clazz;
    }

    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    public RequestBody getRequestBody() {
        return requestBody;
    }

    public void setRequestBody(RequestBody requestBody) {
        this.requestBody = requestBody;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    @Override
    public String toString() {
        return super.toString() + '|' + httpMethod + '|' + relativeUrl + '|' + clazz;
    }

    public static class ApiRequestBuilder {
        private Api api;
        private String authorizationToken;
        private Map<String, String> headers;
        private Map<String, String> params;
        private RequestBody requestBody;
        private String[] pathParams;

        private String cancelTag;

        public ApiRequestBuilder(Api api) {
            this.api = api;
        }

        public ApiRequestBuilder authorizationToken(String authorizationToken) {
            this.authorizationToken = authorizationToken;
            return this;
        }

        public ApiRequestBuilder requestBody(RequestBody requestBody) {
            this.requestBody = requestBody;

            return this;
        }

        public ApiRequestBuilder headers(Map<String, String> headers) {
            this.headers = headers;

            return this;
        }

        public ApiRequestBuilder params(Map<String, String> params) {
            this.params = params;

            return this;
        }

        public ApiRequestBuilder cancelTag(String cancelTag) {
            this.cancelTag = cancelTag;

            return this;
        }

        public ApiRequestBuilder pathParams(String... pathParams) {
            this.pathParams = pathParams;

            return this;
        }

        public ApiRequest build() {
            ApiRequest apiRequest = null;
            if (api != null) {
                apiRequest = new ApiRequest();

                if (pathParams != null) {
                    final String formattedRelativeUrl = String.format(api.getRelativeUrl(), pathParams);
                    apiRequest.setRelativeUrl(formattedRelativeUrl);
                }

                final HttpMethod httpMethod = api.getHttpMethod();
                final String bodyContentType = api.getBodyContentType();

                apiRequest.name = api.name();
                apiRequest.httpMethod = api.getHttpMethod();
                apiRequest.relativeUrl = api.getRelativeUrl();
                apiRequest.clazz = api.getClazz();

                if (headers == null && authorizationToken == null) {
                    Log.w(TAG, TAG + ".buildApi(): WARNING: No headers for " + api.getRelativeUrl());
                } else {
                    if (authorizationToken != null) {
                        apiRequest.addHeader(NetworkConstants.BASE_AUTHORIZATION_HEADER_KEY, authorizationToken);
                    }
                    if (headers != null) {
                        apiRequest.addHeaders(headers);
                    }
                }

                if (httpMethod != HttpMethod.GET) {
                    if (bodyContentType == null) {
                        Log.w(TAG, TAG + ".buildApi(): WARNING: bodyContentType is null for httpMethod " + httpMethod);
                    } else {
                        apiRequest.bodyContentType = bodyContentType;

                        if (params == null && requestBody == null) {
                            Log.w(TAG, TAG + ".buildApi(): WARNING: No body");
                        } else {
                            if (bodyContentType.equals(NetworkConstants.CONTENT_TYPE_FORM_ENCODED)) {
                                if (params == null) {
                                    Log.w(TAG, TAG + ".buildApi(): WARNING: params null for bodyContentType " + bodyContentType);
                                } else {
                                    apiRequest.params = params;
                                }
                            } else if (bodyContentType.equals(NetworkConstants.CONTENT_TYPE_JSON)) {
                                if (requestBody == null) {
                                    Log.w(TAG, TAG + ".buildApi(): WARNING: body null for bodyContentType " + bodyContentType);
                                } else {
                                    apiRequest.requestBody = requestBody;
                                }
                            }
                        }
                    }
                }
            }
            return apiRequest;
        }

    }

}

