package com.citrus.sdk;

import android.text.TextUtils;

/**
 * This class object will be used while creating auto-load subscription
 * Created by mangesh on 8/2/16.
 */
public class SubscriptionRequest {

    String pan;

    String expiry;

    String type;

    String holder;

    public String getToken() {
        return token;
    }

    String token;

    public void setAuthRefId(String authRefId) {
        this.authRefId = authRefId;
    }

    String authRefId;

    public void setThresholdAmount(String thresholdAmount) {
        this.thresholdAmount = thresholdAmount;
    }

    public void setLoadAmount(String loadAmount) {
        this.loadAmount = loadAmount;
    }

    public void setPan(String pan) {
        this.pan = pan;
    }

    String thresholdAmount;

    String loadAmount;

    /**
     * this object will be created for Auto Load using saved card
     *
     * @param token
    */
    public SubscriptionRequest(String token) {
        this.token = token;
        this.thresholdAmount = thresholdAmount;
        this.loadAmount = loadAmount;
        this.type = "pgCardToken";
    }

    /**
     * This object will be created for Auto Load using credit card
     *
     * @param pan
     * @param expiry
     * @param holder

     */
    public SubscriptionRequest(String pan, String expiry, String holder) {
        this.pan = pan;
        this.expiry = expiry;
        this.type = "creditCard";
        this.holder = holder;
    }

    public String getPan() {
        return pan;
    }

    public String getExpiry() {
        return expiry;
    }

    public String getType() {
        return type;
    }

    public String getHolder() {
        return holder;
    }

    public String getAuthRefId() {
        return authRefId;
    }

    public String getThresholdAmount() {
        return thresholdAmount;
    }

    public String getLoadAmount() {
        return loadAmount;
    }

    @Override
    public String toString() {
        return "SubscriptionRequest{" +
                "pan='" + pan + '\'' +
                ", expiry='" + expiry + '\'' +
                ", type='" + type + '\'' +
                ", holder='" + holder + '\'' +
                ", authRefId='" + authRefId + '\'' +
                ", thresholdAmount='" + thresholdAmount + '\'' +
                ", loadAmount='" + loadAmount + '\'' +
                '}';
    }

    public boolean isSavedCardSubscription() {
        return TextUtils.equals("pgCardToken", type);
    }

////pan=4386280018570121&expiry=12%2F2016&holder=Mangesh+Kadam&authRefId=PPTX000000019597&thresholdAmount=500&loadAmount=500&type=creditCard
}
