package com.citrus.sdk.walletpg;

import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.payment.PaymentOption;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by salil on 11/2/16.
 */
public class WalletConsumerProfile {

    private CitrusUser citrusUser;
    private List<PaymentOption> paymentOptionList;

    public WalletConsumerProfile(CitrusUser citrusUser, List<PaymentOption> paymentOptionList) {
        this.citrusUser = citrusUser;
        this.paymentOptionList = paymentOptionList;
    }

    public CitrusUser getCitrusUser() {
        return citrusUser;
    }

    public List<PaymentOption> getPaymentOptionList() {
        return paymentOptionList;
    }

    public static WalletConsumerProfile fromJSON(String json) throws JSONException {
        JSONObject jsonObject = new JSONObject(json);
        return fromJSONObject(jsonObject);
    }

    public static WalletConsumerProfile fromJSONObject(JSONObject jsonObject) {
        WalletConsumerProfile walletConsumerProfile = null;

        List<PaymentOption> paymentOptionList = null;
        JSONArray paymentOptionsArray = jsonObject.optJSONArray("paymentOptionsList");
        for (int i = 0; i < paymentOptionsArray.length(); i++) {
            JSONObject paymentOptionObject = paymentOptionsArray.optJSONObject(i);
            PaymentOption paymentOption = PaymentOption.fromJSONObject(paymentOptionObject, true);

            if (paymentOptionList == null) {
                paymentOptionList = new ArrayList<PaymentOption>();
            }

            paymentOptionList.add(paymentOption);
        }

        CitrusUser citrusUser = CitrusUser.fromJSONObject(jsonObject.optJSONObject("userDetails"));
        walletConsumerProfile = new WalletConsumerProfile(citrusUser, paymentOptionList);

        return walletConsumerProfile;
    }
}
