package com.citrus.sdk.login;

import com.citrus.sdk.CitrusUser;
import com.orhanobut.logger.Logger;

import java.util.Arrays;

/**
 * Created by salil on 10/5/16.
 */
public class LoginInfo {

    private String responseCode;
    private CitrusUser citrusUser;
    private AvailableLoginType availableLoginType;
    private String message;

    public LoginInfo(String responseCode, CitrusUser citrusUser, AvailableLoginType availableLoginType, String message) {
        this.responseCode = responseCode;
        this.citrusUser = citrusUser;
        this.availableLoginType = availableLoginType;
        this.message = message;
    }

    public CitrusUser getCitrusUser() {
        return citrusUser;
    }

    public AvailableLoginType getAvailableLoginType() {
        return availableLoginType;
    }

    public String getMessage() {
        return message;
    }

    public String getUUID() {
        return citrusUser != null ? citrusUser.getUuid() : "";
    }

    public int getLoginUserCase() {
        String[] responseCodeArray = this.responseCode.split("-");
        Logger.v("array", Arrays.toString(responseCodeArray));
        String code = responseCodeArray[2];
        return Integer.parseInt(code);
    }
}
