package com.citrus.sdk.classes;

import android.text.TextUtils;

import com.citrus.sdk.CitrusUser;
import com.google.gson.Gson;
import com.orhanobut.logger.Logger;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Arrays;

/**
 * Created by Gautam on 17/11/15.
 */
public final class LinkBindUserResponse {

    private AccessToken limitedScopeToken = null;
    private CitrusUser citrusUser = null;
    private String responseCode = null;
    private String responseMessage = null;
    private LinkUserSignInType linkUserSignInType = null;

    private static String replaceStr = "####";
    private static final String MESSAGE_LOGIN_MOTP_PASSWORD = "Please Sign in with OTP sent on " + replaceStr + " or by using your Citrus Password";
    private static final String MESSAGE_LOGIN_MVERIFICATION_CODE_PASSWORD = "Please Sign in with Verification Code sent on " + replaceStr + " or by using your Citrus Password";
    private static final String MESSAGE_LOGIN_MOTP = "Please Sign in with OTP sent on " + replaceStr;
    private static final String MESSAGE_LOGIN_MVERIFICATION_CODE = "Please Sign in with Verification Code sent on " + replaceStr;
    private static final String MESSAGE_SIGNED_IN_LIMITED_SCOPE = "User signed in with limited scope token";
    private static final String MESSAGE_SOME_ERROR_OCCURRED = "Some Error Occurred";
    private String inputEmail = null;
    private String inputMobile = null;


    private LinkBindUserResponse(String responseCode, String responseMessage, AccessToken limitedScopeToken, CitrusUser citrusUser, LinkUserSignInType signInType) {
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
        this.limitedScopeToken = limitedScopeToken;
        this.citrusUser = citrusUser;
        this.linkUserSignInType = signInType;
    }

    public static LinkBindUserResponse fromJSON(String json) {
        LinkBindUserResponse linkBindUserResponse = null;

        if (!TextUtils.isEmpty(json)) {
            try {
                JSONObject jsonObject = new JSONObject(json);

                JSONObject responseDataObject = jsonObject.getJSONObject("responseData");
                JSONObject limitedAccessTokenObject = responseDataObject.getJSONObject("limitedAccessToken");
                JSONObject profileDataObject = responseDataObject.getJSONObject("profileData");

                Gson gson = new Gson();
                AccessToken limitedAccessToken = gson.fromJson(limitedAccessTokenObject.toString(), AccessToken.class);
                CitrusUser citrusUser = CitrusUser.fromJSONObject(profileDataObject);

                String responseCode = jsonObject.optString("responseCode");
                String responseMessage = getSignInTypeMessage(responseCode, citrusUser.getMobileNo());
                LinkUserSignInType signInType = getLinkBindUserSignInType(responseCode);
                linkBindUserResponse = new LinkBindUserResponse(responseCode, responseMessage, limitedAccessToken, citrusUser, signInType);

            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

        return linkBindUserResponse;
    }

    /**
     * The response is in following format.
     * {
     * "responseCode": "R-222-01",
     * "responseMessage": "Sign in with m-OTP",
     * }
     * The responseCode will either be R-222-01 or R-222-02 or R-211-03 or R-222-04 or R-222-05 or R-222-06 or R-222-07 or R-222-08 or R-222-09 or R-222-10 or R-222-11 or R-222-12 or R-222-13
     */
    public static LinkUserSignInType getLinkBindUserSignInType(String responseCode) {

        LinkUserSignInType linkUserSignInType;

        if ("R-222-01".equals(responseCode)) {
            linkUserSignInType = LinkUserSignInType.SignInTypeMOtp;
        } else if ("R-222-02".equals(responseCode)) {
            linkUserSignInType = LinkUserSignInType.SignInTypeMOtpOrPassword;
        } else if ("R-222-03".equals(responseCode)) {
            linkUserSignInType = LinkUserSignInType.SignInTypeLimitedScope;
        } else if ("R-222-04".equals(responseCode)) {
            linkUserSignInType = LinkUserSignInType.SignInTypeMOtp;
        } else if ("R-222-05".equals(responseCode)) {
            linkUserSignInType = LinkUserSignInType.SignInTypeMOtpOrPassword;
        } else if ("R-222-06".equals(responseCode)) {
            linkUserSignInType = LinkUserSignInType.SignInTypeLimitedScope;
        } else if ("R-222-07".equals(responseCode)) {
            linkUserSignInType = LinkUserSignInType.SignInTypeLimitedScope;
        } else if ("R-222-08".equals(responseCode)) {
            linkUserSignInType = LinkUserSignInType.SignInTypeMOtp;
        } else if ("R-222-09".equals(responseCode)) {
            linkUserSignInType = LinkUserSignInType.SignInTypeMOtpOrPassword;
        } else if ("R-222-10".equals(responseCode)) {
            linkUserSignInType = LinkUserSignInType.SignInTypeMOtp;
        } else if ("R-222-11".equals(responseCode)) {
            linkUserSignInType = LinkUserSignInType.SignInTypeMOtp;
        } else if ("R-222-12".equals(responseCode)) {
            linkUserSignInType = LinkUserSignInType.SignInTypeMOtpOrPassword;
        } else if ("R-222-13".equals(responseCode)) {
            linkUserSignInType = LinkUserSignInType.SignInTypeLimitedScope;
        } else {
            linkUserSignInType = LinkUserSignInType.None;
        }

        Logger.v("Link Bind User Sign in Type = " + linkUserSignInType.toString());
        return linkUserSignInType;
    }

    private static String getSignInTypeMessage(String responseCode, String mobileNo) {

        String message = null;

        if ("R-222-01".equals(responseCode)) {
            message = MESSAGE_LOGIN_MOTP.replace(replaceStr, mobileNo);
        } else if ("R-222-02".equals(responseCode)) {
            message = MESSAGE_LOGIN_MOTP_PASSWORD.replace(replaceStr, mobileNo);
        } else if ("R-222-03".equals(responseCode)) {
            message = MESSAGE_SIGNED_IN_LIMITED_SCOPE;
        } else if ("R-222-04".equals(responseCode)) {
            message = MESSAGE_LOGIN_MVERIFICATION_CODE.replace(replaceStr, mobileNo);
        } else if ("R-222-05".equals(responseCode)) {
            message = MESSAGE_LOGIN_MVERIFICATION_CODE_PASSWORD.replace(replaceStr, mobileNo);
        } else if ("R-222-06".equals(responseCode)) {
            message = MESSAGE_SIGNED_IN_LIMITED_SCOPE;
        } else if ("R-222-07".equals(responseCode)) {
            message = MESSAGE_SIGNED_IN_LIMITED_SCOPE;
        } else if ("R-222-08".equals(responseCode)) {
            message = MESSAGE_LOGIN_MOTP.replace(replaceStr, mobileNo);
        } else if ("R-222-09".equals(responseCode)) {
            message = MESSAGE_LOGIN_MOTP_PASSWORD.replace(replaceStr, mobileNo);
        } else if ("R-222-10".equals(responseCode)) {
            message = MESSAGE_SIGNED_IN_LIMITED_SCOPE;
        } else if ("R-222-11".equals(responseCode)) {
            message = MESSAGE_LOGIN_MVERIFICATION_CODE.replace(replaceStr, mobileNo);
        } else if ("R-222-12".equals(responseCode)) {
            message = MESSAGE_LOGIN_MVERIFICATION_CODE_PASSWORD.replace(replaceStr, mobileNo);
        } else if ("R-222-13".equals(responseCode)) {
            message = MESSAGE_SIGNED_IN_LIMITED_SCOPE;
        } else {
            message = MESSAGE_SOME_ERROR_OCCURRED;
        }

        return message;
    }

    public JSONObject getJSON() {
        final Gson gson = new Gson();
        String json = gson.toJson(this);
        try {
            return new JSONObject(json);
        } catch (JSONException e) {
            return null;
        }
    }

    public int formatResponseCode() {
        String[] responseCodeArray = this.responseCode.split("-");
        Logger.v("array", Arrays.toString(responseCodeArray));
        String code = responseCodeArray[2];
        return Integer.parseInt(code);
    }

    public String getUserUUID() {
        return citrusUser != null ? citrusUser.getUuid() : "";
    }

    public CitrusUser getCitrusUser() {
        return citrusUser;
    }

    public String getResponseCode() {
        return responseCode;
    }

    public String getResponseMessage() {
        return responseMessage;
    }

    public LinkUserSignInType getLinkUserSignInType() {
        return linkUserSignInType;
    }

    public String getInputEmail() {
        return inputEmail;
    }

    public String getInputMobile() {
        return inputMobile;
    }

    public void setInputEmail(String inputEmail) {
        this.inputEmail = inputEmail;
    }

    public void setInputMobile(String inputMobile) {
        this.inputMobile = inputMobile;
    }

    public AccessToken getLimitedScopeToken() {
        return limitedScopeToken;
    }
}
