package com.citrus.sdk.apis;

import android.support.annotation.NonNull;

import com.citrus.sdk.Callback;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.classes.AccessToken;
import com.citrus.sdk.classes.CitrusUMResponse;
import com.citrus.sdk.classes.LinkBindUserResponse;
import com.citrus.sdk.classes.LinkUserExtendedResponse;
import com.citrus.sdk.classes.LinkUserResponse;
import com.citrus.sdk.classes.MemberInfo;
import com.citrus.sdk.login.AccessType;
import com.citrus.sdk.response.BindUserResponse;
import com.citrus.sdk.response.CitrusResponse;

/**
 * Created by mangesh on 1/12/15.
 */
public interface UMClientAPI {

    /**
     * Get the grant type Implicit Token
     *
     * @param callback
     */
    void getSignUpToken(final Callback<AccessToken> callback);

    /**
     * This API will give UserBind Response - username is required from this response
     *
     * @param callback
     */
    void createUser(String emailId, String mobileNo, final Callback<String> callback);


    void getUserNameToken(final String userName, final Callback<AccessToken> callback);


    void getUserNameToken(final Callback<AccessToken> callback);


    void getPrepaidToken(final Callback<AccessToken> callback);


    /**
     * This method will return true if the user with given emailID exists else returns false
     *
     * @param emailId
     * @param mobileNo
     * @param callback
     */
    void isCitrusMember(final String emailId, final String mobileNo, final Callback<Boolean> callback);


    /**
     * This method will return member info = implicit token required
     *
     * @param emailId
     * @param mobileNo
     * @param callback
     */
    void getMemberInfo(final String emailId, final String mobileNo, final Callback<MemberInfo> callback);

    /**
     * This method will bind User with mobile -
     *
     * @param emailId
     * @param mobileNo
     * @param callback
     */
    void bindUserByMobile(final String emailId, final String mobileNo, final Callback<BindUserResponse> callback);


    void linkUserWithOTP(final String emailId, final String mobileNo, final boolean forceMobileVerification, final Callback<LinkUserResponse> callback);


/*    void signInWithMobileNo(final String mobileNo, final String password, final Callback<CitrusResponse> callback);


    void signInWithOTP(final String emailIdOrMobileNo, final String otp, final Callback<CitrusResponse> callback);*/

    void signUp(final String emailId, String mobileNo, final String password, final Callback<CitrusResponse> callback);

    void resetPassword(final String emailId, @NonNull final Callback<CitrusResponse> callback);

    void updateMobile(final String mobileNo, final Callback<String> callback);

    void verifyMobile(final String verificationCode, final Callback<String> callback);

    void getProfileInfo(final Callback<CitrusUser> callback);


    void changePassword(final String oldPassword, final String newPassword, final Callback<CitrusUMResponse> changePasswordResponseCallback);


    void updateProfileInfo(final String firstName, final String lastName, final Callback<CitrusUMResponse> citrusUMResponseCallback);

    void sendOneTimePassword(String source, String otpType, String identity, final Callback<CitrusUMResponse> umResponseCallback);

    void resetUserPassword(final String emailId, @NonNull final Callback<CitrusUMResponse> callback);

    void signUpUser(final String email, final String mobile, final String password, final String firstName, final String lastName,
                    final String sourceType, final boolean markMobileVerified, final boolean markEmailVerified,
                    final Callback<CitrusResponse> callback);

    void linkUserExtended(final String emailId, final String mobileNo, final Callback<LinkUserExtendedResponse> callback);

    void linkBindUser(final String emailId, final String mobileNo, final AccessType accessType, final Callback<LinkBindUserResponse> callback);

    // void signOut(Callback<Boolean> callback);
}
