/*
 *
 *    Copyright 2014 Citrus Payment Solutions Pvt. Ltd.
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 * /
 */

package com.citrus.sdk;

/**
 * Created by MANGESH KADAM on 5/20/2015.
 */
public interface ResponseMessages {

    String SUCCESS_MESSAGE_SIGN_UP = "User Signed up successfully.";
    String SUCCESS_MESSAGE_SIGNIN = "User Signed In Successfully.";

    String SUCCESS_COOKIE_SIGNIN = "User Cookie Sign In successfully.";

    String SUCCESS_TRANSACTION = "Transaction Successful.";

    String SUCCESS_MESSAGE_USER_BIND = "User Bind Successfully.";

    String SUCCESS_MESSAGE_LOAD_MONEY = "Citrus Cash Wallet loaded successfully";
    String ERROR_MESSAGE_LOAD_MONEY = "Failed to load money into Citrus Cash";

    String SUCCESS_MESSAGE_RESET_PASSWORD = "Reset password link has been sent to your email id.";
    String ERROR_MESSAGE_RESET_PASSWORD = "Error: Reset password failed";

    String ERROR_MESSAGE_BLANK_EMAIL_ID_MOBILE_NO = "Please enter email id or the mobile number of your friend to send the money";
    String ERROR_MESSAGE_BLANK_MOBILE_NO = "Please enter the mobile number of your friend to send the money";
    String ERROR_MESSAGE_BLANK_VERIFICATION_CODE = "Verification Code can not be blank.";
    String ERROR_MESSAGE_BLANK_AMOUNT = "Please enter the amount to be sent.";
    String ERROR_MESSAGE_INVALID_JSON = "ERROR: Invalid Json received.";
    String ERROR_MESSAGE_FAILED_MERCHANT_PAYMENT_OPTIONS = "ERROR: Unable to fetch merchant payment options";
    String ERROR_MESSAGE_BLANK_CONFIG_PARAMS = "Please make sure SignIn Id, SignIn Secret, SignUp Id, SignUp Secret & Vanity are not blank";
    String ERROR_MESSAGE_INVALID_MOBILE_NO = "Invalid Mobile Number";
    String ERROR_MESSAGE_NULL_PAYMENT_OPTION = "PaymentOption is null.";
    String ERROR_SIGNUP_TOKEN_NOT_FOUND = "Have you Signed Up? Token not found!!!";
    String ERROR_SIGNIN_TOKEN_NOT_FOUND = "Have you Signed In? Token not found!!!";

    String ERROR_MESSAGE_LINK_USER = "ERROR: Unable to Link User";
    String ERROR_MESSAGE_SIGNUP_TOKEN = "ERROR: Unable to fetch Sign up token.";
    String ERROR_MESSAGE_UPDATE_MOBILE = "Updating mobile failed. Please try again.";
    String ERROR_MESSAGE_VERIFY_MOBILE = "Mobile verification failed. Please try again.";

    String SUCCESS_MESSAGE_SAVED_PAYMENT_OPTIONS = "Payment Option Saved Successfully.";
    String SUCCESS_MESSAGE_SAVED_CASHOUT_OPTIONS = "Cashout Information Saved Successfully.";
    String SUCCESS_MESSAGE_DELETE_PAYMENT_OPTIONS = "Payment Option Deleted Successfully.";
    String SUCCESS_MESSAGE_AUTO_LOAD = "Auto Load Subscription created Successfully.";
    String SUCCESS_MESSAGE_UPDATE_SUBSCRIPTION ="Auto Load Subscription Updated Successfully.";

    String ERROR_NETWORK_CONNECTION = "Please check your internet connection.";
    String ERROR_FAILED_TO_GET_BALANCE = "Failed to get the balance.";

    String ERROR_MESSAGE_INVALID_BILL = "Invalid bill received from server.";
    String ERROR_MESSAGE_BIND_USER = "Failed to bind User!!!";
    String ERROR_MESSAGE_MEMBER_INFO = "Unable to fetch Member info";
    String ERROR_MESSAGE_INSUFFICIENT_BALANCE = "The balance in your Citrus Cash account is insufficient. Please load money.";
    String ERROR_MESSAGE_INVALID_CASHOUT_INFO = "Please make sure amount, accountNo, accountHolderName and ifscCode are not null or empty.";

    String ERROR_MESSAGE_INVALID_PASSWORD = "Invalid Credentials! Please check your password.";
    String ERROR_MESSAGE_BLANK_NULL_DP_PARAMS = "DynamicPriceRequestType, Bill Url or PaymentBill should not be null";
    String ERROR_MESSAGE_NULL_DYNAMIC_RESPONSE = "Dynamic Pricing Response can not be null";
    String ERROR_UPDATE_MEMBER_INFO = "Failed to update Profile Info";
    String ERROR_SIGN_UP = "Failed to Sign Up user!";
    String ERROR_SEND_OTP = "Failed to Send OTP !";
    String ERROR_INVALID_CARD_NUMBER = "Invalid Card Number";
    String ERROR_SOMETHING_WENT_WRONG = "OOPS! Something Went Wrong!";
    String ERROR_INTERNAL_SERVER_ERROR = "Internal Server Error Occurred.";
    String ERROR_WITHOUT_SAVED_CARD_CVV_PAYMENT = "This payment is available only for saved cards";
    String ERROR_ONE_TAP_ONLY_CARD = "One tap payment is available only for Card Payment";
    String ERROR_NO_CVV_FOR_SAVED_CARD = "CVV does not exist for this saved Card";
    String ERROR_PREPAID_INNER_TOKEN_MISSING = "Access denied. Please configure your keys for Prepaid Pay.";
    String ERROR_MESSAGE_WALLET_CHARGE = "Unable to process wallet charge";
    String ERROR_MESSAGE_GET_WALLET = "Unable to fetch wallet";
    String ERROR_PAYMENT_OPTION_NOT_SUPPORTED = "This Payment Option is not Supported. Please use another payment option.";
    String ERROR_WALLET_PG_INVALID_TOTAL_AMOUNT = "Total Transaction of all the payment options should be equal to actual transaction amount.";
    String ERROR_AUTO_LOAD_PAYMENT_OPTION = "Auto Load available only for Credit Card Payment";
    String ERROR_AUTO_LOAD_LOWER_AMOUNT_SERVER_RESPONSE = "authRefId field is required";
    String ERROR_AUTO_LOAD_CUSTOMIZED_FOR_LOWER_AMOUNT = "Load Amount should be less than current Load Amount.";
    String ERROR_AUTO_LOAD_NO_ACTIVE_SUBSCRIPTION = "No active subscription exists.";
    String ERROR_AUTO_LOAD_ACTIVE_SUBSCRIPTION = "Active subscription already exists.";
    String ERROR_AUTO_LOAD_LOW_THRESHOLD_AMOUNT = "Threshold amount is less than current active threshold amount";
    String ERROR_AUTO_LOAD_LOW_LOAD_AMOUNT = "Auto load amount is less than current active auto load amount";
    String ERROR_AUTO_LOAD_CARD_SCHEME_ERROR = "Auto load feature is supported only for Master or Visa Credit Card.";
    String ERROR_NO_ACTIVE_SUBSCRIPTION = "Could not create active subscription.";//this is the case if server throws error while creating subscription. we set subscription request to null.
}