package com.citrus.sdk;

import android.os.AsyncTask;

import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.Utils;
import com.citrus.sdk.payment.PaymentBill;
import com.citrus.sdk.response.CitrusError;
import com.citrus.sdk.response.CitrusResponse;
import com.orhanobut.logger.Logger;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

/**
 * Created by MANGESH KADAM on 5/8/2015.
 */
public class GetJSONBill extends AsyncTask<Void, Void, PaymentBill> {
    String billURL;
    Amount amount;
    Callback<PaymentBill> callback;

    public GetJSONBill(String billURL, Amount amount, Callback<PaymentBill> callback) {
        this.billURL = Utils.getUrlFormatted(billURL, amount);
        this.amount = amount;
        this.callback = callback;
    }

    public GetJSONBill(String billURL, Amount amount, String format, Callback<PaymentBill> callback) {
        this.billURL = Utils.getUrlFormatted(billURL, amount, format);
        this.amount = amount;
        this.callback = callback;
    }
//
//    public void getJSONBill() {
////        URL url = null;
////        try {
////            url = new URL(billURL);
////        } catch (MalformedURLException e) {
////            e.printStackTrace();
////        }
////        String baseURL = url.getProtocol() + "://" + url.getAuthority();
////        String path = url.getPath();
////        path = path.substring(1);
////        String query = url.getQuery();
////        RetroFitClient.setEndPoint(baseURL);
////        RetroFitClient.getBillGeneratorClient(baseURL).getBill(path + "?" + query, callback);
////        RetroFitClient.resetEndPoint();
//    }


    @Override
    protected PaymentBill doInBackground(Void... params) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            URL url = new URL(billURL);
            Logger.d("BILL URL ***" , url);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            InputStream inputStream = connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));

            String nextLine = "";
            while ((nextLine = reader.readLine()) != null) {
                stringBuffer.append(nextLine);
            }

        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        return PaymentBill.fromJSON(stringBuffer.toString());
    }

    @Override
    protected void onPostExecute(PaymentBill paymentBill) {
        if (paymentBill != null) {
            callback.success(paymentBill);
        } else {
            callback.error(new CitrusError(ResponseMessages.ERROR_SOMETHING_WENT_WRONG, CitrusResponse.Status.FAILED));
        }
    }
}
