package com.citrus.sdk;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by mangesh on 17/3/16.
 * This class will be wrapper for BN Request. Which will be used by Retrofit 1.9 and 2.0
 */
public class BlazeWrapper {


    //Update the array to support additional Card Schemes for BC
    public static String[] cardSchemes = {"MASTER_CARD", "VISA"};

    /**
     * This function will be used to create JSON required for BlazeNet request
     *
     * @param paymentJSON
     * @return
     */
    public static JSONObject getBlazeNetPaymentObject(String paymentJSON) {
        JSONObject paymentObject = null;
        try {
            paymentObject = new JSONObject(paymentJSON);
            JSONObject blazeNetRequest = new JSONObject();
            blazeNetRequest.put("returnUrl", paymentObject.optString("returnUrl"));
            blazeNetRequest.put("notifyUrl", paymentObject.optString("notifyUrl"));
            blazeNetRequest.put("requestSignature", paymentObject.optString("requestSignature"));
            blazeNetRequest.put("merchantAccessKey", paymentObject.optString("merchantAccessKey"));
            blazeNetRequest.put("merchantTxnId", paymentObject.optString("merchantTxnId"));
            blazeNetRequest.put("email", paymentObject.optString("email"));
            blazeNetRequest.put("amount", paymentObject.getJSONObject("amount"));
            blazeNetRequest.put("userDetails", paymentObject.getJSONObject("userDetails"));
            blazeNetRequest.put("paymentToken", paymentObject.getJSONObject("paymentToken"));
            blazeNetRequest.put("customParameters", paymentObject.getJSONObject("customParameters"));
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return paymentObject;
    }


    /**
     * This JSON will be used for BlazeCard makePayment and Cancel Payment Request
     *
     * @param paymentJSON
     * @return
     */
    public static JSONObject getBlazeCardPaymentObject(String paymentJSON) {

        //  BCRequest bcRequest = new BCRequest();
        JSONObject bcRequestObject = new JSONObject();
        try {
            JSONObject paymentObject = new JSONObject(paymentJSON);
            if (paymentObject.has("citrusTransactionId")) {
                bcRequestObject.put("citrusTransactionId", paymentObject.optString("citrusTransactionId"));
            }
            if (paymentObject.has("customParameters")) {
                bcRequestObject.put("customParameters", paymentObject.getJSONObject("customParameters"));
            }


            bcRequestObject.put("merchantTransactionId", paymentObject.optString("merchantTxnId"));

            bcRequestObject.put("merchantAccessKey", paymentObject.optString("merchantAccessKey"));

            JSONObject amountObj = paymentObject.getJSONObject("amount");

            bcRequestObject.put("amount", amountObj.optString("value"));
            bcRequestObject.put("currency", amountObj.optString("currency"));
            JSONObject userDetails = paymentObject.getJSONObject("userDetails");
            bcRequestObject.put("firstName", userDetails.optString("firstName"));
            bcRequestObject.put("lastName", userDetails.optString("lastName"));
            bcRequestObject.put("email", userDetails.optString("email"));
            bcRequestObject.put("phone", userDetails.optString("mobileNo"));
            JSONObject addressObject = userDetails.getJSONObject("address");

            bcRequestObject.put("addressStreet1", addressObject.optString("street1"));
            bcRequestObject.put("addressCity", addressObject.optString("city"));
            bcRequestObject.put("addressState", addressObject.optString("state"));
            bcRequestObject.put("addressZip", addressObject.optString("zip"));
            JSONObject cardDetails = paymentObject.getJSONObject("paymentToken");
            if (cardDetails.has("paymentMode")) {
                JSONObject paymentMode = cardDetails.getJSONObject("paymentMode");
                bcRequestObject.put("cardType", paymentMode.optString("type").toUpperCase());
                bcRequestObject.put("cardScheme", getBlazeCardCardScheme(paymentMode.optString("scheme")));
                bcRequestObject.put("cardNo", paymentMode.optString("number"));
                bcRequestObject.put("cvv", paymentMode.optString("cvv"));
                bcRequestObject.put("expiry", paymentMode.optString("expiry"));
            } else {
                bcRequestObject.put("cvv", cardDetails.optString("cvv"));

                bcRequestObject.put("extraInfoMap", new JSONObject().put("paymentToken", cardDetails.optString("id")));
            }
            bcRequestObject.put("returnUrl", paymentObject.optString("returnUrl"));
            bcRequestObject.put("notifyUrl", paymentObject.optString("notifyUrl"));
            bcRequestObject.put("signature", paymentObject.optString("requestSignature"));

        } catch (JSONException e) {
            e.printStackTrace();
        }

        return bcRequestObject;
    }


    //BC Card Schemes are different from Moto Card Scheme
    public static String getBlazeCardCardScheme(String motoCardScheme) {

        switch (motoCardScheme) {
            case "VISA":
                return "VISA";
            case "MCRD":
                return "MASTERCARD";
            case "MTRO":
                return "MAESTRO";
            case "DINERS":
                return "DINERS";
            case "JCB":
                return "JCB";
            case "AMEX":
                return "AMEX";
            case "DISCOVER":
                return "DISCOVER";
            case "RPAY":
                return "RPAY";
            default:
                return null;
        }

    }

    //TODO change this implpementaiotn
    public static String getSystemParametersObject() {

        //"clientInformation":
        String json = "{ \"app_version\": \"1.0.0\",  \"app_bundle\": \"com.citrus.sample\" ,\"sdk_version\": \"3.4.5\" ,\"platform\": \"Android\" ,\"platform_version\": \"5.0\" }";
        return json;
    }
}
