package com.citrus.sdk.apis;

import android.support.annotation.NonNull;

import com.citrus.sdk.Callback;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.SubscriptionRequest;
import com.citrus.sdk.classes.UpdateSubscriptionRequest;
import com.citrus.sdk.classes.AccessToken;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.CashoutInfo;
import com.citrus.sdk.classes.CitrusPrepaidBill;
import com.citrus.sdk.response.SubscriptionResponse;
import com.citrus.sdk.payment.PaymentType;
import com.citrus.sdk.response.CitrusResponse;
import com.citrus.sdk.response.PaymentResponse;

import retrofit.http.GET;

/**
 * Created by salil on 30/11/15.
 */
public interface PrepaidClientAPI {

    /**
     * This will return the validity for the token. Mostly used while making new pay using Citrus Cash API.
     *
     * @param signupToken  - signuptoken
     * @param prepaidToken - granttype password token
     * @param scope        - the scope for access
     * @param callback
     */
    @GET("/service/v2/token/validate")
    void getPrepaymentTokenValidity(final AccessToken signupToken, final AccessToken prepaidToken, String scope, Callback<Boolean> callback);

    /**
     * @param accessToken - granttype password token
     * @param amount      - amount to be loaded
     * @param returnUrl
     * @param callback
     */
    void getPrepaidBill(AccessToken accessToken, Amount amount, String returnUrl, Callback<CitrusPrepaidBill> callback);

    /**
     * Get the balance of the user.
     * POST method - we are passing empty parameter
     *
     * @param accessToken - GrantType username token.
     * @param callback    - callback
     */
    void getBalance(final AccessToken accessToken, final Callback<Amount> callback);

    /**
     * Activate User's Prepaid Account if not already done. The default balance of unactivated user is -1.
     * Once activated the balance will be 0. The output will the balance amount.
     *
     * @param accessToken - GrantType username token.
     * @param callback    - callback
     */
    void activatePrepaidUser(final AccessToken accessToken, final Callback<Amount> callback);

    /**
     * Get the cookie for the user which is required while making payment using Citrus Cash.
     *
     * @param email    - email of the user.
     * @param password - password.
     * @param callback - callback
     */
    void getCookie(String email, String password, final Callback<CitrusResponse> callback);

    /**
     * PayUsing Citrus Cash new API. This is kind of REST API for Payments eliminating the need to open the transaction url in webview.
     *
     * @param accessToken
     * @param citrusCash
     * @param callback
     */
    void newPrepaidPay(AccessToken accessToken, PaymentType.CitrusCash citrusCash, Callback<PaymentResponse> callback);

    /**
     * Send money to your friend.
     *
     * @param amount      - Amount to be sent
     * @param toUser      - The user detalis. Enter emailId if send by email or mobileNo if send by mobile.
     * @param message     - Optional message
     * @param callback    - Callback
     * @param accessToken - grantType password/otp token.
     * @deprecated Use {@link PrepaidClientAPI#sendMoneyToMoblieNo(AccessToken, Amount, String, String, Callback)} instead.
     */
    void sendMoney(final AccessToken accessToken, final Amount amount, final CitrusUser toUser, final String message, final Callback<PaymentResponse> callback);

    /**
     * Send money to your friend.
     *
     * @param amount      - Amount to be sent
     * @param mobileNo    - Mobile no of the receiver.
     * @param message     - Optional message
     * @param callback    - Callback
     * @param accessToken - grantType password/otp token.
     */
    void sendMoneyToMoblieNo(final AccessToken accessToken, final Amount amount, final String mobileNo, final String message, final Callback<PaymentResponse> callback);

    void cashout(final AccessToken accessToken, @NonNull final CashoutInfo cashoutInfo, final Callback<PaymentResponse> callback);

    void getCashoutInfo(final AccessToken accessToken, final Callback<CashoutInfo> callback);

    void saveCashoutInfo(final AccessToken accessToken, final CashoutInfo cashoutInfo, final Callback<CitrusResponse> callback);


    void getActiveSubscriptions(AccessToken accessToken, Callback<SubscriptionResponse> callback);

    void deActivateSubscription(AccessToken accessToken, String subscriptionID, final Callback<SubscriptionResponse> callback);

    void createSubscription(AccessToken accessToken, SubscriptionRequest subscriptionRequest, final Callback<SubscriptionResponse> callback);

    void updateSubscriptiontoLowerValue(AccessToken accessToken, UpdateSubscriptionRequest subscriptionRequest, final Callback<SubscriptionResponse> callback);

    void updateSubscriptiontoHigherValue(AccessToken accessToken, UpdateSubscriptionRequest subscriptionRequest, final Callback<SubscriptionResponse> callback);

}
