package com.citrus.sdk.payment;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Parcel;

import com.citrus.analytics.PaymentType;
import com.citrus.sdk.classes.Amount;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by salil on 22/1/16.
 */
public class MVCOption extends PaymentOption {

    private Amount maxBalance = null;
    private String campaignCode = null;

    public MVCOption(Amount transactionAmount, String campaignCode) {
        this.transactionAmount = transactionAmount;
        this.campaignCode = campaignCode;
        this.name = "MVC Campaign " + campaignCode;
    }

    MVCOption(Amount transactionAmount, String campaignCode, Amount maxBalance) {
        this(transactionAmount, campaignCode);
        this.maxBalance = maxBalance;
        this.name += " Balance Amount: " + maxBalance.getValueAsDouble();
    }

    public Amount getMaxBalance() {
        return maxBalance;
    }

    public Amount getMaxBalanceRounded() {
        int value = (int) Math.floor(maxBalance.getValueAsDouble());
        return new Amount(String.valueOf(value)); //this will convert 2.3 to 2.0 e.g
    }
    @Override
    /**
     * This payment mode is not saved. So not required. Returns null.
     */
    public String getSavePaymentOptionObject() {
        return null;
    }

    @Override
    /**
     * This payment mode is not saved. So not required. Returns null.
     */
    public String getSaveDefaultPaymentOptionObject() {
        // NOOP. This payment mode is not saved. So not required.
        return null;
    }

    @Override
    /**
     * Not required hence returning null.
     */
    public JSONObject getMOTOPaymentOptionObject() throws JSONException {
        return null;
    }

    /**
     * This will return the json required for wallet charge api.
     *
     * @return The json in following format
     * <p/>
     * {
     * "paymentMode": "MVC",
     * "amount": "10",
     * "currency": "INR",
     * "maxBalance": "100",
     * "campaignCode": "VCASH"
     * }
     * @throws JSONException
     */

    @Override
    public JSONObject getWalletChargePaymentOptionObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();

        if (transactionAmount != null) {

            jsonObject.put("paymentMode", "MVC");
            jsonObject.put("campaignCode", campaignCode);

            if (maxBalance != null) {
                jsonObject.put("maxBalance", String.valueOf(maxBalance.getValueAsDouble()));
            }

            // Amount Details.
            jsonObject.put("amount", String.valueOf(transactionAmount.getValueAsDouble()));
            jsonObject.put("currency", transactionAmount.getCurrency());
        }

        return jsonObject;
    }

    @Override
    public Drawable getOptionIcon(Context context) {
        return null;
    }

    @Override
    public PaymentType getAnalyticsPaymentType() {
        return PaymentType.MVC;
    }

    @Override
    public String getDynamicPricingPaymentMode() {
        return "MVC";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeParcelable(this.maxBalance, 0);
        dest.writeString(this.campaignCode);
    }

    protected MVCOption(Parcel in) {
        super(in);
        this.maxBalance = in.readParcelable(Amount.class.getClassLoader());
        this.campaignCode = in.readString();
    }

    public static final Creator<MVCOption> CREATOR = new Creator<MVCOption>() {
        public MVCOption createFromParcel(Parcel source) {
            return new MVCOption(source);
        }

        public MVCOption[] newArray(int size) {
            return new MVCOption[size];
        }
    };
}
