package com.citrus.sdk.login;

import android.app.Dialog;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.design.widget.TextInputLayout;
import android.support.v4.app.DialogFragment;
import android.support.v7.widget.CardView;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.citrus.library.R;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.response.CitrusError;

public class CitrusLoginScreenFragment extends DialogFragment {

    private CitrusLoginScreenFragmentListener listener = null;
    public static final String INTENT_EXTRA_CITRUS_USER = "INTENT_EXTRA_CITRUS_USER";
    public static final String INTENT_EXTRA_AVAILABLE_LOGIN_TYPE = "INTENT_EXTRA_AVAILABLE_LOGIN_TYPE";

    private CitrusUser citrusUser = null;
    private String mobile = null;
    private String email = null;
    private AvailableLoginType availableLoginType = null;
    private boolean skipToSecondScreen = false;

    private RelativeLayout layoutLoginFirstScreen = null;
    private RelativeLayout layoutLoginSecondScreen = null;

    // Screen 1 controls
    private EditText editMobile = null;
    private EditText editEmail = null;
    private Button btnGetStarted = null;

    // Screen 2 controls
    private TextView editPrefilledMobile = null;
    private TextView editPrefilledEmail = null;
    private ImageButton btnEditDetails = null;

    private CardView cardViewLoginWithOTP = null;
    private CardView cardViewLoginWithPassword = null;

    private TextInputLayout txtLayoutOTP = null;
    private EditText editOTP = null;
    private Button btnLoginWithPassword = null;
    private Button btnGetStartedWithOTP = null;

    private TextInputLayout txtLayoutPassword = null;
    private EditText editPassword = null;
    private Button btnGetStartedWithPassword = null;
    private Button btnLoginWithOTP = null;

    public CitrusLoginScreenFragment() {
        // Required empty public constructor
    }

    /**
     * Pass mobile no and email id if you already have. If mobile no. and email id is passed first screen is bypassed.
     * And the user is directed to the second screen where the user needs to enter OTP or password based on available login types.
     *
     * @return
     */
    public static CitrusLoginScreenFragment newInstance(CitrusUser citrusUser, AvailableLoginType availableLoginType) {
        CitrusLoginScreenFragment fragment = new CitrusLoginScreenFragment();
        Bundle args = new Bundle();
        args.putParcelable(INTENT_EXTRA_CITRUS_USER, citrusUser);
        args.putString(INTENT_EXTRA_AVAILABLE_LOGIN_TYPE, availableLoginType.name());

        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            citrusUser = getArguments().getParcelable(INTENT_EXTRA_CITRUS_USER);
            if (citrusUser != null) {
                mobile = citrusUser.getMobileNo();
                email = citrusUser.getEmailId();

                // If mobile is present then we can directly skip to second screen.
                if (!TextUtils.isEmpty(mobile)) {
                    skipToSecondScreen = true;
                }
            }

            String availableLoginTypeName = getArguments().getString(INTENT_EXTRA_AVAILABLE_LOGIN_TYPE);
            if (!TextUtils.isEmpty(availableLoginTypeName)) {
                availableLoginType = AvailableLoginType.valueOf(availableLoginTypeName);
            }
        }

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) {
            setStyle(DialogFragment.STYLE_NORMAL, android.R.style.Theme_Holo_Light_DarkActionBar);
        }

        setCancelable(false);
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        return new Dialog(getActivity(), getTheme()) {
            @Override
            public void onBackPressed() {
                dismiss();
                if (listener != null) {
                    listener.onCancel();
                }
            }
        };
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {

        // Inflate the layout for this fragment
        View rootView = inflater.inflate(R.layout.citrus_login_screen, container, false);
        layoutLoginFirstScreen = (RelativeLayout) rootView.findViewById(R.id.layout_login_first_screen);
        layoutLoginSecondScreen = (RelativeLayout) rootView.findViewById(R.id.layout_login_second_screen);

        editMobile = (EditText) rootView.findViewById(R.id.edit_mobile);
        editEmail = (EditText) rootView.findViewById(R.id.edit_mobile);
        btnGetStarted = (Button) rootView.findViewById(R.id.btn_get_me_started);
        btnGetStarted.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getMeStarted();
            }
        });

        editPrefilledMobile = (TextView) rootView.findViewById(R.id.prefilledMobile);
        editPrefilledEmail = (TextView) rootView.findViewById(R.id.prefilledEmail);
        btnEditDetails = (ImageButton) rootView.findViewById(R.id.btn_edit_details);
        btnEditDetails.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                editDetails();
            }
        });

        cardViewLoginWithOTP = (CardView) rootView.findViewById(R.id.card_view_login_with_otp);
        txtLayoutOTP = (TextInputLayout) rootView.findViewById(R.id.txt_layout_otp);
        editOTP = (EditText) rootView.findViewById(R.id.edit_otp);
        btnGetStartedWithOTP = (Button) rootView.findViewById(R.id.btn_get_started_with_otp);
        btnGetStartedWithOTP.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getStartedWithOTPClicked();
            }
        });
        btnLoginWithPassword = (Button) rootView.findViewById(R.id.btn_login_with_password);
        btnLoginWithPassword.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                loginWithPasswordClicked();
            }
        });
        editOTP.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                txtLayoutOTP.setErrorEnabled(false);
            }
        });
        txtLayoutOTP.setErrorEnabled(false);

        cardViewLoginWithPassword = (CardView) rootView.findViewById(R.id.card_view_login_with_password);
        txtLayoutPassword = (TextInputLayout) rootView.findViewById(R.id.txt_layout_password);
        editPassword = (EditText) rootView.findViewById(R.id.edit_password);
        btnGetStartedWithPassword = (Button) rootView.findViewById(R.id.btn_get_started_with_password);
        btnGetStartedWithPassword.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getStartedWithPasswordClicked();
            }
        });
        btnLoginWithOTP = (Button) rootView.findViewById(R.id.btn_login_with_otp);
        btnLoginWithOTP.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                loginWithOTPClicked();
            }
        });
        editPassword.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                txtLayoutPassword.setErrorEnabled(false);
            }
        });
        txtLayoutPassword.setErrorEnabled(false);

        if (skipToSecondScreen) {
            skipToSecondScreen();
        }

        return rootView;
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        if (getDialog() != null) {
            getDialog().getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_PAN | WindowManager.LayoutParams.SOFT_INPUT_STATE_HIDDEN);
        }
    }

    public void onLoginErrorOccurred(CitrusLoginClient.PasswordType passwordType, CitrusError error) {
        if (passwordType == CitrusLoginClient.PasswordType.OTP) {
            txtLayoutOTP.setErrorEnabled(true);
            txtLayoutOTP.setError("Wrong OTP. Please try again.");
        } else {
            txtLayoutPassword.setErrorEnabled(true);
            txtLayoutPassword.setError("Wrong password.");
        }
    }

    private void getMeStarted() {

    }

    private void skipToSecondScreen() {
        showSecondLoginScreen(mobile, email);
    }

    private void showFirstLoginScreen(String mobile, String email) {
        editMobile.setText(mobile);

        if (!TextUtils.isEmpty(email)) {
            editEmail.setText(email);
            editEmail.setVisibility(View.VISIBLE);
        } else {
            editEmail.setVisibility(View.GONE);
        }

        layoutLoginFirstScreen.setVisibility(View.VISIBLE);
        layoutLoginSecondScreen.setVisibility(View.GONE);
    }

    private void showSecondLoginScreen(String mobile, String email) {
        editPrefilledMobile.setText(mobile);

        if (!TextUtils.isEmpty(email)) {
            editPrefilledEmail.setText(email);
            editPrefilledEmail.setVisibility(View.VISIBLE);
        } else {
            editPrefilledEmail.setVisibility(View.GONE);
        }

        layoutLoginSecondScreen.setVisibility(View.VISIBLE);
        layoutLoginFirstScreen.setVisibility(View.GONE);
    }

    private void editDetails() {
        showFirstLoginScreen(editPrefilledMobile.getText().toString(), editPrefilledEmail.getText().toString());
    }

    private void getStartedWithOTPClicked() {
        String otp = editOTP.getText().toString();
        if (!TextUtils.isEmpty(otp)) {
            login(otp, CitrusLoginClient.PasswordType.OTP);
        } else {
            txtLayoutOTP.setErrorEnabled(true);
            txtLayoutOTP.setError("Wrong OTP. Please try again.");
        }
    }

    private void loginWithPasswordClicked() {
        cardViewLoginWithOTP.setVisibility(View.GONE);
        cardViewLoginWithPassword.setVisibility(View.VISIBLE);
    }

    private void getStartedWithPasswordClicked() {
        String password = editPassword.getText().toString();
        if (!TextUtils.isEmpty(password)) {
            login(password, CitrusLoginClient.PasswordType.PASSWORD);
        } else {
            txtLayoutPassword.setErrorEnabled(true);
            txtLayoutPassword.setError("Wrong password.");
        }
    }

    private void loginWithOTPClicked() {
        cardViewLoginWithPassword.setVisibility(View.GONE);
        cardViewLoginWithOTP.setVisibility(View.VISIBLE);
    }

    private void login(String emailOrPassword, CitrusLoginClient.PasswordType passwordType) {
        if (listener != null) {
            listener.onLoginClicked(emailOrPassword, passwordType);
        }
    }

    @Override
    public void onDetach() {
        super.onDetach();
    }

    public void setListener(CitrusLoginScreenFragmentListener listener) {
        this.listener = listener;
    }

    public interface CitrusLoginScreenFragmentListener {
        void onLoginClicked(String emailOrPassword, CitrusLoginClient.PasswordType passwordType);

        void onCancel();
    }
}
