package com.citrus.sdk.login;

import android.content.Context;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.AppCompatActivity;

import com.citrus.sdk.response.CitrusError;

/**
 * Created by salil on 18/5/16.
 */
public class CitrusLoginProcessor extends CitrusLoginClient.LoginProcessor {

    private CitrusLoginScreenFragment citrusLoginScreenFragment = null;
    private String passwordOrOTP = null;
    private CitrusLoginClient.PasswordType passwordType = null;

    public CitrusLoginProcessor(Context context) {
        super(context);
    }


    @Override
    public void onShowLoginScreen(LoginInfo loginInfo, CitrusLoginClient citrusLoginClient) {
        showLoginScreen(loginInfo, citrusLoginClient);
    }

    @Override
    public CitrusLoginClient.PasswordType getPasswordType() {
        return passwordType;
    }

    @Override
    public String getPasswordOrOTP() {
        return passwordOrOTP;
    }

    @Override
    public void onLoginError(CitrusLoginClient.PasswordType passwordType, CitrusError error) {

    }

    @Override
    public void onHideLoginScreen() {
        hideLoginScreen();
    }

    private void showLoginScreen(final LoginInfo loginInfo, final CitrusLoginClient citrusLoginClient) {

        if (context instanceof AppCompatActivity) {
            AppCompatActivity activity = (AppCompatActivity) context;
            FragmentManager fragmentManager = activity.getSupportFragmentManager();
            citrusLoginScreenFragment = CitrusLoginScreenFragment.newInstance(loginInfo.getCitrusUser(), loginInfo.getAvailableLoginType());
            citrusLoginScreenFragment.setListener(new CitrusLoginScreenFragment.CitrusLoginScreenFragmentListener() {
                @Override
                public void onLoginClicked(String passwordOrOTP, CitrusLoginClient.PasswordType passwordType) {
                    CitrusLoginProcessor.this.passwordOrOTP = passwordOrOTP;
                    CitrusLoginProcessor.this.passwordType = passwordType;
                    citrusLoginClient.proceed(loginInfo);
                }

                @Override
                public void onCancel() {
                    citrusLoginClient.onLoginCancelled();
                }
            });
            citrusLoginScreenFragment.show(fragmentManager, "login_fragment");
        }
    }

    private void hideLoginScreen() {
        if (citrusLoginScreenFragment != null) {
            citrusLoginScreenFragment.dismiss();
        }
    }
}
