package com.citrus.sdk;

import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.CitrusException;

/**
 * Object of this class will be used to update existing active subscription
 * Created by mangesh on 9/2/16.
 */
public class UpdateSubscriptionRequest {

    String subscriptionId;

    String loadAmount;

    String thresholdAmount;

    Amount loadAmt;

    Amount thresholdAmt;

    public void setAuthRefId(String authRefId) {
        this.authRefId = authRefId;
    }

    public String getAuthRefId() {
        return authRefId;
    }

    String authRefId;

    /**
     * Use this constructor for updating Subscription to lower value
     * @param subscriptionId
     * @param loadAmt
     * @param thresholdAmt
     * @throws CitrusException
     */
    public UpdateSubscriptionRequest(String subscriptionId, Amount loadAmt, Amount thresholdAmt) throws CitrusException {
        this.subscriptionId = subscriptionId;
        this.loadAmt = loadAmt;
        this.thresholdAmt = thresholdAmt;
        try {
            Double.parseDouble(loadAmt.getValue());
            loadAmount = loadAmt.getValue();
        } catch (NumberFormatException e) {
            throw new CitrusException("LoadAmount is not valid");
        }

        try {
            Double.parseDouble(thresholdAmt.getValue());
            thresholdAmount = thresholdAmt.getValue();
        } catch (NumberFormatException e) {
            throw new CitrusException("ThresholdAmount is not valid");
        }
    }


    /**
     * Use this constructor for updating Subscription to lower value
     * @param subscriptionId
     * @param loadAmount
     * @param thresholdAmount
     * @throws CitrusException
     */
    public UpdateSubscriptionRequest(String subscriptionId, String loadAmount, String thresholdAmount) throws CitrusException {
        this.subscriptionId = subscriptionId;
        this.loadAmount = loadAmount;
        this.thresholdAmount = thresholdAmount;
        try {
            Double.parseDouble(loadAmount);
        } catch (NumberFormatException e) {
            throw new CitrusException("LoadAmount is not valid");
        }

        try {
            Double.parseDouble(thresholdAmount);
        } catch (NumberFormatException e) {
            throw new CitrusException("ThresholdAmount is not valid");
        }
    }



    public String getSubscriptionId() {
        return subscriptionId;
    }

    public String getLoadAmount() {
        return loadAmount;
    }

    public String getThresholdAmount() {
        return thresholdAmount;
    }
}
