/*
 *
 *    Copyright 2014 Citrus Payment Solutions Pvt. Ltd.
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 * /
 */

package com.citrus.sdk;

/**
 * Created by salil on 24/4/15.
 */
public interface Constants {
    String SDK_VERSION = "3.6.0";
    String SCOPE_PREPAID_MERCHANT_PAY = "prepaid_merchant_pay";
    int SDK_VERSION_CODE = 3;
    String MEDIA_TYPE_JSON = "application/json";

    String AMOUNT_DOUBLE_PRECISION_FORMAT = "#.00";

    int SMS_RECEIVER_PRIORITY = 999;

    String INTENT_EXTRA_TRANSACTION_RESPONSE = "INTENT_EXTRA_TRANSACTION_RESPONSE";

    String INTENT_EXTRA_DYNAMIC_PRICING_RESPONSE = "INTENT_EXTRA_DYNAMIC_PRICING_RESPONSE";

    String INTENT_EXTRA_USE_NEW_API = "INTENT_EXTRA_USE_NEW_API";

    /**
     * Use this constant to pass the payment type. {@link com.citrus.sdk.payment.PaymentType}
     */
    String INTENT_EXTRA_PAYMENT_TYPE = "INTENT_EXTRA_PAYMENT_TYPE";

    String INTENT_EXTRA_REQUEST_CODE_PAYMENT = "INTENT_EXTRA_REQUEST_CODE_PAYMENT";

    int REQUEST_CODE_PAYMENT = 10000;

    String JS_INTERFACE_NAME = "CitrusResponse";
    String HEADER_PREPAID_COOKIE = "prepaiduser-payauth";
    String CITRUS_PREPAID_COOKIE = "prepaiduser-payauth=''";

    String SIGNIN_TOKEN = "signin_token";
    String SIGNUP_TOKEN = "signup_token";
    String PREPAID_TOKEN = "prepaid_token";
    String PAY_USING_CITRUS_CASH_TOKEN = "pay_using_citrus_cash_token";
    String IS_TOKEN_REFRESHED = "IS_TOKEN_REFRESHED";

    String STORED_VALUES = "UserStorage";

    //emailID and MobileNo is saved after SignIn token is received
    String EMAIL_ID = "email_id";

    String MOBILE_NO = "mobile_no";

    String ENVIRONMENT = "environment";

    // Colors
    String colorPrimaryDark = "#E7961D";
    String colorPrimary = "#F9A323";
    String textColor = "#ffffff";
    String accentColor = "";

    String ACTION_LOAD_MONEY = "ACTION_LOAD_MONEY";
    String ACTION_PAY_USING_CASH = "ACTION_PAY_USING_CASH";
    String ACTION_PG_PAYMENT = "ACTION_PG_PAYMENT";
    String ACTION_WALLET_PG_PAYMENT = "ACTION_WALLET_PG_PAYMENT";

    String PREPAID_VANITY = "prepaid";
    String SIGNUP_SUCCESS_CODE = "R-201-00";

    String ACTION_SMS_RECEIVED = "android.provider.Telephony.SMS_RECEIVED";
    String ACTION_AUTO_READ_OTP = "com.citrus.sdk.otp.AUTO_READ_OTP";
    String INTENT_EXTRA_AUTO_OTP = "INTENT_EXTRA_AUTO_OTP";

    String COUNTRY_INDIA = "INDIA";

    enum TokenType {SIGNIN_TOKEN, SIGNUP_TOKEN, PREPAID_TOKEN, PAY_USING_CITRUS_CASH_TOKEN}

    boolean isEncryptedAccessToken = false;

    String DEACTIVATE_SUBSCRIPTION = "Inactive";

    String HOLDER_NAME  = "Citrus";

    String[] AUTO_LOAD_CARD_SCHEMS = {"MASTER_CARD", "VISA"};



}


