package com.citrus.widgets.webview;


import android.net.http.SslError;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;

/**
 * Created by vinay on 4/3/16.
 */
public interface CitrusWebViewClient {

    public void onPageStarted(CitrusWebView view, String url ) ;

    public void onPageFinished(CitrusWebView view, String url) ;

    public void onReceivedSslError(CitrusWebView view, SslErrorHandler handler, SslError error);

    public void onReceivedError(CitrusWebView view, WebResourceRequest request, WebResourceError error) ;

    public void onReceivedHttpError(CitrusWebView view, WebResourceRequest request, WebResourceResponse errorResponse) ;

    /**
     * @return true if result is handled - You need to call CitrusWebView.close( ) explicitly.
     * false otherwise (will close the WebView).
     * */
    public boolean onTransactionComplete(CitrusWebView view, boolean transactionSuccessful ) ;
}
