package com.citrus.sdk.walletpg;

import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.payment.PaymentOption;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by salil on 22/1/16.
 */
public class WalletPGConsumerProfile {
    private String merchantAccessKey;
    private String username;
    private Amount amount;
    private CitrusUser citrusUser;
    private List<PaymentOption> paymentOptionsList;

    private WalletPGConsumerProfile() {

    }

    private WalletPGConsumerProfile(String merchantAccessKey, String username, Amount amount, CitrusUser citrusUser, List<PaymentOption> paymentOptionsList) {
        this.merchantAccessKey = merchantAccessKey;
        this.username = username;
        this.amount = amount;
        this.citrusUser = citrusUser;
        this.paymentOptionsList = paymentOptionsList;
    }

    public static WalletPGConsumerProfile fromJSON(JSONObject jsonObject) {
        WalletPGConsumerProfile walletPGConsumerProfile = null;

        String merchantAccessKey = jsonObject.optString("merchantAccessKey");
        String username = jsonObject.optString("username");
        String amountValue = jsonObject.optString("amount");
        String currency = jsonObject.optString("currency");

        JSONObject userDetails = jsonObject.optJSONObject("userDetails");
        JSONArray paymentOptionsArray = jsonObject.optJSONArray("paymentOptionsList");

        Amount amount = new Amount(amountValue, currency);
        CitrusUser citrusUser = CitrusUser.fromJSONObject(userDetails);
        List<PaymentOption> paymentOptionsList = null;

        if (paymentOptionsList != null) {
            for (int i = 0; i < paymentOptionsArray.length(); i++) {
                if (paymentOptionsList == null) {
                    paymentOptionsList = new ArrayList<>();
                }

                PaymentOption paymentOption = PaymentOption.fromJSONObject(paymentOptionsArray.optJSONObject(i));
                paymentOptionsList.add(paymentOption);
            }
        }

        walletPGConsumerProfile = new WalletPGConsumerProfile(merchantAccessKey, username, amount, citrusUser, paymentOptionsList);

        return walletPGConsumerProfile;
    }

    public static WalletPGConsumerProfile fromJSONString(String json) {
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(json);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        return fromJSON(jsonObject);
    }
}