package com.citrus.sdk;

import android.text.TextUtils;

/**
 * Created by MANGESH KADAM on 6/3/2015.
 */
public enum Environment {
    SANDBOX {
        @Override
        public String getBaseUrl() {
            return "https://sandboxadmin.citruspay.com";
        }

        @Override
        public String getBaseCitrusUrl() {
            return "https://sandbox.citruspay.com";
        }

        @Override
        public String getDynamicPricingBaseUrl() {
            return "https://sandboxmars1.citruspay.com";
        }

        @Override
        public String getDynamicPricingPath() {
            return "dynamic-pricing";
        }

        @Override
        public String getBinServiceURL() {
            return "https://citrusapi.citruspay.com";
        }

        public String getAnalyticsID() {
            return "UA-33514461-4";
        }

        @Override
        public String getCancelUrl(String vanity) {
            return String.format(getBaseCitrusUrl() + "/sslperf/%s/cancel", vanity);
        }

        @Override
        public String toString() {
            return "SANDBOX";
        }
    }, PRODUCTION {
        @Override
        public String getBaseUrl() {
            return "https://admin.citruspay.com";
        }

        @Override
        public String getBaseCitrusUrl() {
            return "https://citruspay.com";
        }

        @Override
        public String getBinServiceURL() {
            return "https://citrusapi.citruspay.com";
        }


        @Override
        public String getDynamicPricingBaseUrl() {
            return "https://mars.citruspay.com";
        }

        @Override
        public String getDynamicPricingPath() {
            return "dynamicpricing";
        }

        public String getAnalyticsID() {
            return "UA-33514461-5";
        }

        @Override
        public String getCancelUrl(String vanity) {
            return String.format(getBaseCitrusUrl() + "/sslperf/%s/cancel", vanity);
        }

        @Override
        public String toString() {
            return "PRODUCTION";
        }
    }, CUSTOM {

        String baseUrl;
        String baseCitrusUrl;
        String dynamicPricingBaseUrl;
        String dynamicPricingPath;

        @Override
        public String getBaseUrl() {
            return baseUrl;
        }

        public void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        @Override
        public String getBaseCitrusUrl() {
            return baseCitrusUrl;
        }

        public void setBaseCitrusUrl(String baseCitrusUrl) {
            this.baseCitrusUrl = baseCitrusUrl;
        }

        @Override
        public String getBinServiceURL() {
            return "https://citrusapi.citruspay.com";
        }

        @Override
        public String getDynamicPricingBaseUrl() {
            return dynamicPricingBaseUrl;
        }

        public void setDynamicPricingBaseUrl(String dynamicPricingBaseUrl) {
            this.dynamicPricingBaseUrl = dynamicPricingBaseUrl;
        }

        @Override
        public String getDynamicPricingPath() {
            if (!TextUtils.isEmpty(dynamicPricingPath)) {
                return dynamicPricingPath;
            } else {
                return "dynamic-pricing";
            }
        }

        public void setDynamicPricingPath(String dynamicPricingPath) {
            this.dynamicPricingPath = dynamicPricingPath;
        }

        public String getAnalyticsID() {
            return "UA-33514461-4";
        }

        @Override
        public String getCancelUrl(String vanity) {
            return String.format(getBaseCitrusUrl() + "/sslperf/%s/cancel", vanity);
        }

        @Override
        public String toString() {
            return "CUSTOM";
        }
    }, STG18 {
        @Override
        public String getBaseUrl() {
            return "https://stgadmin18.citruspay.com/";
        }

        @Override
        public String getBaseCitrusUrl() {
            return "https://stgpg18.citruspay.com/";
        }

        @Override
        public String getDynamicPricingBaseUrl() {
            return "https://stgadmin18.citruspay.com";
        }

        @Override
        public String getDynamicPricingPath() {
            return "dynamic-pricing";
        }

        public String getAnalyticsID() {
            return "UA-33514461-4";
        }

        @Override
        public String toString() {
            return "STG18";
        }

        @Override
        public String getBinServiceURL() {
            return "https://citrusapi.citruspay.com";
        }

        @Override
        public String getCancelUrl(String vanity) {
            return String.format(getBaseCitrusUrl() + "/sslperf/%s/cancel", vanity);
        }
    },

    NONE {
        @Override
        public String getBaseUrl() {
            return null;
        }

        @Override
        public String toString() {
            return null;
        }

        @Override
        public String getBaseCitrusUrl() {
            return null;
        }

        @Override
        public String getBinServiceURL() {
            return null;
        }

        @Override
        public String getDynamicPricingBaseUrl() {
            return null;
        }

        @Override
        public String getDynamicPricingPath() {
            return null;
        }

        @Override
        public String getAnalyticsID() {
            return null;
        }

        @Override
        public String getCancelUrl(String vanity) {
            return null;
        }
    };

    public abstract String getBaseUrl();

    public abstract String getBaseCitrusUrl();

    public abstract String getBinServiceURL();

    public abstract String getDynamicPricingBaseUrl();

    public abstract String getDynamicPricingPath();

    public abstract String getAnalyticsID();

    public abstract String getCancelUrl(String vanity);
}
