package com.citrus.sdk.views;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.os.CountDownTimer;
import android.view.Gravity;
import android.view.Window;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

/**
 * Created by salil on 29/1/16.
 */
public class CitrusProgressBar extends Dialog {

    private ProgressBar mProgressBar = null;
    private TextView mTextView = null;
    private Context mContext = null;
    private CountDownTimer mCountDownTimer = null;
    private int COUNTDOWN_TIME = 10000;

    public CitrusProgressBar(Context context) {
        super(context);

        mContext = context;
        init();
    }

    public CitrusProgressBar(Context context, int themeResId, Context mContext) {
        super(context, themeResId);
        this.mContext = mContext;

        init();
    }

    public CitrusProgressBar(Context context, boolean cancelable, OnCancelListener cancelListener, Context mContext) {
        super(context, cancelable, cancelListener);
        this.mContext = mContext;

        init();
    }

    /**
     * Initialize the views.
     */
    private void init() {
        mCountDownTimer = new CountDownTimer(COUNTDOWN_TIME, 100) {
            @Override
            public void onTick(long millisUntilFinished) {
                setProgressBarColor(millisUntilFinished);
            }

            @Override
            public void onFinish() {
                setProgressBarColor(0);
            }
        };

        mProgressBar = new ProgressBar(mContext);
        mProgressBar.setIndeterminate(true);
        mProgressBar.setPadding(16, 16, 16, 16);
        // Set layout params
        mProgressBar.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT));

        mTextView = new TextView(mContext);
        mTextView.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT));
        mTextView.setGravity(Gravity.LEFT);
        mTextView.setPadding(16, 16, 16, 16);

        LinearLayout linearLayout = new LinearLayout(mContext);
        linearLayout.setOrientation(LinearLayout.HORIZONTAL);
        linearLayout.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT));
        linearLayout.setPadding(16, 16, 0, 16);
        linearLayout.setGravity(Gravity.CENTER_VERTICAL);

        linearLayout.addView(mProgressBar);
        linearLayout.addView(mTextView);

        // Remove title from the dialog.
        requestWindowFeature(Window.FEATURE_NO_TITLE);

        setContentView(linearLayout);
    }

    public void setMessage(String message) {
        mTextView.setText(message);
    }

    @Override
    public void show() {
        super.show();

        startTimer();
    }

    @Override
    public void hide() {
        super.hide();

        stopTimer();
    }

    private void startTimer() {
        mCountDownTimer.start();
    }

    private void stopTimer() {
        mCountDownTimer.cancel();
    }

    private void setProgressBarColor(long millisUntilFinished) {
        String colorCode = "#FF0080";
        switch ((int) (millisUntilFinished / 1000)) {
            case 1:
            case 6:
                colorCode = "#0040FF";
                break;
            case 2:
            case 7:
                colorCode = "#FF0000";
                break;
            case 3:
            case 8:
                colorCode = "#AEB404";
                break;
            case 4:
            case 9:
                colorCode = "#088A08";
                break;
            case 5:
            case 0:
                colorCode = "#4000FF";
                break;
        }
        mProgressBar.getIndeterminateDrawable().setColorFilter(Color.parseColor(colorCode), PorterDuff.Mode.MULTIPLY);
    }
}
