package com.citrus.sdk.payment;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Parcel;

import com.citrus.analytics.PaymentType;
import com.citrus.sdk.classes.Amount;

/**
 * Created by salil on 22/1/16.
 */
public class MVCOption extends PaymentOption {

    private Amount amount = null;
    private boolean selected = false;
    private boolean shown = false;
    private boolean defaultPaymentMode = false;
    private Amount maxBalance = null;
    private String campaignCode = null;

    public MVCOption() {
    }

    private MVCOption(Amount amount, boolean selected, boolean shown, boolean defaultPaymentMode, Amount maxBalance, String campaignCode) {
        this.amount = amount;
        this.selected = selected;
        this.shown = shown;
        this.defaultPaymentMode = defaultPaymentMode;
        this.maxBalance = maxBalance;
        this.campaignCode = campaignCode;
    }

    @Override
    public String getSavePaymentOptionObject() {
        return null;
    }

    @Override
    public String getSaveDefaultPaymentOptionObject() {
        return null;
    }

    @Override
    public Drawable getOptionIcon(Context context) {
        return null;
    }

    @Override
    public PaymentType getAnalyticsPaymentType() {
        return null;
    }

    @Override
    public String getDynamicPricingPaymentMode() {
        return null;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeParcelable(this.amount, 0);
        dest.writeByte(selected ? (byte) 1 : (byte) 0);
        dest.writeByte(shown ? (byte) 1 : (byte) 0);
        dest.writeByte(defaultPaymentMode ? (byte) 1 : (byte) 0);
        dest.writeParcelable(this.maxBalance, 0);
        dest.writeString(this.campaignCode);
    }

    protected MVCOption(Parcel in) {
        super(in);
        this.amount = in.readParcelable(Amount.class.getClassLoader());
        this.selected = in.readByte() != 0;
        this.shown = in.readByte() != 0;
        this.defaultPaymentMode = in.readByte() != 0;
        this.maxBalance = in.readParcelable(Amount.class.getClassLoader());
        this.campaignCode = in.readString();
    }

    public static final Creator<MVCOption> CREATOR = new Creator<MVCOption>() {
        public MVCOption createFromParcel(Parcel source) {
            return new MVCOption(source);
        }

        public MVCOption[] newArray(int size) {
            return new MVCOption[size];
        }
    };
}
