/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.response;

import android.os.Parcel;
import android.os.Parcelable;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.TransactionResponse;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.response.CitrusResponse;
import com.google.gson.annotations.SerializedName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class PaymentResponse
extends CitrusResponse
implements Parcelable {
    @SerializedName(value="id")
    protected String transactionId = null;
    @SerializedName(value="amount")
    protected Amount transactionAmount = null;
    @SerializedName(value="balance")
    protected Amount balanceAmount = null;
    @SerializedName(value="cutsomer")
    protected String customer = null;
    @SerializedName(value="merchant")
    protected String merchantName = null;
    @SerializedName(value="date")
    protected String date = null;
    protected TransactionResponse transactionResponse = null;
    private JSONObject responseParams = null;
    protected CitrusUser user = null;
    public static final Parcelable.Creator<PaymentResponse> CREATOR = new Parcelable.Creator<PaymentResponse>(){

        public PaymentResponse createFromParcel(Parcel source) {
            return new PaymentResponse(source);
        }

        public PaymentResponse[] newArray(int size) {
            return new PaymentResponse[size];
        }
    };

    public TransactionResponse getTransactionResponse() {
        return this.transactionResponse;
    }

    PaymentResponse() {
    }

    public PaymentResponse(String message, CitrusResponse.Status status, String transactionId, Amount transactionAmount, Amount balanceAmount, CitrusUser user) {
        super(message, status);
        this.transactionId = transactionId;
        this.transactionAmount = transactionAmount;
        this.balanceAmount = balanceAmount;
        this.user = user;
    }

    public PaymentResponse(String message, CitrusResponse.Status status, String transactionId, Amount transactionAmount, Amount balanceAmount, CitrusUser user, String merchantName, String date, TransactionResponse transactionResponse) {
        super(message, status);
        this.transactionId = transactionId;
        this.transactionAmount = transactionAmount;
        this.balanceAmount = balanceAmount;
        this.merchantName = merchantName;
        this.date = date;
        this.transactionResponse = transactionResponse;
        this.user = user;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public Amount getTransactionAmount() {
        return this.transactionAmount;
    }

    public Amount getBalanceAmount() {
        return this.balanceAmount;
    }

    public CitrusUser getUser() {
        return this.user;
    }

    public String getMerchantName() {
        return this.merchantName;
    }

    public String getDate() {
        return this.date;
    }

    public String getCustomer() {
        return this.customer;
    }

    private void setResponseParams(JSONObject responseParams) {
        this.responseParams = responseParams;
    }

    public String getURLEncodedParams() {
        StringBuffer buffer = new StringBuffer();
        if (this.responseParams != null) {
            Iterator keys = this.responseParams.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                buffer.append(key);
                buffer.append("=");
                try {
                    buffer.append(URLEncoder.encode(this.responseParams.optString(key), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                buffer.append("&");
            }
        }
        return buffer.toString();
    }

    public static PaymentResponse fromJSON(String json) {
        PaymentResponse paymentResponse = null;
        try {
            JSONObject responseParams;
            TransactionResponse transactionResponse;
            JSONObject jsonObject = new JSONObject(json);
            String customer = jsonObject.optString("customer", jsonObject.optString("cutsomer"));
            CitrusResponse.Status status = CitrusResponse.Status.valueOf(jsonObject.optString("status"));
            String message = status == CitrusResponse.Status.SUCCESSFUL ? "Transaction Successful" : jsonObject.optString("reason");
            String date = jsonObject.optString("date");
            String merchantName = jsonObject.optString("merchant");
            Amount transactionAmount = Amount.fromJSONObject(jsonObject.optJSONObject("amount"));
            Amount balanceAmount = Amount.fromJSONObject(jsonObject.optJSONObject("balance"));
            HashMap<String, String> customParamsMap = null;
            JSONObject customParamsObject = jsonObject.optJSONObject("customParams");
            if (customParamsObject != null) {
                customParamsMap = new HashMap<String, String>();
                Iterator iter = customParamsObject.keys();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = customParamsObject.optString(key);
                    customParamsMap.put(key, value);
                }
            }
            String transactionId = (transactionResponse = TransactionResponse.fromJSONObject(responseParams = jsonObject.optJSONObject("responseParams"), customParamsMap)) != null ? transactionResponse.getTransactionId() : null;
            CitrusUser citrusUser = transactionResponse.getCitrusUser();
            paymentResponse = new PaymentResponse(message, status, transactionId, transactionAmount, balanceAmount, citrusUser, merchantName, date, transactionResponse);
            paymentResponse.setResponseParams(responseParams);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return paymentResponse;
    }

    public String toString() {
        return "PaymentResponse{transactionId='" + this.transactionId + '\'' + ", transactionAmount=" + this.transactionAmount + ", balanceAmount=" + this.balanceAmount + ", customer='" + this.customer + '\'' + ", merchantName='" + this.merchantName + '\'' + ", date='" + this.date + '\'' + ", transactionResponse=" + this.transactionResponse + ", user=" + this.user + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.transactionId);
        dest.writeParcelable((Parcelable)this.transactionAmount, 0);
        dest.writeParcelable((Parcelable)this.balanceAmount, 0);
        dest.writeString(this.customer);
        dest.writeString(this.merchantName);
        dest.writeString(this.date);
        dest.writeParcelable((Parcelable)this.transactionResponse, 0);
        dest.writeParcelable((Parcelable)this.user, 0);
    }

    protected PaymentResponse(Parcel in) {
        super(in);
        this.transactionId = in.readString();
        this.transactionAmount = (Amount)in.readParcelable(Amount.class.getClassLoader());
        this.balanceAmount = (Amount)in.readParcelable(Amount.class.getClassLoader());
        this.customer = in.readString();
        this.merchantName = in.readString();
        this.date = in.readString();
        this.transactionResponse = (TransactionResponse)in.readParcelable(TransactionResponse.class.getClassLoader());
        this.user = (CitrusUser)in.readParcelable(CitrusUser.class.getClassLoader());
    }
}

