/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import org.json.JSONException;
import org.json.JSONObject;

public final class CitrusUser
implements Parcelable {
    public static final CitrusUser DEFAULT_USER = new CitrusUser("developercitrus@gmail.com", "9876543210", "Developer", "Citrus", Address.DEFAULT_ADDRESS);
    private String emailId = null;
    private String mobileNo = null;
    private String firstName = null;
    private String lastName = null;
    private Address address = null;
    private boolean emailVerified = false;
    private boolean mobileVerified = false;
    public static final Parcelable.Creator<CitrusUser> CREATOR = new Parcelable.Creator<CitrusUser>(){

        public CitrusUser createFromParcel(Parcel source) {
            return new CitrusUser(source);
        }

        public CitrusUser[] newArray(int size) {
            return new CitrusUser[size];
        }
    };

    private CitrusUser() {
    }

    public CitrusUser(String emailId, String mobileNo) {
        this.emailId = emailId;
        this.mobileNo = mobileNo;
    }

    public CitrusUser(String emailId, String mobileNo, String firstName, String lastName, Address address) {
        this.emailId = emailId;
        this.mobileNo = mobileNo;
        this.firstName = firstName;
        this.lastName = lastName;
        this.address = address;
    }

    private CitrusUser(String emailId, String mobileNo, String firstName, String lastName, boolean emailVerified, boolean mobileVerified, Address address) {
        this.emailId = emailId;
        this.mobileNo = mobileNo;
        this.firstName = firstName;
        this.lastName = lastName;
        this.emailVerified = emailVerified;
        this.mobileVerified = mobileVerified;
        this.address = address;
    }

    public static CitrusUser fromJSON(String json) {
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(json);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return CitrusUser.fromJSONObject(jsonObject);
    }

    public static CitrusUser fromJSONObject(JSONObject response) {
        CitrusUser user = null;
        if (response != null) {
            String email = response.optString("email");
            String mobileNo = response.optString("mobileNo", response.optString("mobile"));
            String firstName = response.optString("firstName");
            String lastName = response.optString("lastName");
            boolean emailVerified = response.optInt("emailVerified", 0) == 1;
            boolean mobileVerified = response.optInt("mobileVerified", 0) == 1;
            Address address = Address.fromJSONObject(response);
            user = new CitrusUser(email, mobileNo, firstName, lastName, emailVerified, mobileVerified, address);
        }
        return user;
    }

    public static JSONObject toJSONObject(CitrusUser user) {
        JSONObject customer = null;
        try {
            customer = new JSONObject();
            if (user == null || TextUtils.isEmpty((CharSequence)user.firstName)) {
                customer.put("firstName", (Object)"Tester");
            } else {
                customer.put("firstName", (Object)user.firstName);
            }
            if (user == null || TextUtils.isEmpty((CharSequence)user.lastName)) {
                customer.put("lastName", (Object)"Citrus");
            } else {
                customer.put("lastName", (Object)user.lastName);
            }
            if (user == null || TextUtils.isEmpty((CharSequence)user.emailId)) {
                customer.put("email", (Object)"tester@gmail.com");
            } else {
                customer.put("email", (Object)user.emailId);
            }
            if (user == null || TextUtils.isEmpty((CharSequence)user.mobileNo)) {
                customer.put("mobileNo", (Object)"9999999999");
            } else {
                customer.put("mobileNo", (Object)user.mobileNo);
            }
            if (user == null || user.address == null || TextUtils.isEmpty((CharSequence)user.address.street1)) {
                customer.put("street1", (Object)"streetone");
            } else {
                customer.put("street1", (Object)user.address.street1);
            }
            if (user == null || user.address == null || TextUtils.isEmpty((CharSequence)user.address.street2)) {
                customer.put("street2", (Object)"streettwo");
            } else {
                customer.put("street2", (Object)user.address.street2);
            }
            if (user == null || user.address == null || TextUtils.isEmpty((CharSequence)user.address.city)) {
                customer.put("city", (Object)"Mumbai");
            } else {
                customer.put("city", (Object)user.address.city);
            }
            if (user == null || user.address == null || TextUtils.isEmpty((CharSequence)user.address.state)) {
                customer.put("state", (Object)"Maharashtra");
            } else {
                customer.put("state", (Object)user.address.state);
            }
            if (user == null || user.address == null || TextUtils.isEmpty((CharSequence)user.address.country)) {
                customer.put("country", (Object)"India");
            } else {
                customer.put("country", (Object)user.address.country);
            }
            if (user == null || user.address == null || TextUtils.isEmpty((CharSequence)user.address.zip)) {
                customer.put("zip", (Object)"400052");
            } else {
                customer.put("zip", (Object)user.address.zip);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return customer;
    }

    public void setMobileNo(String mobileNo) {
        this.mobileNo = mobileNo;
    }

    public void setEmailId(String emailId) {
        this.emailId = emailId;
    }

    public String getEmailId() {
        return this.emailId;
    }

    public String getMobileNo() {
        return this.mobileNo;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public Address getAddress() {
        return this.address;
    }

    public boolean isEmailVerified() {
        return this.emailVerified;
    }

    public boolean isMobileVerified() {
        return this.mobileVerified;
    }

    public String toString() {
        return "CitrusUser{firstName='" + this.firstName + '\'' + ", lastName='" + this.lastName + '\'' + ", emailId='" + this.emailId + '\'' + ", mobileNo='" + this.mobileNo + '\'' + ", address=" + this.address + '}';
    }

    private static String normalizeString(String input) {
        return !TextUtils.isEmpty((CharSequence)input) ? input.replaceAll("[\\p{Cntrl}^\r\n\t]+", "") : null;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.firstName);
        dest.writeString(this.lastName);
        dest.writeString(this.emailId);
        dest.writeString(this.mobileNo);
        dest.writeParcelable((Parcelable)this.address, 0);
        dest.writeByte(this.emailVerified ? (byte)1 : 0);
        dest.writeByte(this.mobileVerified ? (byte)1 : 0);
    }

    protected CitrusUser(Parcel in) {
        this.firstName = in.readString();
        this.lastName = in.readString();
        this.emailId = in.readString();
        this.mobileNo = in.readString();
        this.address = (Address)in.readParcelable(Address.class.getClassLoader());
        this.emailVerified = in.readByte() != 0;
        this.mobileVerified = in.readByte() != 0;
    }

    public static class Address
    implements Parcelable {
        public static Address DEFAULT_ADDRESS = new Address("Street1", "Street2", "Pune", "Maharashtra", "India", "411045");
        public static final Parcelable.Creator<Address> CREATOR = new Parcelable.Creator<Address>(){

            public Address createFromParcel(Parcel source) {
                return new Address(source);
            }

            public Address[] newArray(int size) {
                return new Address[size];
            }
        };
        private String street1 = null;
        private String street2 = null;
        private String city = null;
        private String state = null;
        private String country = null;
        private String zip = null;

        public Address(String street1, String street2, String city, String state, String country, String zip) {
            this.street1 = CitrusUser.normalizeString(street1);
            this.street2 = CitrusUser.normalizeString(street2);
            this.city = CitrusUser.normalizeString(city);
            this.state = CitrusUser.normalizeString(state);
            this.country = CitrusUser.normalizeString(country);
            this.zip = CitrusUser.normalizeString(zip);
        }

        private Address(Parcel in) {
            this.street1 = in.readString();
            this.street2 = in.readString();
            this.city = in.readString();
            this.state = in.readString();
            this.country = in.readString();
            this.zip = in.readString();
        }

        public static Address fromJSONObject(JSONObject response) {
            Address address = null;
            if (response != null) {
                String addressCountry = response.optString("addressCountry", response.optString("country"));
                String addressState = response.optString("addressState", response.optString("state"));
                String addressCity = response.optString("addressCity", response.optString("city"));
                String addressStreet1 = response.optString("addressStreet1", response.optString("street1"));
                String addressStreet2 = response.optString("addressStreet2", response.optString("street2"));
                String addressZip = response.optString("addressZip", response.optString("zip"));
                address = new Address(addressStreet1, addressStreet2, addressCity, addressState, addressCountry, addressZip);
            }
            return address;
        }

        public String getStreet1() {
            return this.street1;
        }

        public String getStreet2() {
            return this.street2;
        }

        public String getCity() {
            return this.city;
        }

        public String getState() {
            return this.state;
        }

        public String getCountry() {
            return this.country;
        }

        public String getZip() {
            return this.zip;
        }

        public String toString() {
            return "Address{street1='" + this.street1 + '\'' + ", street2='" + this.street2 + '\'' + ", city='" + this.city + '\'' + ", state='" + this.state + '\'' + ", country='" + this.country + '\'' + ", zip='" + this.zip + '\'' + '}';
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.street1);
            dest.writeString(this.street2);
            dest.writeString(this.city);
            dest.writeString(this.state);
            dest.writeString(this.country);
            dest.writeString(this.zip);
        }
    }
}

