/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.mobile;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import com.citrus.mobile.Config;
import com.citrus.mobile.OAuth2GrantType;
import com.citrus.mobile.RESTclient;
import com.citrus.retrofit.RetroFitClient;
import com.citrus.sdk.Callback;
import com.citrus.sdk.CitrusClient;
import com.citrus.sdk.Environment;
import com.citrus.sdk.classes.AccessToken;
import com.citrus.sdk.response.CitrusError;
import com.citrus.sdk.response.CitrusResponse;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit.RetrofitError;
import retrofit.client.Response;

public class OauthToken {
    private static final String STORED_VALUES = "UserStorage";
    public static final String EMAIL_ID = "email_id";
    public static final String MOBILE_NO = "mobile_no";
    private static final String ENVIRONMENT = "environment";
    private static final String IS_TOKEN_REFRESHED = "IS_TOKEN_REFRESHED";
    private Context context;
    private Activity activity;
    private JSONObject jsontoken;
    private SharedPreferences tokenPrefs;
    private String base_url;
    private String token_type;
    private Callback callback;
    private CitrusClient citrusClient;

    public OauthToken(Activity activity, String token_type) {
        this.activity = activity;
        this.tokenPrefs = this.activity.getSharedPreferences(STORED_VALUES, 0);
        this.base_url = Config.getEnv();
        this.token_type = token_type;
    }

    public OauthToken(Context context, String token_type) {
        this.context = context;
        this.tokenPrefs = this.context.getSharedPreferences(STORED_VALUES, 0);
        this.base_url = Config.getEnv();
        this.token_type = token_type;
    }

    public OauthToken(Context context) {
        this.context = context;
        this.tokenPrefs = this.context.getSharedPreferences(STORED_VALUES, 0);
        this.base_url = Config.getEnv();
    }

    public synchronized boolean createToken(JSONObject usertoken) {
        this.jsontoken = new JSONObject();
        long expiry = new Date().getTime() / 1000L;
        try {
            this.jsontoken.put("expiry", expiry += usertoken.getLong("expires_in"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Iterator keys = usertoken.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                this.jsontoken.put(key, usertoken.get(key));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return this.storeToken();
    }

    private synchronized boolean storeToken() {
        SharedPreferences.Editor editor = this.tokenPrefs.edit();
        editor.putString(this.token_type, this.jsontoken.toString());
        return editor.commit();
    }

    public synchronized JSONObject getuserToken() {
        JSONObject token = null;
        try {
            if (!this.tokenPrefs.contains(this.token_type)) {
                return null;
            }
            token = new JSONObject(this.tokenPrefs.getString(this.token_type, null));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
        if (token.has("refresh_token")) {
            return this.refreshToken(token);
        }
        return token;
    }

    private synchronized JSONObject refreshToken(JSONObject token) {
        if (this.hasExpired(token)) {
            try {
                return this.refresh(token.getString("refresh_token"));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return token;
    }

    private synchronized boolean hasExpired(JSONObject token) {
        try {
            return token.getLong("expiry") <= new Date().getTime() / 1000L;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return true;
        }
    }

    private synchronized JSONObject refresh(String refreshToken) {
        JSONObject response = new JSONObject();
        JSONObject userJson = new JSONObject();
        try {
            this.citrusClient = CitrusClient.getInstance(this.context);
            userJson.put("client_id", (Object)this.citrusClient.getSigninId());
            userJson.put("client_secret", (Object)this.citrusClient.getSigninSecret());
            userJson.put("grant_type", (Object)"refresh_token");
            userJson.put("refresh_token", (Object)refreshToken);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JSONObject headers = new JSONObject();
        try {
            headers.put("Content-Type", (Object)"application/x-www-form-urlencoded");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        RESTclient restclient = new RESTclient("signin", this.base_url, userJson, headers);
        try {
            response = restclient.makePostrequest();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (response.has("access_token")) {
            this.jsontoken = response;
            this.storeToken();
            return response;
        }
        return null;
    }

    public synchronized void getSignUpToken(Callback<AccessToken> callback) {
        this.token_type = "signup_token";
        this.getAccessToken(false, callback);
    }

    public synchronized void getSignInToken(Callback<AccessToken> callback) {
        this.token_type = "signin_token";
        this.getAccessToken(false, callback);
    }

    public synchronized void getPrepaidToken(Callback<AccessToken> callback) {
        this.token_type = "prepaid_token";
        this.getAccessToken(false, callback);
    }

    public synchronized void getPrepaidToken(boolean isPrepaidPayRequest, Callback<AccessToken> callback) {
        this.token_type = "prepaid_token";
        this.getAccessToken(isPrepaidPayRequest, callback);
    }

    public synchronized void getPayUsingCitrusCashToken(Callback<AccessToken> callback) {
        this.token_type = "pay_using_citrus_cash_token";
        this.getAccessToken(false, callback);
    }

    private synchronized void getAccessToken(boolean isPrepaidPayRequest, Callback<AccessToken> callback) {
        JSONObject token = null;
        try {
            if (this.tokenPrefs.contains(this.token_type)) {
                token = new JSONObject(this.tokenPrefs.getString(this.token_type, null));
                if (token.has("refresh_token")) {
                    this.refreshToken(isPrepaidPayRequest, token, callback);
                } else {
                    Gson gson = new GsonBuilder().create();
                    AccessToken accessToken = (AccessToken)gson.fromJson(token.toString(), AccessToken.class);
                    callback.success(accessToken);
                }
            } else {
                String errorMessage = this.token_type.equalsIgnoreCase("signup_token") ? "Have you Signed Up? Token not found!!!" : "Have you Signed In? Token not found!!!";
                CitrusError error = new CitrusError(errorMessage, CitrusResponse.Status.FAILED);
                callback.error(error);
            }
        }
        catch (JSONException e) {
            CitrusError error = new CitrusError("Failed to get Access Token", CitrusResponse.Status.FAILED);
            callback.error(error);
        }
    }

    private synchronized void refreshToken(boolean isPrepaidPayRequest, JSONObject token, Callback callback) {
        if (this.hasExpired(token) || !token.has("Prepaid_Pay_Token") && isPrepaidPayRequest && this.token_type.equalsIgnoreCase("prepaid_token") && !this.tokenPrefs.getBoolean(IS_TOKEN_REFRESHED, false)) {
            try {
                this.getRefreshToken(token.getString("refresh_token"), callback);
            }
            catch (JSONException e) {
                CitrusError error = new CitrusError("Failed to get Access Token", CitrusResponse.Status.FAILED);
                callback.error(error);
            }
        } else {
            Gson gson = new GsonBuilder().create();
            AccessToken accessToken = (AccessToken)gson.fromJson(token.toString(), AccessToken.class);
            callback.success(accessToken);
        }
    }

    private synchronized void getRefreshToken(String refreshToken, final Callback callback) {
        this.citrusClient = CitrusClient.getInstance(this.context);
        RetroFitClient.getCitrusRetroFitClient().getRefreshTokenAsync(this.citrusClient.getSigninId(), this.citrusClient.getSigninSecret(), OAuth2GrantType.refresh_token.toString(), refreshToken, new retrofit.Callback<AccessToken>(){

            public void success(AccessToken accessToken, Response response) {
                if (accessToken.getAccessToken() != null) {
                    OauthToken.this.jsontoken = accessToken.getJSON();
                    OauthToken.this.storeToken();
                    if (OauthToken.this.token_type.equalsIgnoreCase("prepaid_token")) {
                        OauthToken.this.saveRefreshTokenStatus();
                    }
                    callback.success(accessToken);
                }
            }

            public void failure(RetrofitError error) {
                CitrusError citrusError = new CitrusError(error.getMessage(), CitrusResponse.Status.FAILED);
                callback.error(citrusError);
            }
        });
    }

    public synchronized boolean clearToken() {
        SharedPreferences.Editor editor = this.tokenPrefs.edit();
        editor.clear();
        return editor.commit();
    }

    public synchronized boolean saveUserDetails(String emailId, String mobileNo) {
        SharedPreferences.Editor editor = this.tokenPrefs.edit();
        editor.putString(EMAIL_ID, emailId);
        editor.putString(MOBILE_NO, mobileNo);
        return editor.commit();
    }

    public String getEmailId() {
        return this.tokenPrefs.getString(EMAIL_ID, null);
    }

    public String getMobileNumber() {
        return this.tokenPrefs.getString(MOBILE_NO, null);
    }

    public boolean saveEnvironment(Environment environment) {
        SharedPreferences.Editor editor = this.tokenPrefs.edit();
        editor.putString(ENVIRONMENT, environment.toString());
        return editor.commit();
    }

    public Environment getCurrentEnvironment() {
        String environment = this.tokenPrefs.getString(ENVIRONMENT, null);
        return environment == null ? Environment.NONE : Environment.valueOf(environment);
    }

    public boolean saveRefreshTokenStatus() {
        SharedPreferences.Editor editor = this.tokenPrefs.edit();
        editor.putBoolean(IS_TOKEN_REFRESHED, true);
        return editor.commit();
    }
}

