/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.card;

import com.citrus.card.TextUtils;

@Deprecated
public enum CardType {
    VISA("4"),
    MTRO("502260", "504433", "504434", "504435", "504437", "504645", "504681", "504753", "504775", "504809", "504817", "504834", "504848", "504884", "504973", "504993", "508125", "508126", "508159", "508192", "508227", "56", "600206", "603123", "603741", "603845", "622018", "67"),
    RUPAY("5085", "5086", "5087", "5088", "6069", "607", "6081", "6521", "6522", "6524"),
    MCRD("5"),
    DINERS("30", "36", "38", "39"),
    JCB("35"),
    AMEX("34", "37"),
    DISCOVER("60", "62", "64", "65"),
    UNKNOWN("0");

    private final String[] pattern;

    private CardType(String ... pattern) {
        this.pattern = pattern;
    }

    public static CardType typeOf(String card) {
        for (CardType type : CardType.values()) {
            if (!TextUtils.hasAnyPrefix(card, type.pattern)) continue;
            return type;
        }
        return null;
    }

    public static String getScheme(CardType cardType) {
        switch (cardType) {
            case VISA: {
                return "VISA";
            }
            case MCRD: {
                return "MCRD";
            }
            case MTRO: {
                return "MTRO";
            }
            case DINERS: {
                return "DINERS";
            }
            case JCB: {
                return "JCB";
            }
            case AMEX: {
                return "AMEX";
            }
            case DISCOVER: {
                return "DISCOVER";
            }
            case RUPAY: {
                return "RPAY";
            }
        }
        return "UNKNOWN";
    }
}

