package com.citrus.sdk.apis;

import android.support.annotation.NonNull;

import com.citrus.sdk.BankCID;
import com.citrus.sdk.Callback;
import com.citrus.sdk.classes.AccessToken;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.BinServiceResponse;
import com.citrus.sdk.classes.CardBinDetails;
import com.citrus.sdk.classes.PGHealthResponse;
import com.citrus.sdk.classes.StructResponsePOJO;
import com.citrus.sdk.dynamicPricing.DynamicPricingRequestType;
import com.citrus.sdk.dynamicPricing.DynamicPricingResponse;
import com.citrus.sdk.otp.NetBankForOTP;
import com.citrus.sdk.payment.CardOption;
import com.citrus.sdk.payment.MerchantPaymentOption;
import com.citrus.sdk.payment.PaymentBill;
import com.citrus.sdk.payment.PaymentOption;
import com.citrus.sdk.response.CitrusResponse;

import java.util.List;

import api.PGAPI;

/**
 * Created by salil on 30/11/15.
 */
public interface PGClientAPI {

    void makeMOTOPayment(String paymentJSON, Callback<StructResponsePOJO> callback);

    void newMakePayment(String paymentJSON, Callback<String> callback);

    /**
     * Get the merchant available payment options. You need to show the user available payment option in your app.
     *
     * @param callback
     */
    void getMerchantPaymentOptions(final Callback<MerchantPaymentOption> callback);

    /**
     * Get the payment options available for load money. You need to show the user available payment option in your app.
     *
     * @param callback
     */
    void getLoadMoneyPaymentOptions(final Callback<MerchantPaymentOption> callback);

    /**
     * Get user's saved cards.
     *
     * @param accessToken
     * @param callback
     */
    void getWallet(final AccessToken accessToken, final Callback<List<PaymentOption>> callback);

    /**
     * Get the user saved payment options. If you want any specific bank at 0th position pass BankCID
     *
     * @param accessToken
     * @param callback    - callback
     */
    void getWalletWithDefaultBank(final AccessToken accessToken, final Callback<List<PaymentOption>> callback, final BankCID bankCID);

    /**
     * Save the paymentOption.
     *
     * @param paymentOption - PaymentOption to be saved.
     * @param callback
     */

    void savePaymentOption(final AccessToken accessToken, final PaymentOption paymentOption, final Callback<CitrusResponse> callback);

    /**
     * Deletes the saved Payment Option
     *
     * @param paymentOption
     * @param callback
     */
    void deletePaymentOption(final AccessToken accessToken, final PaymentOption paymentOption, final Callback<CitrusResponse> callback);

    void setDefaultPaymentOption(final AccessToken accessToken, final PaymentOption defaultPaymentOption, final Callback<CitrusResponse> callback);

    /**
     * Get BIN Details using the Card Number.
     *
     * @param cardOption
     * @param callback
     */
    void getBINDetails(CardOption cardOption, final Callback<BinServiceResponse> callback);

    /**
     * This api will be used in Cube. Use {@link PGClientAPI#getBINDetails(CardOption, Callback)} instead.
     *
     * @param first6Digits
     * @param cardDetailsCallback
     */
    void getCardType(final String first6Digits, final Callback<CardBinDetails> cardDetailsCallback);

    /**
     * Fetch the PG Health for all banks so that it will be used in future.
     */
    void fetchPGHealthForAllBanks();

    /**
     * It returns {@link com.citrus.sdk.classes.PGHealth} which denotes the health of the PG for in
     * If the health is bad merchants can warn user to use another payment method.
     *
     * @param paymentOption
     * @param callback
     */
    void getPGHealth(PaymentOption paymentOption, final Callback<PGHealthResponse> callback);

    /**
     * Get the payment bill for the transaction.
     *
     * @param billUrl  - Bill Generator URL
     * @param amount   - Transaction amount
     * @param callback
     */
    void getBill(String billUrl, Amount amount, final Callback<PaymentBill> callback);

    /**
     * Perform Dynamic Pricing. You can specify one the dynamicPricingRequestType to perform Dynamic Pricing.
     *
     * @param dynamicPricingRequestType - One of the dynamicPricingRequestType from {@link DynamicPricingRequestType}
     * @param billUrl                   - billUrl from where we will fetch the bill.
     * @param callback                  - callback
     */
    void performDynamicPricing(@NonNull final DynamicPricingRequestType dynamicPricingRequestType, @NonNull final String billUrl, @NonNull final Callback<DynamicPricingResponse> callback);

    /**
     * Perform Dynamic Pricing. You can specify one the dynamicPricingRequestType to perform Dynamic Pricing.
     *
     * @param dynamicPricingRequestType - One of the dynamicPricingRequestType from {@link DynamicPricingRequestType}
     * @param paymentBill               - PaymentBill in case you are fetching bill response from your server.
     * @param callback                  - callback
     */
    void performDynamicPricing(@NonNull final DynamicPricingRequestType dynamicPricingRequestType, @NonNull final PaymentBill paymentBill, @NonNull final Callback<DynamicPricingResponse> callback);

    void getMerchantName(Callback<String> callback);

    /**
     * Initialize the client initialized with given url.
     *
     * @param baseUrl
     * @return
     */
    PGAPI getClientWithUrl(String baseUrl);

    NetBankForOTP getNetBankForOTP();
}
