/*
   Copyright 2014 Citrus Payment Solutions Pvt. Ltd.
   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at
     http://www.apache.org/licenses/LICENSE-2.0
   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

package com.citrus.sdk.payment;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;

/**
 * Created by salil on 4/3/15.
 */
public final class CitrusCash extends PaymentOption {

    private String amount = null;

    private CitrusCash() {
    }

    public CitrusCash(String name, String token) {
        super(name, token);
    }

    public CitrusCash(String amount) {
        this.amount = amount;
        this.name = "Citrus Cash : \u20B9 " + amount;
    }

    @Override
    public Drawable getOptionIcon(Context context) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            return context.getResources().getDrawable(context.getResources().getIdentifier("citrus_cash", "drawable", context.getPackageName()), null);
        } else {
            Drawable drawable;
            int resourceId = context.getResources().getIdentifier("citrus_cash", "drawable", context.getPackageName());
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                drawable = context.getResources().getDrawable(resourceId, null);
            } else {
                drawable = context.getResources().getDrawable(resourceId);
            }

            return drawable;
        }
    }

    public String getAmount() {
        return amount;
    }

    @Override
    public String getSavePaymentOptionObject() {
        return null;
    }

    @Override
    public com.citrus.analytics.PaymentType getAnalyticsPaymentType() {
        return com.citrus.analytics.PaymentType.CITRUS_CASH;
    }

    @Override
    public String getDynamicPricingPaymentMode() {
        return "PREPAID_CARD";
    }

    @Override
    public String getSaveDefaultPaymentOptionObject() {
        return null;
    }


    @Override
    public String toString() {
        return super.toString() + "CitrusCash{" +
                "amount='" + amount + '\'' +
                '}';
    }

    public void setName(String name) {
        super.name = name;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.amount);
    }

    protected CitrusCash(Parcel in) {
        super(in);
        this.amount = in.readString();
    }

    public static final Creator<CitrusCash> CREATOR = new Creator<CitrusCash>() {
        public CitrusCash createFromParcel(Parcel source) {
            return new CitrusCash(source);
        }

        public CitrusCash[] newArray(int size) {
            return new CitrusCash[size];
        }
    };
}
