/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.wallet;

import android.app.Activity;
import android.text.TextUtils;
import com.citrus.card.Card;
import com.citrus.card.CardType;
import com.citrus.mobile.Config;
import com.citrus.mobile.OauthToken;
import com.citrus.mobile.RESTclient;
import com.citrus.netbank.Bank;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
public class Wallet {
    private Card card;
    private Bank bank;
    private String base_url;

    public Wallet(Card card) {
        this.card = card;
        this.base_url = Config.getEnv();
    }

    public Wallet(Bank bank) {
        this.bank = bank;
        this.base_url = Config.getEnv();
    }

    public Wallet() {
        this.base_url = Config.getEnv();
    }

    public String saveBank(Activity activity) {
        OauthToken token = new OauthToken(activity, "signin_token");
        String access_token = null;
        try {
            access_token = token.getuserToken().getString("access_token");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JSONObject bankJson = new JSONObject();
        JSONObject bankDetails = new JSONObject();
        try {
            bankJson.put("type", (Object)"payment");
            bankJson.put("defaultOption", (Object)"");
            bankDetails.put("owner", (Object)"");
            bankDetails.put("type", (Object)"netbanking");
            bankDetails.put("bank", (Object)this.bank.getBankName());
            JSONArray array = new JSONArray();
            array.put((Object)bankDetails);
            bankJson.put("paymentOptions", (Object)array);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JSONObject headers = new JSONObject();
        try {
            headers.put("Content-Type", (Object)"application/json");
            headers.put("Authorization", (Object)("Bearer " + access_token));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        RESTclient resTclient = new RESTclient("wallet", this.base_url, null, headers);
        JSONObject response = resTclient.makePutrequest(bankJson);
        if (response == null) {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("response", (Object)"bank saved successfully!");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return jsonObject.toString();
        }
        return response.toString();
    }

    public String saveCard(Activity activity) {
        OauthToken token = new OauthToken(activity, "signin_token");
        String access_token = null;
        try {
            access_token = token.getuserToken().getString("access_token");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JSONObject cardJson = new JSONObject();
        JSONObject cardDetails = new JSONObject();
        try {
            cardJson.put("type", (Object)"payment");
            cardDetails.put("owner", (Object)this.card.getCardHolderName());
            cardDetails.put("number", (Object)this.card.getCardNumber());
            cardDetails.put("scheme", (Object)CardType.getScheme(this.card.getCardType()));
            cardDetails.put("type", (Object)this.card.getCrdr().toLowerCase());
            if (this.card.getCardType() != null && "MTRO".equalsIgnoreCase(this.card.getCardType().toString()) && TextUtils.isEmpty((CharSequence)this.card.getCvvNumber())) {
                cardDetails.put("expiryDate", (Object)"11/19");
            } else {
                cardDetails.put("expiryDate", (Object)(this.card.getExpiryMonth() + "/" + this.card.getExpiryYear().substring(this.card.getExpiryYear().length() - 2)));
            }
            JSONArray array = new JSONArray();
            array.put((Object)cardDetails);
            cardJson.put("paymentOptions", (Object)array);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JSONObject headers = new JSONObject();
        try {
            headers.put("Content-Type", (Object)"application/json");
            headers.put("Authorization", (Object)("Bearer " + access_token));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        RESTclient resTclient = new RESTclient("wallet", this.base_url, null, headers);
        JSONObject response = resTclient.makePutrequest(cardJson);
        if (response == null) {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("response", (Object)"card saved successfully!");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return jsonObject.toString();
        }
        return response.toString();
    }

    public String getWallet(Activity activity) {
        JSONObject response;
        OauthToken token = new OauthToken(activity, "signin_token");
        String access_token = null;
        try {
            access_token = token.getuserToken().getString("access_token");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JSONObject headers = new JSONObject();
        try {
            headers.put("Authorization", (Object)("Bearer " + access_token));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        RESTclient resTclient = new RESTclient("wallet", this.base_url, null, headers);
        try {
            response = resTclient.makegetRequest();
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "Unable to get User Wallet";
        }
        return response.toString();
    }
}

