/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.mobile;

import android.text.TextUtils;
import android.util.Log;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.classes.Amount;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.net.ssl.HttpsURLConnection;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
public class RESTclient {
    private JSONObject urls;
    private JSONObject params;
    private JSONObject headers;
    private String type;
    private String base_url;
    private HttpClient httpClient;
    private HttpResponse response;

    public RESTclient(String type, String base_url, JSONObject params, JSONObject headers) {
        this.params = params;
        this.headers = headers;
        this.type = type;
        this.urls = new JSONObject();
        try {
            this.urls.put("production", (Object)"https://admin.citruspay.com/");
            this.urls.put("oops", (Object)"https://oops.citruspay.com/");
            this.urls.put("sandbox", (Object)"https://sandboxadmin.citruspay.com/");
            this.urls.put("signup", (Object)"oauth/token");
            this.urls.put("bind", (Object)"service/v2/identity/bind");
            this.urls.put("signin", (Object)"oauth/token");
            this.urls.put("wallet", (Object)"service/v2/profile/me/payment");
            this.urls.put("struct", (Object)"service/moto/authorize/struct/payment");
            this.urls.put("prepaid", (Object)"prepaid/pg/_verify");
            this.urls.put("balance", (Object)"service/v2/mycard");
            this.urls.put("newbalance", (Object)"service/v2/mycard/balance");
            this.urls.put("password", (Object)"service/v2/identity/me/password");
            this.urls.put("specialbalance", (Object)"service/v2/prepayment/balance");
            this.urls.put("resetpassword", (Object)"service/v2/identity/passwords/reset");
            this.urls.put("prepaidbill", (Object)"service/v2/prepayment/load");
            this.urls.put("paymentoptions", (Object)"service/v1/merchant/pgsetting");
            this.urls.put("cashout", (Object)"service/v2/prepayment/cashout");
            this.urls.put("transfer", (Object)"service/v2/prepayment/transfer");
            this.urls.put("suspensetransfer", (Object)"service/v2/prepayment/transfer/extended");
        }
        catch (JSONException e) {
            return;
        }
        this.base_url = base_url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject makeWithdrawRequest(String accessToken, double amount, String currency, String owner, String accountNumber, String ifscCode) {
        FilterOutputStream wr = null;
        JSONObject txnDetails = null;
        BufferedReader in = null;
        try {
            String inputLine;
            String url = this.urls.getString(this.base_url) + this.urls.getString(this.type);
            HttpsURLConnection conn = (HttpsURLConnection)new URL(url).openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Authorization", "Bearer " + accessToken);
            StringBuffer buff = new StringBuffer("amount=");
            buff.append(amount);
            buff.append("&currency=");
            buff.append(currency);
            buff.append("&owner=");
            buff.append(owner);
            buff.append("&account=");
            buff.append(accountNumber);
            buff.append("&ifsc=");
            buff.append(ifscCode);
            conn.setDoOutput(true);
            wr = new DataOutputStream(conn.getOutputStream());
            ((DataOutputStream)wr).writeBytes(buff.toString());
            ((DataOutputStream)wr).flush();
            int responseCode = conn.getResponseCode();
            System.out.println("\nSending 'POST' request to URL : " + url);
            System.out.println("Post parameters : " + buff.toString());
            System.out.println("Response Code : " + responseCode);
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            txnDetails = new JSONObject(response.toString());
        }
        catch (JSONException exception) {
            exception.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                if (wr != null) {
                    wr.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return txnDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject makeSendMoneyRequest(String accessToken, CitrusUser toUser, Amount amount, String message) {
        FilterOutputStream wr = null;
        JSONObject txnDetails = null;
        BufferedReader in = null;
        try {
            String inputLine;
            String url = null;
            StringBuffer postDataBuff = new StringBuffer("amount=");
            postDataBuff.append(amount.getValue());
            postDataBuff.append("&currency=");
            postDataBuff.append(amount.getCurrency());
            postDataBuff.append("&message=");
            postDataBuff.append(message);
            if (!TextUtils.isEmpty((CharSequence)toUser.getEmailId())) {
                url = this.urls.getString(this.base_url) + this.urls.getString("transfer");
                postDataBuff.append("&to=");
                postDataBuff.append(toUser.getEmailId());
            } else if (!TextUtils.isEmpty((CharSequence)toUser.getMobileNo())) {
                url = this.urls.getString(this.base_url) + this.urls.getString("suspensetransfer");
                postDataBuff.append("&to=");
                postDataBuff.append(toUser.getMobileNo());
            }
            HttpsURLConnection conn = (HttpsURLConnection)new URL(url).openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Authorization", "Bearer " + accessToken);
            conn.setDoOutput(true);
            wr = new DataOutputStream(conn.getOutputStream());
            ((DataOutputStream)wr).writeBytes(postDataBuff.toString());
            ((DataOutputStream)wr).flush();
            int responseCode = conn.getResponseCode();
            System.out.println("\nSending 'POST' request to URL : " + url);
            System.out.println("Post parameters : " + postDataBuff.toString());
            System.out.println("Response Code : " + responseCode);
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            txnDetails = new JSONObject(response.toString());
        }
        catch (JSONException exception) {
            exception.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                if (wr != null) {
                    wr.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return txnDetails;
    }

    public JSONObject makePostrequest() throws IOException {
        BasicHttpParams redirectparams = new BasicHttpParams();
        redirectparams.setParameter("http.protocol.handle-redirects", (Object)false);
        this.httpClient = new DefaultHttpClient();
        HttpPost httpPost = null;
        try {
            httpPost = new HttpPost(this.urls.getString(this.base_url) + this.urls.getString(this.type));
            httpPost.setParams((HttpParams)redirectparams);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (this.params != null) {
            ArrayList<BasicNameValuePair> postData = new ArrayList<BasicNameValuePair>(2);
            Iterator iter = this.params.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                try {
                    String value = this.params.getString(key);
                    postData.add(new BasicNameValuePair(key, value));
                }
                catch (JSONException e) {
                    Log.d((String)"exception", (String)e.toString());
                }
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(postData));
        }
        Iterator iterhead = this.headers.keys();
        while (iterhead.hasNext()) {
            String key = (String)iterhead.next();
            try {
                String value = this.headers.getString(key);
                httpPost.addHeader(key, value);
            }
            catch (JSONException e) {
                return null;
            }
        }
        try {
            this.response = this.httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.parseResponse(this.response);
    }

    public JSONObject makePutrequest() {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPut put = null;
        try {
            put = new HttpPut(this.urls.getString(this.base_url) + this.urls.getString(this.type));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Iterator iterhead = this.headers.keys();
        while (iterhead.hasNext()) {
            String key = (String)iterhead.next();
            try {
                String value = this.headers.getString(key);
                put.addHeader(key, value);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        ArrayList<BasicNameValuePair> putdata = new ArrayList<BasicNameValuePair>(2);
        Iterator iter = this.params.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            try {
                String value = this.params.getString(key);
                putdata.add(new BasicNameValuePair(key, value));
            }
            catch (JSONException e) {
                Log.d((String)"exception", (String)e.toString());
            }
        }
        try {
            put.setEntity((HttpEntity)new UrlEncodedFormEntity(putdata));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try {
            this.response = client.execute((HttpUriRequest)put);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.parseResponse(this.response);
    }

    public JSONObject makePutrequest(JSONObject details) {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPut put = null;
        try {
            put = new HttpPut(this.urls.getString(this.base_url) + this.urls.getString(this.type));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Iterator iterhead = this.headers.keys();
        while (iterhead.hasNext()) {
            String key = (String)iterhead.next();
            try {
                String value = this.headers.getString(key);
                put.addHeader(key, value);
            }
            catch (JSONException e) {
                Log.d((String)"exception", (String)e.toString());
            }
        }
        try {
            put.setEntity((HttpEntity)new StringEntity(details.toString()));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try {
            this.response = client.execute((HttpUriRequest)put);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.parseResponse(this.response);
    }

    public JSONObject makegetRequest() throws JSONException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpGet httpGet = null;
        try {
            httpGet = new HttpGet(this.urls.getString(this.base_url) + this.urls.getString(this.type));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Iterator iterhead = this.headers.keys();
        while (iterhead.hasNext()) {
            String key = (String)iterhead.next();
            try {
                String value = this.headers.getString(key);
                httpGet.addHeader(key, value);
            }
            catch (JSONException e) {
                return new JSONObject().put("error", (Object)"unable to find headers");
            }
        }
        try {
            this.response = httpClient.execute(httpGet);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.parseResponse(this.response);
    }

    public JSONObject postPayment(JSONObject payment) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpPost httpPost = null;
        try {
            httpPost = new HttpPost(this.urls.getString(this.base_url) + this.urls.getString(this.type));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
        httpPost.setHeader("Content-Type", "application/json");
        try {
            httpPost.setEntity((HttpEntity)new StringEntity(payment.toString()));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        try {
            this.response = httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return this.parseResponse(this.response);
    }

    private JSONObject parseResponse(HttpResponse response) {
        try {
            if (response == null) {
                return this.formError(600, "Null response - is your internet connection functional?");
            }
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    return new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
                }
                case 204: {
                    return null;
                }
                case 400: {
                    return this.formError(400, "badrequest");
                }
                case 401: {
                    return this.formError(401, "unauthorized");
                }
                case 403: {
                    return this.formError(403, "access forbidden");
                }
                case 503: {
                    return this.formError(503, "unavailable");
                }
                case 504: {
                    return this.formError(504, "gatewaytimeout");
                }
                case 302: {
                    return this.getCookies(response);
                }
            }
            return this.formError(response.getStatusLine().getStatusCode(), "unknownerror");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return this.formError(600, "jsonexception");
        }
        catch (IOException e) {
            e.printStackTrace();
            return this.formError(600, "ioexception");
        }
    }

    private JSONObject getCookies(HttpResponse response) {
        Header[] headers = response.getAllHeaders();
        JSONObject cookies = new JSONObject();
        for (int i = 0; i < headers.length; ++i) {
            Header h = headers[i];
            try {
                cookies.put(h.getName(), (Object)h.getValue());
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
                return null;
            }
        }
        return cookies;
    }

    private JSONObject formError(int status, String message) {
        JSONObject error = new JSONObject();
        try {
            error.put("error", (Object)String.valueOf(status));
            error.put("message", (Object)message);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return error;
    }
}

