/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.ActionBarActivity;
import android.text.Html;
import android.text.TextUtils;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.view.View;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.webkit.CookieManager;
import android.webkit.JavascriptInterface;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.EditText;
import com.citrus.analytics.EventsManager;
import com.citrus.analytics.WebViewEvents;
import com.citrus.cash.LoadMoney;
import com.citrus.cash.PersistentConfig;
import com.citrus.cash.Prepaid;
import com.citrus.library.R;
import com.citrus.mobile.Config;
import com.citrus.payment.Bill;
import com.citrus.payment.PG;
import com.citrus.payment.UserDetails;
import com.citrus.sdk.Callback;
import com.citrus.sdk.CitrusClient;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.PaymentParams;
import com.citrus.sdk.TransactionResponse;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.CitrusConfig;
import com.citrus.sdk.classes.Utils;
import com.citrus.sdk.payment.CardOption;
import com.citrus.sdk.payment.PaymentBill;
import com.citrus.sdk.payment.PaymentOption;
import com.citrus.sdk.payment.PaymentType;
import com.citrus.sdk.response.CitrusError;
import com.citrus.sdk.response.CitrusResponse;
import com.orhanobut.logger.Logger;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class CitrusActivity
extends ActionBarActivity {
    private WebView mPaymentWebview = null;
    private Context mContext = this;
    private ProgressDialog mProgressDialog = null;
    @Deprecated
    private PaymentParams mPaymentParams = null;
    private PaymentType mPaymentType = null;
    private PaymentOption mPaymentOption = null;
    private String mTransactionId = null;
    private ActionBar mActionBar = null;
    private String mColorPrimary = null;
    private String mColorPrimaryDark = null;
    private String mTextColorPrimary = null;
    private CitrusConfig mCitrusConfig = null;
    private CitrusUser mCitrusUser = null;
    private String sessionCookie;
    private CookieManager cookieManager;
    private String mpiServletUrl = null;
    private Map<String, String> customParametersOriginalMap = null;
    private CitrusClient mCitrusClient = null;
    private String mActivityTitle = null;
    private int mRequestCode = -1;
    private boolean isBackKeyPressedByUser = false;
    private boolean passwordPromptShown = false;

    protected void onCreate(Bundle savedInstanceState) {
        this.mPaymentType = (PaymentType)this.getIntent().getParcelableExtra("INTENT_EXTRA_PAYMENT_TYPE");
        this.mRequestCode = this.getIntent().getIntExtra("INTENT_EXTRA_REQUEST_CODE_PAYMENT", -1);
        if (!(this.mPaymentType instanceof PaymentType.CitrusCash)) {
            this.setTheme(R.style.Base_Theme_AppCompat_Light_DarkActionBar);
        }
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_citrus);
        this.mPaymentParams = (PaymentParams)this.getIntent().getParcelableExtra("INTENT_EXTRA_PAYMENT_PARAMS");
        this.mCitrusConfig = CitrusConfig.getInstance();
        this.mActivityTitle = this.mCitrusConfig.getCitrusActivityTitle();
        this.mCitrusClient = CitrusClient.getInstance(this.mContext);
        if (this.mPaymentParams != null) {
            this.mPaymentType = this.mPaymentParams.getPaymentType();
            this.mPaymentOption = this.mPaymentParams.getPaymentOption();
            this.mCitrusUser = this.mPaymentParams.getUser();
            this.mColorPrimary = this.mPaymentParams.getColorPrimary();
            this.mColorPrimaryDark = this.mPaymentParams.getColorPrimaryDark();
            this.mTextColorPrimary = this.mPaymentParams.getTextColorPrimary();
        } else if (this.mPaymentType != null) {
            this.mPaymentOption = this.mPaymentType.getPaymentOption();
            this.mCitrusUser = this.mPaymentType.getCitrusUser();
            this.mColorPrimary = this.mCitrusConfig.getColorPrimary();
            this.mColorPrimaryDark = this.mCitrusConfig.getColorPrimaryDark();
            this.mTextColorPrimary = this.mCitrusConfig.getTextColorPrimary();
        } else {
            throw new IllegalArgumentException("Payment Type Should not be null");
        }
        String emailId = this.mCitrusClient.getUserEmailId();
        String mobileNo = this.mCitrusClient.getUserMobileNumber();
        if (this.mPaymentType instanceof PaymentType.LoadMoney || this.mPaymentType instanceof PaymentType.CitrusCash) {
            if (this.mCitrusClient.getCitrusUser() != null) {
                this.mCitrusUser = this.mCitrusClient.getCitrusUser();
            } else if (this.mCitrusUser == null) {
                this.mCitrusUser = new CitrusUser(emailId, mobileNo);
            }
        } else if (this.mCitrusUser == null) {
            this.mCitrusUser = new CitrusUser(emailId, mobileNo);
        }
        this.mActionBar = this.getSupportActionBar();
        this.mProgressDialog = new ProgressDialog(this.mContext);
        this.mPaymentWebview = (WebView)this.findViewById(R.id.payment_webview);
        this.mPaymentWebview.getSettings().setUseWideViewPort(true);
        this.mPaymentWebview.getSettings().setJavaScriptEnabled(true);
        if (Build.VERSION.SDK_INT >= 21) {
            this.mPaymentWebview.getSettings().setMixedContentMode(0);
        }
        this.mPaymentWebview.addJavascriptInterface((Object)new JsInterface(), "CitrusResponse");
        this.mPaymentWebview.setWebChromeClient(new WebChromeClient());
        this.mPaymentWebview.setWebViewClient((WebViewClient)new CitrusWebClient());
        if (this.mPaymentType instanceof PaymentType.CitrusCash) {
            this.mPaymentWebview.setVisibility(8);
        }
        if (TextUtils.isEmpty((CharSequence)this.mActivityTitle)) {
            this.mActivityTitle = "Processing...";
        }
        this.setTitle((CharSequence)Html.fromHtml((String)("<font color=\"" + this.mTextColorPrimary + "\">" + this.mActivityTitle + "</font>")));
        this.setActionBarBackground();
        if (this.mRequestCode == 10000 && this.mPaymentOption instanceof CardOption && !((CardOption)this.mPaymentOption).validateCard()) {
            this.sendResult(new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, ((CardOption)this.mPaymentOption).getCardValidityFailureReasons(), null));
            return;
        }
        if (this.mPaymentType instanceof PaymentType.PGPayment || this.mPaymentType instanceof PaymentType.CitrusCash) {
            if (this.mPaymentType.getPaymentBill() != null) {
                if (PaymentBill.toJSONObject(this.mPaymentType.getPaymentBill()) != null) {
                    this.proceedToPayment(PaymentBill.toJSONObject(this.mPaymentType.getPaymentBill()).toString());
                }
            } else {
                this.fetchBill();
            }
        } else {
            Amount amount = this.mPaymentType.getAmount();
            LoadMoney loadMoney = new LoadMoney(amount.getValue(), this.mPaymentType.getUrl());
            PG paymentgateway = new PG(this.mPaymentOption, loadMoney, new UserDetails(CitrusUser.toJSONObject(this.mCitrusUser)));
            paymentgateway.load((Activity)this, new com.citrus.mobile.Callback(){

                @Override
                public void onTaskexecuted(String success, String error) {
                    CitrusActivity.this.processresponse(success, error);
                }
            });
        }
    }

    @TargetApi(value=21)
    private void setActionBarBackground() {
        if (this.mColorPrimary != null && this.mActionBar != null) {
            this.mActionBar.setBackgroundDrawable((Drawable)new ColorDrawable(Color.parseColor((String)this.mColorPrimary)));
        }
        if (Build.VERSION.SDK_INT >= 21 && this.mColorPrimaryDark != null) {
            Window window = this.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(Color.parseColor((String)this.mColorPrimaryDark));
        }
    }

    private void fetchBill() {
        this.showDialog("Validating Payment Details. Please wait...", false);
        String billUrl = this.mPaymentType.getUrl();
        billUrl = billUrl.contains("?") ? billUrl + "&amount=" + this.mPaymentType.getAmount().getValue() : billUrl + "?amount=" + this.mPaymentType.getAmount().getValue();
        this.mCitrusClient.getBill(billUrl, this.mPaymentType.getAmount(), new Callback<PaymentBill>(){

            @Override
            public void success(PaymentBill paymentBill) {
                CitrusActivity.this.customParametersOriginalMap = paymentBill.getCustomParametersMap();
                JSONObject billJson = PaymentBill.toJSONObject(paymentBill);
                if (billJson != null) {
                    CitrusActivity.this.proceedToPayment(billJson.toString());
                } else {
                    TransactionResponse transactionResponse = new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, "Invalid bill received from server.", CitrusActivity.this.mTransactionId);
                    CitrusActivity.this.sendResult(transactionResponse);
                }
            }

            @Override
            public void error(CitrusError error) {
                TransactionResponse transactionResponse = new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, error.getMessage(), CitrusActivity.this.mTransactionId);
                CitrusActivity.this.sendResult(transactionResponse);
            }
        });
    }

    private void proceedToPayment(String billJSON) {
        if (this.mPaymentType instanceof PaymentType.CitrusCash) {
            UserDetails userDetails = new UserDetails(CitrusUser.toJSONObject(this.mCitrusUser));
            Prepaid prepaid = new Prepaid(userDetails.getEmail());
            Bill bill = new Bill(billJSON);
            this.mTransactionId = bill.getTxnId();
            PG paymentgateway = new PG(prepaid, bill, userDetails);
            if (bill.getCustomParameters() != null) {
                paymentgateway.setCustomParameters(bill.getCustomParameters());
            }
            paymentgateway.charge(new com.citrus.mobile.Callback(){

                @Override
                public void onTaskexecuted(String success, String error) {
                    CitrusActivity.this.prepaidPayment(success, error);
                }
            });
        } else {
            this.showDialog("Redirecting to Citrus. Please wait...", false);
            UserDetails userDetails = new UserDetails(CitrusUser.toJSONObject(this.mCitrusUser));
            Bill bill = new Bill(billJSON);
            this.mTransactionId = bill.getTxnId();
            PG paymentgateway = new PG(this.mPaymentOption, bill, userDetails);
            paymentgateway.charge(new com.citrus.mobile.Callback(){

                @Override
                public void onTaskexecuted(String success, String error) {
                    CitrusActivity.this.processresponse(success, error);
                    CitrusActivity.this.dismissDialog();
                }
            });
        }
    }

    private void processresponse(String response, String error) {
        block6: {
            TransactionResponse transactionResponse = null;
            if (!TextUtils.isEmpty((CharSequence)response)) {
                try {
                    JSONObject redirect = new JSONObject(response);
                    this.mpiServletUrl = redirect.optString("redirectUrl");
                    if (!TextUtils.isEmpty((CharSequence)this.mpiServletUrl)) {
                        this.mPaymentWebview.loadUrl(this.mpiServletUrl);
                        if (this.mPaymentOption != null) {
                            EventsManager.logWebViewEvents((Context)this, WebViewEvents.OPEN, this.mPaymentOption.getAnalyticsPaymentType());
                        }
                        break block6;
                    }
                    transactionResponse = new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, response, this.mTransactionId);
                    this.sendResult(transactionResponse);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } else {
                transactionResponse = new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, error, this.mTransactionId);
                this.sendResult(transactionResponse);
            }
        }
    }

    private void prepaidPayment(String response, String error) {
        block6: {
            TransactionResponse transactionResponse = null;
            if (!TextUtils.isEmpty((CharSequence)response)) {
                try {
                    JSONObject redirect = new JSONObject(response);
                    if (!TextUtils.isEmpty((CharSequence)redirect.getString("redirectUrl"))) {
                        this.setCookie();
                        this.mPaymentWebview.loadUrl(redirect.getString("redirectUrl"));
                        if (this.mPaymentOption != null) {
                            EventsManager.logWebViewEvents((Context)this, WebViewEvents.OPEN, this.mPaymentOption.getAnalyticsPaymentType());
                        }
                        break block6;
                    }
                    transactionResponse = new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, response, this.mTransactionId);
                    this.sendResult(transactionResponse);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } else {
                transactionResponse = new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, error, this.mTransactionId);
                this.sendResult(transactionResponse);
            }
        }
    }

    private void showDialog(String message, boolean cancelable) {
        if (this.mProgressDialog != null) {
            this.mProgressDialog.setCanceledOnTouchOutside(false);
            this.mProgressDialog.setCancelable(cancelable);
            this.mProgressDialog.setMessage((CharSequence)message);
            this.mProgressDialog.show();
        }
    }

    private void dismissDialog() {
        if (this.mProgressDialog != null) {
            this.mProgressDialog.dismiss();
        }
    }

    public void onBackPressed() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                dialog.dismiss();
                CitrusActivity.this.isBackKeyPressedByUser = true;
                if (CitrusActivity.this.mPaymentType instanceof PaymentType.CitrusCash || !Utils.isNetworkConnected(CitrusActivity.this.mContext)) {
                    TransactionResponse transactionResponse = new TransactionResponse(TransactionResponse.TransactionStatus.CANCELLED, "Cancelled By User", CitrusActivity.this.mTransactionId);
                    CitrusActivity.this.sendResult(transactionResponse);
                } else {
                    CitrusActivity.this.mPaymentWebview.loadUrl(CitrusActivity.this.mpiServletUrl);
                }
            }
        });
        builder.setNegativeButton((CharSequence)"No", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
            }
        });
        builder.setMessage((CharSequence)"Do you want to cancel the transaction?").setTitle((CharSequence)"Cancel Transaction?");
        AlertDialog dialog = builder.create();
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
    }

    private void setCookie() {
        this.cookieManager = CookieManager.getInstance();
        this.sessionCookie = new PersistentConfig((Context)this).getCookieString();
        this.cookieManager.setCookie(Config.getBaseURL(), this.sessionCookie);
    }

    private static void removeCookies() {
        String setCookie = CookieManager.getInstance().getCookie(Config.getBaseURL());
        CookieManager.getInstance().setCookie(Config.getBaseURL(), "prepaiduser-payauth=''");
    }

    private void sendResult(TransactionResponse transactionResponse) {
        if (this.mPaymentOption != null) {
            if (this.isBackKeyPressedByUser) {
                EventsManager.logWebViewEvents((Context)this, WebViewEvents.BACK_KEY, this.mPaymentOption.getAnalyticsPaymentType());
            } else {
                EventsManager.logWebViewEvents((Context)this, WebViewEvents.CLOSE, this.mPaymentOption.getAnalyticsPaymentType());
            }
            if (transactionResponse.getTransactionStatus() == TransactionResponse.TransactionStatus.FAILED) {
                EventsManager.logPaymentEvents((Context)this, this.mPaymentOption.getAnalyticsPaymentType(), transactionResponse.getMessage());
            } else {
                EventsManager.logPaymentEvents((Context)this, this.mPaymentOption.getAnalyticsPaymentType(), transactionResponse.getAnalyticsTransactionType());
            }
        }
        Intent intent = new Intent();
        intent.putExtra("INTENT_EXTRA_TRANSACTION_RESPONSE", (Parcelable)transactionResponse);
        intent.setAction(this.mPaymentType.getIntentAction());
        if (this.mRequestCode != 10000) {
            LocalBroadcastManager.getInstance((Context)this.mContext).sendBroadcast(intent);
        }
        this.setResult(-1, intent);
        this.finish();
    }

    protected void onStop() {
        super.onStop();
        this.dismissDialog();
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mPaymentWebview != null) {
            this.mPaymentWebview.stopLoading();
            this.mPaymentWebview.destroy();
        }
        this.mPaymentWebview = null;
        this.mPaymentType = null;
        this.mPaymentParams = null;
        this.mCitrusConfig = null;
        this.mCitrusUser = null;
        this.mTransactionId = null;
        this.dismissDialog();
        this.mProgressDialog = null;
        this.mPaymentOption = null;
        this.mActivityTitle = null;
    }

    private void showPrompt() {
        AlertDialog.Builder alert = new AlertDialog.Builder(this.mContext);
        String message = null;
        String title = null;
        if (this.passwordPromptShown) {
            message = "Incorrect Password.";
            title = "Please Enter Password Again.";
        } else {
            message = "Please Enter Your Password For Citrus Account.";
            title = "Enter Password";
        }
        String positiveButtonText = "Pay";
        alert.setTitle((CharSequence)title);
        alert.setMessage((CharSequence)message);
        final EditText input = new EditText(this.mContext);
        input.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
        alert.setView((View)input);
        alert.setPositiveButton((CharSequence)positiveButtonText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                String password = input.getText().toString();
                if (!TextUtils.isEmpty((CharSequence)password)) {
                    CitrusActivity.this.mPaymentWebview.loadUrl("javascript:(function() { document.getElementById('password').value='" + password + "';" + "document.getElementById(\"verify\").submit();" + "}) ()");
                    input.clearFocus();
                    InputMethodManager imm = (InputMethodManager)CitrusActivity.this.getSystemService("input_method");
                    imm.hideSoftInputFromWindow(input.getWindowToken(), 0);
                    String emailId = CitrusActivity.this.mCitrusClient.getUserEmailId();
                    CitrusActivity.this.getCookie(emailId, password);
                    dialog.dismiss();
                }
            }
        });
        alert.setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                CitrusActivity.this.onBackPressed();
            }
        });
        input.requestFocus();
        alert.show();
    }

    private void getCookie(String emailId, String password) {
        this.mCitrusClient.getCookie(emailId, password, new Callback<CitrusResponse>(){

            @Override
            public void success(CitrusResponse citrusResponse) {
            }

            @Override
            public void error(CitrusError error) {
            }
        });
    }

    private class JsInterface {
        private JsInterface() {
        }

        @JavascriptInterface
        public void pgResponse(String response) {
            Logger.d((String)("PG Response :: " + response), (Object[])new Object[0]);
            if (CitrusActivity.this.mPaymentType instanceof PaymentType.CitrusCash) {
                CitrusActivity.removeCookies();
            }
            TransactionResponse transactionResponse = TransactionResponse.fromJSON(response, CitrusActivity.this.customParametersOriginalMap);
            CitrusActivity.this.sendResult(transactionResponse);
        }

        @JavascriptInterface
        public void loadWalletResponse(String response) {
            Logger.d((String)("Wallet response :: " + response), (Object[])new Object[0]);
            TransactionResponse transactionResponse = TransactionResponse.parseLoadMoneyResponse(response);
            CitrusActivity.this.sendResult(transactionResponse);
        }
    }

    private class CitrusWebClient
    extends WebViewClient {
        private CitrusWebClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (url.contains("/prepaid/pg/verify/")) {
                CitrusActivity.this.showPrompt();
                CitrusActivity.this.passwordPromptShown = true;
                return false;
            }
            view.loadUrl(url);
            return true;
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            if (CitrusActivity.this.isBackKeyPressedByUser) {
                CitrusActivity.this.showDialog("Cancelling the transaction. Please wait..", true);
            } else {
                CitrusActivity.this.showDialog("Processing your payment. Please do not refresh the page.", true);
            }
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            CitrusActivity.this.dismissDialog();
        }

        public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
            handler.proceed();
        }
    }
}

