/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.retrofit;

import com.citrus.retrofit.API;
import com.citrus.retrofit.CitrusEndPoint;
import com.citrus.retrofit.ReceivedCookiesInterceptor;
import com.citrus.sdk.Environment;
import com.citrus.sdk.response.CitrusLogger;
import com.squareup.okhttp.OkHttpClient;
import retrofit.Endpoint;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.client.OkClient;

public class RetroFitClient {
    private static API RETROFIT_CLIENT;
    private static String CITRUS_ROOT;
    private static OkHttpClient okHttpClient;
    private static CitrusEndPoint citrusEndPoint;

    private RetroFitClient() {
    }

    public static API getCitrusRetroFitClient() {
        return RETROFIT_CLIENT;
    }

    public static void initRetroFitClient(Environment environment) {
        if (environment != null) {
            CITRUS_ROOT = environment.getBaseUrl();
        }
        RetroFitClient.setupCitrusRetroFitClient();
    }

    private static void setupCitrusRetroFitClient() {
        citrusEndPoint = new CitrusEndPoint(CITRUS_ROOT);
        okHttpClient = new OkHttpClient();
        okHttpClient.setFollowRedirects(false);
        RestAdapter builder = new RestAdapter.Builder().setEndpoint((Endpoint)citrusEndPoint).setClient((Client)new OkClient(okHttpClient)).setLogLevel(CitrusLogger.isEnableLogs() ? RestAdapter.LogLevel.FULL : RestAdapter.LogLevel.NONE).build();
        RETROFIT_CLIENT = (API)builder.create(API.class);
    }

    public static API getBillGeneratorClient(String baseHost) {
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(baseHost).setClient((Client)new OkClient(new OkHttpClient())).setLogLevel(CitrusLogger.isEnableLogs() ? RestAdapter.LogLevel.FULL : RestAdapter.LogLevel.NONE).build();
        API billGeneratorClient = (API)restAdapter.create(API.class);
        return billGeneratorClient;
    }

    public static API getCitrusBaseUrlClient(String baseHost) {
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(baseHost).setClient((Client)new OkClient(new OkHttpClient())).setLogLevel(CitrusLogger.isEnableLogs() ? RestAdapter.LogLevel.FULL : RestAdapter.LogLevel.NONE).build();
        API citrusBaseUrlClient = (API)restAdapter.create(API.class);
        return citrusBaseUrlClient;
    }

    public static void setInterCeptor() {
        okHttpClient.interceptors().add(new ReceivedCookiesInterceptor());
    }

    public static void removeInterCeptor() {
        okHttpClient.interceptors().clear();
    }

    public static void resetEndPoint() {
        citrusEndPoint.setUrl(CITRUS_ROOT);
    }

    public static void setEndPoint(String url) {
        citrusEndPoint.setUrl(url);
    }

    static {
        CITRUS_ROOT = null;
        okHttpClient = null;
    }
}

