/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.otp;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import com.citrus.sdk.payment.CardOption;

public enum NetBankForOTP {
    SBI{

        @Override
        public String getTransactionJS() {
            return "javascript: document.getElementsByName('submits')[0].click();";
        }

        @Override
        public String getEnterPasswordJS() {
            return "";
        }

        @Override
        public String getSendOTPJS() {
            return "";
        }

        @Override
        public String getReSendOTPJS() {
            return "javascript:resendOTP();";
        }

        @Override
        public String getSetOTPJS(String otp) {
            return "javascript:document.getElementById('otp').setAttribute('value','" + otp + "');";
        }

        @Override
        public String getBankNameForParsing() {
            return "SBI";
        }

        @Override
        public String getBankIconName() {
            return "sbi_bank";
        }

        @Override
        public String getBankName() {
            return "SBI BANK";
        }

        @Override
        public Drawable getBankIconDrawable(Context context) {
            return 1.getBankIcon(context, this.getBankIconName());
        }

        @Override
        public boolean isBypassSendOTPButton() {
            return true;
        }

        @Override
        public boolean isBypassEnterPasswordButton() {
            return true;
        }
    }
    ,
    ICICI_CREDIT{

        @Override
        public String getTransactionJS() {
            return "javascript: document.frmPayerAuth.submit();";
        }

        @Override
        public String getEnterPasswordJS() {
            return "javascript:";
        }

        @Override
        public boolean isBypassEnterPasswordButton() {
            return true;
        }

        @Override
        public String getSendOTPJS() {
            return "javascript:var otpChannels = document.getElementsByName('otpDestinationOption');otpChannels[0].checked = true;document.getElementsByTagName('form')[0].submit();";
        }

        @Override
        public String getReSendOTPJS() {
            return "javascript:resend_otp()";
        }

        @Override
        public String getSetOTPJS(String otp) {
            return "javascript:var txtOTP = document.getElementsByName('txtAutoOtp');txtOTP[0].setAttribute('value','" + otp + "');";
        }

        @Override
        public String getBankNameForParsing() {
            return "ICICIB";
        }

        @Override
        public String getBankIconName() {
            return "icici_bank";
        }

        @Override
        public String getBankName() {
            return "ICICI BANK";
        }

        @Override
        public Drawable getBankIconDrawable(Context context) {
            return 2.getBankIcon(context, this.getBankIconName());
        }
    }
    ,
    ICICI_DEBIT{

        @Override
        public String getTransactionJS() {
            return "javascript:submitPassword();";
        }

        @Override
        public String getEnterPasswordJS() {
            return "javascript:var txtPassword=document.getElementById('txtPassword');txtPassword.focus(); txtPassword.scrollIntoView();";
        }

        @Override
        public String getSendOTPJS() {
            return "javascript:showChannelSelectPage();var otpChannels = document.getElementsByName('otpDestinationOption');otpChannels[0].checked = true;pwdBaseOtpChannelSelected(1);";
        }

        @Override
        public String getReSendOTPJS() {
            return "javascript:resendOTP();";
        }

        @Override
        public String getSetOTPJS(String otp) {
            return "javascript:var txtOTP = document.getElementsByName('otpPassword'); \ntxtOTP[0].setAttribute('value','" + otp + "');";
        }

        @Override
        public String getBankNameForParsing() {
            return "ICICIB";
        }

        @Override
        public String getBankIconName() {
            return "icici_bank";
        }

        @Override
        public String getBankName() {
            return "ICICI BANK";
        }

        @Override
        public Drawable getBankIconDrawable(Context context) {
            return 3.getBankIcon(context, this.getBankIconName());
        }
    }
    ,
    HDFC{

        @Override
        public String getTransactionJS() {
            return "javascript:document.frmDynamicAuth.submit();";
        }

        @Override
        public boolean isMultipartEnterPasswordJS() {
            return true;
        }

        @Override
        public String getMultiPartEnterPasswordJS() {
            return "javascript:var txtPassword=document.getElementById('txtPassword');txtPassword.focus(); txtPassword.scrollIntoView();";
        }

        @Override
        public String getEnterPasswordJS() {
            return "javascript: var radioButtons = document.getElementsByName('acsRadio');radioButtons[0].checked = true;selectOption();";
        }

        @Override
        public boolean isMultipartSendOTPJS() {
            return true;
        }

        @Override
        public String getSendOTPJS() {
            return "javascript: var radioButtons = document.getElementsByName('acsRadio');radioButtons[1].checked = true;selectOption();";
        }

        @Override
        public String getSetOTPJS(String otp) {
            return "javascript:document.getElementsByName('txtOtpPassword')[0].setAttribute('value','" + otp + "');";
        }

        @Override
        public String getMultiPartSendOTPJS() {
            return "javascript:generateOTP();";
        }

        @Override
        public String getReSendOTPJS() {
            return "javascript:generateOTP();";
        }

        @Override
        public String getBankNameForParsing() {
            return "HDFCBK";
        }

        @Override
        public String getBankIconName() {
            return "hdfc_bank";
        }

        @Override
        public String getBankName() {
            return "HDFC BANK";
        }

        @Override
        public Drawable getBankIconDrawable(Context context) {
            return 4.getBankIcon(context, this.getBankIconName());
        }
    }
    ,
    KOTAK_DEBIT{

        @Override
        public String getTransactionJS() {
            return "javascript: var forms = document.getElementsByTagName('form');forms[forms.length - 1].submit();";
        }

        @Override
        public String getEnterPasswordJS() {
            return "javascript:";
        }

        @Override
        public String getSendOTPJS() {
            return "javascript:";
        }

        @Override
        public String getSetOTPJS(String otp) {
            return "javascript:document.getElementById('txtOtp').setAttribute('value','" + otp + "');";
        }

        @Override
        public String getReSendOTPJS() {
            return "javascript:reSendOtp();";
        }

        @Override
        public String getBankNameForParsing() {
            return "KOTAKB";
        }

        @Override
        public String getBankIconName() {
            return "kotak_mahindra_bank";
        }

        @Override
        public String getBankName() {
            return "KOTAK MAHINDRA BANK";
        }

        @Override
        public Drawable getBankIconDrawable(Context context) {
            return 5.getBankIcon(context, this.getBankIconName());
        }

        @Override
        public boolean isBypassEnterPasswordButton() {
            return true;
        }

        @Override
        public boolean isBypassSendOTPButton() {
            return true;
        }
    }
    ,
    KOTAK_CREDIT{

        @Override
        public String getTransactionJS() {
            return "javascript: document.getElementById('cmdSubmit').click();";
        }

        @Override
        public String getEnterPasswordJS() {
            return "javascript: document.getElementsByName('authenticationOption')[1].click();var txtPassword = document.getElementById('txtPassword');txtPassword.focus(); txtPassword.scrollIntoView();";
        }

        @Override
        public String getSendOTPJS() {
            return "javascript: document.getElementsByName('authenticationOption')[0].click();";
        }

        @Override
        public String getSetOTPJS(String otp) {
            return "javascript: document.getElementById('otpValue').setAttribute('value','" + otp + "');";
        }

        @Override
        public String getReSendOTPJS() {
            return "javascript:reSendOtp();";
        }

        @Override
        public String getBankNameForParsing() {
            return "KOTAKB";
        }

        @Override
        public String getBankIconName() {
            return "kotak_mahindra_bank";
        }

        @Override
        public String getBankName() {
            return "KOTAK MAHINDRA BANK";
        }

        @Override
        public Drawable getBankIconDrawable(Context context) {
            return 6.getBankIcon(context, this.getBankIconName());
        }
    }
    ,
    CITI{

        @Override
        public String getTransactionJS() {
            return "javascript: validateOTP(1);";
        }

        @Override
        public String getEnterPasswordJS() {
            if (this.getCardScheme() == CardOption.CardScheme.MASTER_CARD) {
                return "javascript: $(\"#ipincode\").focus(); $(\"#ipincode\").scrollIntoView();";
            }
            return "javascript:document.getElementById('uid_tb_r').checked=true; showdiv('uid_tb'); setTimeout( function() {        var txtPassword = document.getElementsByName('useridanswer')[0];       txtPassword.focus(); txtPassword.scrollIntoView();  }, 300);";
        }

        @Override
        public boolean hideResendButton() {
            return this.getCardScheme() == CardOption.CardScheme.MASTER_CARD;
        }

        @Override
        public String getSendOTPJS() {
            if (this.getCardScheme() == CardOption.CardScheme.MASTER_CARD) {
                return "javascript:$(\".right .tab-but li:last\").click();";
            }
            return "javascript:document.getElementById('otp_tb_r').checked=true; OnSubmitHandler1();";
        }

        @Override
        public String getReSendOTPJS() {
            if (this.getCardScheme() == CardOption.CardScheme.MASTER_CARD) {
                return "";
            }
            return "javascript:";
        }

        @Override
        public String getBankNameForParsing() {
            return "CITIBK";
        }

        @Override
        public String getSetOTPJS(String otp) {
            if (this.getCardScheme() == CardOption.CardScheme.MASTER_CARD) {
                return "javascript:document.getElementById('otp').setAttribute('value','" + otp + "');";
            }
            return "javascript:document.getElementsByName('otp')[0].setAttribute('value','" + otp + "');";
        }

        @Override
        public boolean isBypassEnterPasswordButton() {
            return false;
        }

        @Override
        public boolean isBypassSendOTPButton() {
            return false;
        }

        @Override
        public String getBankIconName() {
            return "citi_bank";
        }

        @Override
        public String getBankName() {
            return "CITI BANK";
        }

        @Override
        public Drawable getBankIconDrawable(Context context) {
            return 7.getBankIcon(context, this.getBankIconName());
        }
    }
    ,
    UNKNOWN{

        @Override
        public String getTransactionJS() {
            return "";
        }

        @Override
        public String getEnterPasswordJS() {
            return "";
        }

        @Override
        public String getSendOTPJS() {
            return "";
        }

        @Override
        public String getReSendOTPJS() {
            return "";
        }

        @Override
        public int getOTPLength() {
            return 0;
        }

        @Override
        public String getBankNameForParsing() {
            return "";
        }

        @Override
        public String getBankIconName() {
            return "";
        }

        @Override
        public String getBankName() {
            return "";
        }

        @Override
        public Drawable getBankIconDrawable(Context context) {
            return 8.getBankIcon(context, this.getBankIconName());
        }
    };

    private CardOption.CardScheme cardScheme;

    public abstract String getTransactionJS();

    public boolean isMultipartEnterPasswordJS() {
        return false;
    }

    public String getMultiPartEnterPasswordJS() {
        return "javascript:";
    }

    public abstract String getEnterPasswordJS();

    public boolean isMultipartSendOTPJS() {
        return false;
    }

    public abstract String getSendOTPJS();

    public String getMultiPartSendOTPJS() {
        return "javascript:";
    }

    public abstract String getReSendOTPJS();

    public String getSetOTPJS(String otp) {
        return "javascript: var inputs = document.querySelectorAll('input[type=password]');inputs[inputs.length - 1].setAttribute('value','" + otp + "');";
    }

    public int getOTPLength() {
        return 6;
    }

    public boolean isBypassSendOTPButton() {
        return false;
    }

    public boolean isBypassEnterPasswordButton() {
        return false;
    }

    public boolean hideResendButton() {
        return false;
    }

    public abstract String getBankNameForParsing();

    public abstract String getBankIconName();

    public abstract String getBankName();

    public abstract Drawable getBankIconDrawable(Context var1);

    public static NetBankForOTP getNetBankForOTP(String cardType, String bankName) {
        if ("Kotak Mahindra Bank Ltd".equalsIgnoreCase(bankName) && cardType.equalsIgnoreCase("Credit")) {
            return KOTAK_CREDIT;
        }
        if ("Kotak Mahindra Bank Ltd".equalsIgnoreCase(bankName) && cardType.equalsIgnoreCase("Debit")) {
            return KOTAK_DEBIT;
        }
        if ("ICICI BANK LTD".equalsIgnoreCase(bankName) && cardType.equalsIgnoreCase("Credit")) {
            return ICICI_CREDIT;
        }
        if ("ICICI BANK LTD".equalsIgnoreCase(bankName) && cardType.equalsIgnoreCase("Debit")) {
            return ICICI_DEBIT;
        }
        if ("State Bank of India".equalsIgnoreCase(bankName) || "SBI(Maestro)".equalsIgnoreCase(bankName) || "SBI CARDS & PAYMENTS".equalsIgnoreCase(bankName)) {
            return SBI;
        }
        if ("HDFC BANK LIMITED".equalsIgnoreCase(bankName) || "HDFC BANK LIMITED(Maestro)".equalsIgnoreCase(bankName)) {
            return HDFC;
        }
        if ("CITI BANK LTD".equalsIgnoreCase(bankName) || "CITI BANK LTD(Maestro)".equalsIgnoreCase(bankName)) {
            return CITI;
        }
        return UNKNOWN;
    }

    public static Drawable getBankIcon(Context context, String bankIconName) {
        Drawable drawable2 = null;
        int resourceId = 0;
        resourceId = !bankIconName.equalsIgnoreCase("") ? context.getResources().getIdentifier(bankIconName, "drawable", context.getPackageName()) : context.getResources().getIdentifier("default_bank", "drawable", context.getPackageName());
        if (resourceId != 0) {
            drawable2 = Build.VERSION.SDK_INT >= 21 ? context.getResources().getDrawable(resourceId, null) : context.getResources().getDrawable(resourceId);
        }
        return drawable2;
    }

    public void setCardScheme(CardOption.CardScheme cardScheme) {
        this.cardScheme = cardScheme;
    }

    public CardOption.CardScheme getCardScheme() {
        return this.cardScheme;
    }
}

