/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk;

public enum Environment {
    SANDBOX{

        @Override
        public String getBaseUrl() {
            return "https://sandboxadmin.citruspay.com";
        }

        @Override
        public String getBaseCitrusUrl() {
            return "https://sandbox.citruspay.com";
        }

        @Override
        public String getDynamicPricingBaseUrl() {
            return "https://sandboxmars1.citruspay.com/dynamic-pricing/";
        }

        @Override
        public String getBinServiceURL() {
            return "https://citrusapi.citruspay.com";
        }

        @Override
        public String getAnalyticsID() {
            return "UA-33514461-4";
        }

        @Override
        public String getCancelUrl(String vanity) {
            return String.format(this.getBaseCitrusUrl() + "/sslperf/%s/cancel", vanity);
        }

        public String toString() {
            return "SANDBOX";
        }
    }
    ,
    PRODUCTION{

        @Override
        public String getBaseUrl() {
            return "https://admin.citruspay.com";
        }

        @Override
        public String getBaseCitrusUrl() {
            return "https://citruspay.com";
        }

        @Override
        public String getBinServiceURL() {
            return "https://citrusapi.citruspay.com";
        }

        @Override
        public String getDynamicPricingBaseUrl() {
            return "https://mars.citruspay.com/dynamicpricing";
        }

        @Override
        public String getAnalyticsID() {
            return "UA-33514461-5";
        }

        @Override
        public String getCancelUrl(String vanity) {
            return String.format(this.getBaseCitrusUrl() + "/sslperf/%s/cancel", vanity);
        }

        public String toString() {
            return "PRODUCTION";
        }
    }
    ,
    OOPS{

        @Override
        public String getBaseUrl() {
            return "https://oops.citruspay.com";
        }

        @Override
        public String getBaseCitrusUrl() {
            return "https://oops.citruspay.com";
        }

        @Override
        public String getBinServiceURL() {
            return "https://citrusapi.citruspay.com";
        }

        @Override
        public String getDynamicPricingBaseUrl() {
            return "https://oops.citruspay.com/dynamic-pricing/";
        }

        @Override
        public String getAnalyticsID() {
            return "UA-33514461-4";
        }

        @Override
        public String getCancelUrl(String vanity) {
            return String.format(this.getBaseCitrusUrl() + "/sslperf/%s/cancel", vanity);
        }

        public String toString() {
            return "OOPS";
        }
    }
    ,
    STG5{

        @Override
        public String getBaseUrl() {
            return "https://stgadmin5.citruspay.com/";
        }

        @Override
        public String getBaseCitrusUrl() {
            return "https://stgadmin5.citruspay.com/";
        }

        @Override
        public String getDynamicPricingBaseUrl() {
            return "https://stgadmin5.citruspay.com/dynamic-pricing/";
        }

        @Override
        public String getBinServiceURL() {
            return "https://citrusapi.citruspay.com";
        }

        @Override
        public String getAnalyticsID() {
            return "UA-33514461-4";
        }

        @Override
        public String getCancelUrl(String vanity) {
            return String.format(this.getBaseCitrusUrl() + "/sslperf/%s/cancel", vanity);
        }

        public String toString() {
            return "STG5";
        }
    }
    ,
    STG3{

        @Override
        public String getBaseUrl() {
            return "https://stg3admin.citruspay.com/";
        }

        @Override
        public String getBaseCitrusUrl() {
            return "https://stg3admin.citruspay.com/";
        }

        @Override
        public String getDynamicPricingBaseUrl() {
            return "https://stg3admin.citruspay.com/dynamic-pricing/";
        }

        @Override
        public String getAnalyticsID() {
            return "UA-33514461-4";
        }

        public String toString() {
            return "STG5";
        }

        @Override
        public String getBinServiceURL() {
            return "https://citrusapi.citruspay.com";
        }

        @Override
        public String getCancelUrl(String vanity) {
            return String.format(this.getBaseCitrusUrl() + "/sslperf/%s/cancel", vanity);
        }
    }
    ,
    NONE{

        @Override
        public String getBaseUrl() {
            return null;
        }

        public String toString() {
            return null;
        }

        @Override
        public String getBaseCitrusUrl() {
            return null;
        }

        @Override
        public String getBinServiceURL() {
            return null;
        }

        @Override
        public String getDynamicPricingBaseUrl() {
            return null;
        }

        @Override
        public String getAnalyticsID() {
            return null;
        }

        @Override
        public String getCancelUrl(String vanity) {
            return null;
        }
    };


    public abstract String getBaseUrl();

    public abstract String getBaseCitrusUrl();

    public abstract String getBinServiceURL();

    public abstract String getDynamicPricingBaseUrl();

    public abstract String getAnalyticsID();

    public abstract String getCancelUrl(String var1);
}

