/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.card;

import com.citrus.card.CardType;
import com.citrus.card.DateUtils;
import com.citrus.card.TextUtils;
import com.citrus.mobile.CType;
import com.citrus.sdk.classes.Month;
import com.citrus.sdk.classes.Year;

@Deprecated
public class Card {
    private String cardnumber;
    private String cardCVV;
    private String nameOnCard;
    private String cardType;
    private String expMonth;
    private String expYear;
    private String crdr;
    private String token;

    @Deprecated
    public Card(String cardNum, String month, String year, String cvv, String name, String crdr) {
        this.cardnumber = this.normalizeCardNumber(cardNum);
        this.cardCVV = cvv;
        this.nameOnCard = !android.text.TextUtils.isEmpty((CharSequence)name) ? name : "Name On Card";
        this.expMonth = month;
        this.expYear = year;
        this.crdr = crdr;
        this.setCreditOrDebit();
    }

    public Card(String cardNum, Month month, Year year, String cvv, String name, CType cardType) {
        this.cardnumber = this.normalizeCardNumber(cardNum);
        this.cardCVV = cvv;
        this.nameOnCard = !android.text.TextUtils.isEmpty((CharSequence)name) ? name : "Name On Card";
        this.expMonth = month.toString();
        this.expYear = year.toString();
        this.crdr = cardType.toString();
        this.setCreditOrDebit();
    }

    public Card(String token, String cvv) {
        this.token = token;
        this.cardCVV = cvv;
        this.cardnumber = null;
    }

    private void setCreditOrDebit() {
        if (this.getCardType() != null && "AMEX".equalsIgnoreCase(this.getCardType().toString())) {
            this.crdr = "credit";
        } else if (this.getCardType() != null && "MTRO".equalsIgnoreCase(this.getCardType().toString())) {
            this.crdr = "debit";
        }
    }

    public CardType getCardType() {
        return CardType.typeOf(this.cardnumber);
    }

    public String getCardNumber() {
        return this.cardnumber;
    }

    public String getCardHolderName() {
        return this.nameOnCard;
    }

    public String getCrdr() {
        return this.crdr;
    }

    public String getExpiryYear() {
        if (!android.text.TextUtils.isEmpty((CharSequence)this.expYear)) {
            if (this.expYear.length() > 2 && this.expYear.substring(0, 2).equalsIgnoreCase("20")) {
                return String.valueOf(this.expYear);
            }
            return "20" + String.valueOf(this.expYear);
        }
        return this.expYear;
    }

    public String getExpiryMonth() {
        if (!android.text.TextUtils.isEmpty((CharSequence)this.expMonth)) {
            if (Integer.valueOf(this.expMonth) < 10) {
                return "0" + String.valueOf(Integer.valueOf(this.expMonth));
            }
            return String.valueOf(this.expMonth);
        }
        return this.expMonth;
    }

    public String getCvvNumber() {
        return this.cardCVV;
    }

    public String getcardToken() {
        return this.token;
    }

    private String normalizeCardNumber(String number) {
        if (number == null) {
            return null;
        }
        return number.trim().replaceAll("\\s+|-", "");
    }

    public boolean validateCard() {
        CardType type = this.getCardType();
        String cardType = null;
        if (type != null) {
            cardType = type.toString();
        }
        if ("MTRO".equalsIgnoreCase(cardType)) {
            return this.validateNumber() && this.validateMaestroCtype();
        }
        if (this.cardCVV == null) {
            return this.validateNumber() && this.validateExpiryDate();
        }
        return this.validateNumber() && this.validateExpiryDate() && this.validateCVC();
    }

    public boolean validateMaestroCtype() {
        if (this.getCrdr() == null) {
            return false;
        }
        return this.getCrdr().equalsIgnoreCase(CType.DEBIT.toString());
    }

    public boolean validateNumber() {
        CardType type = this.getCardType();
        if (type == null) {
            return false;
        }
        this.cardType = type.toString();
        if (TextUtils.isBlank(this.cardnumber)) {
            return false;
        }
        String rawNumber = this.cardnumber.trim().replaceAll("\\s+|-", "");
        if (android.text.TextUtils.equals((CharSequence)this.cardType, (CharSequence)"MTRO")) {
            return this.isValidLuhnNumber(rawNumber);
        }
        if (TextUtils.isBlank(rawNumber) || !TextUtils.isWholePositiveNumber(rawNumber) || !this.isValidLuhnNumber(rawNumber)) {
            return false;
        }
        if (!"AMEX".equals(this.cardType) && rawNumber.length() != 16) {
            return false;
        }
        return !"AMEX".equals(this.cardType) || rawNumber.length() == 15;
    }

    public boolean validateExpiryDate() {
        if (!this.validateExpMonth()) {
            return false;
        }
        if (!this.validateExpYear()) {
            return false;
        }
        return !DateUtils.hasMonthPassed(Integer.valueOf(this.expYear), Integer.valueOf(this.expMonth));
    }

    public boolean validateExpMonth() {
        if (this.expMonth == null) {
            return false;
        }
        return Integer.valueOf(this.expMonth) >= 1 && Integer.valueOf(this.expMonth) <= 12;
    }

    public boolean validateExpYear() {
        if (this.expYear == null) {
            return false;
        }
        return !DateUtils.hasYearPassed(Integer.valueOf(this.expYear));
    }

    public boolean validateCVC() {
        boolean validLength;
        if (TextUtils.isBlank(this.cardCVV)) {
            return false;
        }
        String cvcValue = this.cardCVV.trim();
        this.cardType = this.getCardType().toString();
        boolean bl = validLength = this.cardType == null && cvcValue.length() >= 3 && cvcValue.length() <= 4 || "AMEX".equals(this.cardType) && cvcValue.length() == 4 || !"AMEX".equals(this.cardType) && cvcValue.length() == 3;
        return TextUtils.isWholePositiveNumber(cvcValue) && validLength;
    }

    private boolean isValidLuhnNumber(String number) {
        boolean isOdd = true;
        int sum = 0;
        for (int index = number.length() - 1; index >= 0; --index) {
            char c = number.charAt(index);
            if (!Character.isDigit(c)) {
                return false;
            }
            int digitInteger = Integer.parseInt("" + c);
            boolean bl = isOdd = !isOdd;
            if (isOdd) {
                digitInteger *= 2;
            }
            if (digitInteger > 9) {
                digitInteger -= 9;
            }
            sum += digitInteger;
        }
        return sum % 10 == 0;
    }
}

