/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.classes;

import android.text.TextUtils;
import com.citrus.sdk.classes.AccountProfile;
import org.json.JSONException;
import org.json.JSONObject;

public class MemberInfo {
    private final AccountProfile profileByEmail;
    private final AccountProfile profileByMobile;
    private String responseCode;

    public String getResponseCode() {
        return this.responseCode;
    }

    public MemberInfo(AccountProfile profileByEmail, AccountProfile profileByMobile) {
        this.profileByEmail = profileByEmail;
        this.profileByMobile = profileByMobile;
    }

    public MemberInfo(AccountProfile profileByEmail, AccountProfile profileByMobile, String responseCode) {
        this.profileByEmail = profileByEmail;
        this.profileByMobile = profileByMobile;
        this.responseCode = responseCode;
    }

    public AccountProfile getProfileByEmail() {
        return this.profileByEmail;
    }

    public AccountProfile getProfileByMobile() {
        return this.profileByMobile;
    }

    public static MemberInfo fromJSON(String jsonString) {
        MemberInfo memberInfo = null;
        if (!TextUtils.isEmpty((CharSequence)jsonString)) {
            try {
                JSONObject jsonObject = new JSONObject(jsonString);
                JSONObject responseData = jsonObject.getJSONObject("responseData");
                AccountProfile profileByEmail = AccountProfile.fromJSONObject(responseData.optJSONObject("profileByEmail"));
                AccountProfile profileByMobile = AccountProfile.fromJSONObject(responseData.optJSONObject("profileByMobile"));
                String responseCode = jsonObject.getString("responseCode");
                memberInfo = new MemberInfo(profileByEmail, profileByMobile, responseCode);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return memberInfo;
    }

    public String toString() {
        return "MemberInfo{profileByEmail=" + this.profileByEmail + ", profileByMobile=" + this.profileByMobile + '}';
    }
}

