/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.citrus.analytics.PaymentType;
import com.citrus.sdk.classes.PGHealth;
import com.citrus.sdk.payment.CardOption;
import com.citrus.sdk.payment.CreditCardOption;
import com.citrus.sdk.payment.DebitCardOption;
import com.citrus.sdk.payment.NetbankingOption;
import org.json.JSONObject;

public abstract class PaymentOption
implements Parcelable {
    protected String name = null;
    protected String token = null;
    protected boolean savePaymentOption = false;
    protected PGHealth pgHealth = PGHealth.UNKNOWN;
    public static final Parcelable.Creator<PaymentOption> CREATOR = new Parcelable.Creator<PaymentOption>(){

        public PaymentOption createFromParcel(Parcel source) {
            return null;
        }

        public PaymentOption[] newArray(int size) {
            return new PaymentOption[size];
        }
    };

    PaymentOption() {
    }

    PaymentOption(String name, String token) {
        this.name = name;
        this.token = token;
    }

    private PaymentOption(Parcel in) {
        this.name = in.readString();
        this.token = in.readString();
        this.savePaymentOption = in.readByte() != 0;
    }

    public static PaymentOption fromJSONObject(JSONObject walletObject) {
        PaymentOption paymentOption = null;
        String type = walletObject.optString("type");
        String name = walletObject.optString("name");
        String token = walletObject.optString("token");
        String cardHolderName = walletObject.optString("owner");
        String expiry = walletObject.optString("expiryDate");
        String cardNumber = walletObject.optString("number");
        String cardScheme = walletObject.optString("scheme");
        if (!TextUtils.isEmpty((CharSequence)name) && !TextUtils.isEmpty((CharSequence)token)) {
            if (TextUtils.equals((CharSequence)"credit", (CharSequence)type)) {
                paymentOption = new CreditCardOption(name, token, cardHolderName, cardNumber, CardOption.CardScheme.getCardScheme(cardScheme), expiry);
            } else if (TextUtils.equals((CharSequence)"debit", (CharSequence)type)) {
                paymentOption = new DebitCardOption(name, token, cardHolderName, cardNumber, CardOption.CardScheme.getCardScheme(cardScheme), expiry);
            } else {
                String bankName = walletObject.optString("bank");
                paymentOption = new NetbankingOption(name, token, bankName);
            }
        }
        return paymentOption;
    }

    public String getName() {
        return this.name;
    }

    public String getToken() {
        return this.token;
    }

    public boolean isSavePaymentOption() {
        return this.savePaymentOption;
    }

    public void setSavePaymentOption(boolean savePaymentOption) {
        this.savePaymentOption = savePaymentOption;
    }

    public PGHealth getPgHealth() {
        return this.pgHealth;
    }

    protected void setPgHealth(PGHealth pgHealth) {
        this.pgHealth = pgHealth;
    }

    public abstract String getSavePaymentOptionObject();

    public abstract Drawable getOptionIcon(Context var1);

    public abstract PaymentType getAnalyticsPaymentType();

    public abstract String getDynamicPricingPaymentMode();

    public String toString() {
        return "PaymentOption{name='" + this.name + '\'' + ", token='" + this.token + '\'' + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name);
        dest.writeString(this.token);
        dest.writeByte(this.savePaymentOption ? (byte)1 : 0);
    }
}

