/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.otp;

import android.content.Context;
import android.text.InputFilter;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.citrus.library.R;
import com.citrus.sdk.otp.NetBankForOTP;
import com.citrus.sdk.otp.OTPViewListener;

public class OTPPopupView
extends LinearLayout
implements View.OnClickListener {
    private Context context;
    private Button btnCancelTransaction;
    private OTPViewListener listener;
    private TextView otpAutoDetectHeaderTxtView = null;
    private ProgressBar otpAutoDetectProgressBar = null;
    private EditText enterOtpEditTxt = null;
    private Button otpResendBtn = null;
    private Button otpConfirmBtn = null;
    private TextView cancelTransactionTxtView = null;
    private TextView bankNameTextView = null;
    private ImageView bankLogoImgView = null;
    private boolean otpViewToggleStatus = false;
    private int otpEditTextLength = -1;
    private NetBankForOTP netBankForOTP = null;

    public OTPPopupView(Context context) {
        super(context);
        this.context = context;
        this.init(null, 0);
    }

    public OTPPopupView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.init(attrs, 0);
    }

    private void init(AttributeSet attrs, int defStyle) {
        this.setOrientation(0);
        OTPPopupView.inflate((Context)this.context, (int)R.layout.otp_txn_options, (ViewGroup)this);
        ImageButton btnEnterPassword = (ImageButton)this.findViewById(R.id.enterPasswordImgViewId);
        ImageButton btnSendOTP = (ImageButton)this.findViewById(R.id.sendOtpImgViewId);
        this.cancelTransactionTxtView = (TextView)this.findViewById(R.id.cancelTransactionTxtId);
        this.bankLogoImgView = (ImageView)this.findViewById(R.id.bankLogoImgViewId);
        this.bankNameTextView = (TextView)this.findViewById(R.id.bankNameTextViewId);
        LinearLayout enterPasswordLayout = (LinearLayout)this.findViewById(R.id.enterPasswordLayoutId);
        LinearLayout enterOtpLayout = (LinearLayout)this.findViewById(R.id.enterOtpLayoutId);
        enterOtpLayout.setOnClickListener((View.OnClickListener)this);
        enterPasswordLayout.setOnClickListener((View.OnClickListener)this);
        btnEnterPassword.setOnClickListener((View.OnClickListener)this);
        btnSendOTP.setOnClickListener((View.OnClickListener)this);
        this.cancelTransactionTxtView.setOnClickListener((View.OnClickListener)this);
    }

    public void setOTP(String otp) {
        this.enterOtpEditTxt.setText((CharSequence)otp);
        this.otpResendBtn.setVisibility(8);
        this.otpConfirmBtn.setBackgroundResource(R.drawable.btn_confirm);
        this.otpConfirmBtn.setClickable(true);
        this.otpConfirmBtn.setEnabled(true);
        this.otpAutoDetectProgressBar.setVisibility(8);
        this.otpAutoDetectHeaderTxtView.setText(R.string.otp_detection_success_text);
    }

    public void otpReadTimeout() {
        this.otpResendBtn.setBackgroundResource(R.drawable.btn_resend);
        this.otpResendBtn.setClickable(true);
        this.otpConfirmBtn.setBackgroundResource(R.drawable.btn_confirm);
        this.otpConfirmBtn.setClickable(true);
        this.otpConfirmBtn.setEnabled(true);
        this.otpAutoDetectProgressBar.setVisibility(8);
        this.otpAutoDetectHeaderTxtView.setText(R.string.otp_detection_failed_text);
    }

    public void handleResendOTP() {
        this.otpAutoDetectHeaderTxtView.setText(R.string.otp_autodetect_header_text);
        this.otpAutoDetectProgressBar.setVisibility(0);
    }

    public void setOtpViewToggleStatus(boolean toggle) {
        this.otpViewToggleStatus = toggle;
    }

    public boolean getOtpViewToggleStatus() {
        return this.otpViewToggleStatus;
    }

    public void setNetBankForOTP(NetBankForOTP netBankForOTP) {
        this.netBankForOTP = netBankForOTP;
        this.setBankDetails();
    }

    private void setBankDetails() {
        this.bankLogoImgView.setImageDrawable(this.netBankForOTP.getBankIconDrawable(this.context));
        this.bankNameTextView.setText((CharSequence)this.netBankForOTP.getBankName());
    }

    public void setListener(OTPViewListener listener) {
        this.listener = listener;
    }

    public void enableEnterPasswordButton(boolean enabled) {
        if (this.findViewById(R.id.enterPasswordLayoutId) != null && !enabled) {
            this.findViewById(R.id.enterPasswordLayoutId).setVisibility(8);
        }
    }

    public void onClick(View view) {
        int i = view.getId();
        if (i == R.id.enterPasswordImgViewId || i == R.id.enterPasswordLayoutId) {
            this.listener.onEnterPasswordClicked();
        } else if (i == R.id.sendOtpImgViewId || i == R.id.enterOtpLayoutId) {
            this.displayOtpAutoDetectPopup();
            this.listener.onSendOtpClicked();
            this.listener.startOtpReadTimer();
        } else if (i == R.id.otpConfirmBtnId) {
            String otp = this.enterOtpEditTxt.getText().toString();
            if (this.enterOtpEditTxt.getText().toString().equalsIgnoreCase("")) {
                this.enterOtpEditTxt.requestFocus();
                this.enterOtpEditTxt.setError((CharSequence)"Please enter OTP or click Resend");
            } else {
                this.listener.onProcessTransactionClicked(otp);
            }
        } else if (i == R.id.otpResendBtnId) {
            this.listener.onResendOTPClicked();
        } else if (i == R.id.cancelTransactionTxtId) {
            this.listener.onCancelClicked();
        }
    }

    public void displayOtpAutoDetectPopup() {
        this.removeAllViews();
        OTPPopupView.inflate((Context)this.context, (int)R.layout.otp_txn_auto_detect, (ViewGroup)this);
        this.otpAutoDetectHeaderTxtView = (TextView)this.findViewById(R.id.otpAutoDetectHeaderTxtId);
        this.otpAutoDetectProgressBar = (ProgressBar)this.findViewById(R.id.otpAutoDetectProgressBarId);
        this.enterOtpEditTxt = (EditText)this.findViewById(R.id.enterOtpEditTxtId);
        this.otpResendBtn = (Button)this.findViewById(R.id.otpResendBtnId);
        this.otpConfirmBtn = (Button)this.findViewById(R.id.otpConfirmBtnId);
        this.cancelTransactionTxtView = (TextView)this.findViewById(R.id.cancelTransactionTxtId);
        this.bankLogoImgView = (ImageView)this.findViewById(R.id.bankLogoImgViewId);
        this.bankNameTextView = (TextView)this.findViewById(R.id.bankNameTextViewId);
        this.otpResendBtn.setOnClickListener((View.OnClickListener)this);
        this.otpConfirmBtn.setOnClickListener((View.OnClickListener)this);
        this.cancelTransactionTxtView.setOnClickListener((View.OnClickListener)this);
        InputFilter[] FilterArray = new InputFilter[1];
        this.otpEditTextLength = this.netBankForOTP.getOTPLength();
        if (this.otpEditTextLength != -1) {
            FilterArray[0] = new InputFilter.LengthFilter(this.otpEditTextLength);
        }
        this.enterOtpEditTxt.setFilters(FilterArray);
        this.setBankDetails();
    }
}

