/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.classes;

import android.text.TextUtils;
import com.citrus.sdk.otp.NetBankForOTP;
import com.citrus.sdk.payment.CardOption;
import org.json.JSONException;
import org.json.JSONObject;

public class BinServiceResponse {
    private CardOption.CardScheme cardScheme = null;
    private NetBankForOTP netBankForOTP = null;

    public BinServiceResponse(CardOption.CardScheme cardScheme, NetBankForOTP netBankForOTP) {
        this.cardScheme = cardScheme;
        this.netBankForOTP = netBankForOTP;
    }

    public static BinServiceResponse fromJSON(String json) {
        BinServiceResponse response = null;
        if (!TextUtils.isEmpty((CharSequence)json)) {
            try {
                JSONObject jsonObject = new JSONObject(json);
                String scheme = jsonObject.optString("cardscheme");
                String cardtype = jsonObject.optString("cardtype");
                CardOption.CardScheme cardScheme = CardOption.CardScheme.getCardScheme(scheme);
                String issuingbank = jsonObject.optString("issuingbank");
                NetBankForOTP netBankForOTP = NetBankForOTP.getNetBankForOTP(cardtype, issuingbank);
                response = new BinServiceResponse(cardScheme, netBankForOTP);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return response;
    }

    public CardOption.CardScheme getCardScheme() {
        return this.cardScheme;
    }

    public NetBankForOTP getNetBankForOTP() {
        return this.netBankForOTP;
    }
}

