/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.classes;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.dynamicPricing.DynamicPricingResponse;
import com.citrus.sdk.otp.NetBankForOTP;
import com.citrus.sdk.payment.CardOption;
import com.citrus.sdk.payment.CreditCardOption;
import com.citrus.sdk.payment.NetbankingOption;
import com.citrus.sdk.payment.PaymentBill;
import com.citrus.sdk.payment.PaymentOption;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;

public final class Utils {
    public static boolean isNetworkConnected(Context context) {
        boolean connected = false;
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        connected = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
        cm = null;
        return connected;
    }

    public static String removeSpecialCharacters(String input) {
        String str = null;
        if (!TextUtils.isEmpty((CharSequence)input)) {
            str = input.replaceAll("[^\\w\\s-]", "").replaceAll("[-_]", "");
        }
        return str;
    }

    public static String getOTP(String message, NetBankForOTP netBankForOTP) {
        String otp = "";
        int length = netBankForOTP.getOTPLength();
        String[] nbs = message.split("\\D+");
        if (nbs.length != 0) {
            for (String number : nbs) {
                if (number.length() != length) continue;
                return number;
            }
        }
        return otp;
    }

    public static String getURLEncodedParamsForCancelTransaction(CitrusUser citrusUser, PaymentBill paymentBill, PaymentOption paymentOption, DynamicPricingResponse dynamicPricingResponse, String vanity) {
        CitrusUser.Address address = citrusUser != null ? citrusUser.getAddress() : null;
        StringBuffer buffer = new StringBuffer();
        try {
            buffer.append("vanityUrl=");
            buffer.append(vanity);
            buffer.append("&firstName=");
            if (citrusUser != null && !TextUtils.isEmpty((CharSequence)citrusUser.getFirstName())) {
                buffer.append(URLEncoder.encode(citrusUser.getFirstName(), "utf-8"));
            }
            buffer.append("&lastName=");
            if (citrusUser != null && !TextUtils.isEmpty((CharSequence)citrusUser.getLastName())) {
                buffer.append(URLEncoder.encode(citrusUser.getLastName(), "utf-8"));
            }
            buffer.append("&email=");
            if (citrusUser != null && !TextUtils.isEmpty((CharSequence)citrusUser.getEmailId())) {
                buffer.append(URLEncoder.encode(citrusUser.getEmailId(), "utf-8"));
            }
            buffer.append("&phoneNumber=");
            if (citrusUser != null && !TextUtils.isEmpty((CharSequence)citrusUser.getMobileNo())) {
                buffer.append(URLEncoder.encode(citrusUser.getMobileNo(), "utf-8"));
            }
            buffer.append("&addressCountry=");
            if (address != null && !TextUtils.isEmpty((CharSequence)address.getCountry())) {
                buffer.append(URLEncoder.encode(address.getCountry(), "utf-8"));
            }
            buffer.append("&addressState=");
            if (address != null && !TextUtils.isEmpty((CharSequence)address.getState())) {
                buffer.append(URLEncoder.encode(address.getState(), "utf-8"));
            }
            buffer.append("&addressCity=");
            if (address != null && !TextUtils.isEmpty((CharSequence)address.getCity())) {
                buffer.append(URLEncoder.encode(address.getCity(), "utf-8"));
            }
            buffer.append("&addressStreet1=");
            if (address != null && !TextUtils.isEmpty((CharSequence)address.getStreet1())) {
                buffer.append(URLEncoder.encode(address.getStreet1(), "utf-8"));
            }
            buffer.append("&addressStreet2=");
            if (address != null && !TextUtils.isEmpty((CharSequence)address.getStreet2())) {
                buffer.append(URLEncoder.encode(address.getStreet2(), "utf-8"));
            }
            buffer.append("&addressZip=");
            if (address != null && !TextUtils.isEmpty((CharSequence)address.getZip())) {
                buffer.append(URLEncoder.encode(address.getZip(), "utf-8"));
            }
            if (paymentOption != null) {
                if (paymentOption instanceof CardOption) {
                    CardOption cardOption = (CardOption)paymentOption;
                    buffer.append("&paymentMode=");
                    buffer.append(URLEncoder.encode(cardOption instanceof CreditCardOption ? "CREDIT_CARD" : "DEBIT_CARD", "utf-8"));
                    buffer.append("&cardNumber=");
                    buffer.append(URLEncoder.encode(cardOption.getCardNumber(), "utf-8"));
                    buffer.append("&cvvNumber=");
                    buffer.append(URLEncoder.encode(cardOption.getCardCVV(), "utf-8"));
                    buffer.append("&expiryMonth=");
                    buffer.append(URLEncoder.encode(cardOption.getCardExpiryMonth(), "utf-8"));
                    buffer.append("&expiryYear=");
                    buffer.append(URLEncoder.encode(cardOption.getCardExpiryYear(), "utf-8"));
                    buffer.append("&cardType=");
                    if (cardOption.getCardScheme() != null) {
                        buffer.append(URLEncoder.encode(cardOption.getCardScheme().getName(), "utf-8"));
                    }
                } else if (paymentOption instanceof NetbankingOption) {
                    buffer.append("&paymentMode=");
                    buffer.append(URLEncoder.encode("NET_BANKING", "utf-8"));
                }
            }
            if (paymentBill != null) {
                buffer.append("&returnUrl=");
                buffer.append(URLEncoder.encode(paymentBill.getReturnUrl(), "utf-8"));
                buffer.append("&notifyUrl=");
                buffer.append(URLEncoder.encode(paymentBill.getNotifyUrl(), "utf-8"));
                Amount amount = paymentBill.getAmount();
                buffer.append("&orderAmount=");
                buffer.append(URLEncoder.encode(amount.getValue(), "utf-8"));
                buffer.append("&currency=");
                buffer.append(URLEncoder.encode(amount.getCurrency(), "utf-8"));
                buffer.append("&secSignature=");
                buffer.append(URLEncoder.encode(paymentBill.getRequestSignature(), "utf-8"));
                buffer.append("&merchantTxnId=");
                buffer.append(URLEncoder.encode(paymentBill.getMerchantTransactionId(), "utf-8"));
                buffer.append("&secSignature=");
                buffer.append(URLEncoder.encode(paymentBill.getRequestSignature(), "utf-8"));
                buffer.append("&merchantAccessKey=");
                buffer.append(URLEncoder.encode(paymentBill.getMerchantAccessKey(), "utf-8"));
                buffer.append("&dpSignature=");
                buffer.append(URLEncoder.encode(paymentBill.getDpSignature(), "utf-8"));
                Map<String, String> customParametersMap = paymentBill.getCustomParametersMap();
                if (customParametersMap != null) {
                    Set<String> keys = customParametersMap.keySet();
                    int count = 0;
                    for (String key : keys) {
                        buffer.append("&");
                        buffer.append(URLEncoder.encode(String.format("customParams[%d].name", count), "utf-8"));
                        buffer.append(String.format("=%s", URLEncoder.encode(key, "utf-8")));
                        buffer.append("&");
                        buffer.append(URLEncoder.encode(String.format("customParams[%d].value", count), "utf-8"));
                        buffer.append(String.format("=%s", URLEncoder.encode(customParametersMap.get(key), "utf-8")));
                        ++count;
                    }
                }
            }
            if (dynamicPricingResponse != null) {
                buffer.append("&alteredAmount=");
                if (dynamicPricingResponse.getAlteredAmount() != null) {
                    buffer.append(URLEncoder.encode(dynamicPricingResponse.getAlteredAmount().getValue(), "utf-8"));
                }
            }
            buffer.append("&isEMI=");
            buffer.append("&pgCode=");
            buffer.append("&dpFlag=");
            buffer.append("&errorMessage=");
            buffer.append("&retryCount=0");
            buffer.append("&paymentModeType=Editable");
            buffer.append("&couponCode=");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }
}

