/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.otp;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.telephony.SmsMessage;
import com.citrus.sdk.CitrusClient;
import com.citrus.sdk.classes.Utils;
import com.citrus.sdk.otp.NetBankForOTP;

public class SMSReceiver
extends BroadcastReceiver {
    private CitrusClient citrusClient = null;

    public void onReceive(Context context, Intent intent) {
        this.citrusClient = CitrusClient.getInstance(context);
        NetBankForOTP netBankForOTP = this.citrusClient.getNetBankForOTP();
        Bundle bundle = intent.getExtras();
        SmsMessage[] msgs = null;
        String otp = "";
        if (bundle != null) {
            Object[] pdus = (Object[])bundle.get("pdus");
            msgs = new SmsMessage[pdus.length];
            for (int i = 0; i < msgs.length; ++i) {
                msgs[i] = SmsMessage.createFromPdu((byte[])((byte[])pdus[i]));
                if (!msgs[i].getOriginatingAddress().contains(netBankForOTP.getBankNameForParsing())) continue;
                String message = msgs[i].getMessageBody();
                otp = Utils.getOTP(message, netBankForOTP);
                break;
            }
            Intent messageIntent = new Intent("com.citrus.sdk.otp.AUTO_READ_OTP");
            messageIntent.putExtra("INTENT_EXTRA_AUTO_OTP", otp);
            LocalBroadcastManager.getInstance((Context)context).sendBroadcast(messageIntent);
        }
    }
}

