/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.citrus.analytics.PaymentType;
import com.citrus.sdk.classes.Month;
import com.citrus.sdk.classes.Year;
import com.citrus.sdk.payment.CardOption;
import java.io.Serializable;

public final class CreditCardOption
extends CardOption
implements Parcelable {
    public static final Parcelable.Creator<CreditCardOption> CREATOR = new Parcelable.Creator<CreditCardOption>(){

        public CreditCardOption createFromParcel(Parcel source) {
            return new CreditCardOption(source);
        }

        public CreditCardOption[] newArray(int size) {
            return new CreditCardOption[size];
        }
    };

    public CreditCardOption() {
    }

    public CreditCardOption(String token, String cardCVV) {
        super(token, cardCVV);
    }

    public CreditCardOption(String cardHolderName, String cardNumber, String cardCVV, Month cardExpiryMonth, Year cardExpiryYear) {
        super(cardHolderName, cardNumber, cardCVV, cardExpiryMonth, cardExpiryYear);
    }

    public CreditCardOption(String cardNumber, CardOption.CardScheme cardScheme) {
        super(cardNumber, cardScheme);
    }

    CreditCardOption(String name, String token, String cardHolderName, String cardNumber, CardOption.CardScheme cardScheme, String cardExpiry) {
        super(name, token, cardHolderName, cardNumber, cardScheme, cardExpiry);
    }

    @Override
    public String getCardType() {
        if (this.cardScheme == CardOption.CardScheme.MAESTRO) {
            return CardOption.CardType.DEBIT.getCardType();
        }
        return CardOption.CardType.CREDIT.getCardType();
    }

    @Override
    public PaymentType getAnalyticsPaymentType() {
        return PaymentType.CREDIT_CARD;
    }

    @Override
    public String getDynamicPricingPaymentMode() {
        if (!TextUtils.isEmpty((CharSequence)this.token)) {
            return "CITRUS_WALLET";
        }
        return "CREDIT_CARD";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.cardHolderName);
        dest.writeString(this.cardNumber);
        dest.writeString(this.cardCVV);
        dest.writeString(this.cardExpiry);
        dest.writeString(this.cardExpiryMonth);
        dest.writeString(this.cardExpiryYear);
        dest.writeSerializable((Serializable)((Object)this.cardScheme));
        dest.writeString(this.name);
        dest.writeString(this.token);
        dest.writeByte(this.savePaymentOption ? (byte)1 : 0);
    }

    private CreditCardOption(Parcel in) {
        this.cardHolderName = in.readString();
        this.cardNumber = in.readString();
        this.cardCVV = in.readString();
        this.cardExpiry = in.readString();
        this.cardExpiryMonth = in.readString();
        this.cardExpiryYear = in.readString();
        this.cardScheme = (CardOption.CardScheme)((Object)in.readSerializable());
        this.name = in.readString();
        this.token = in.readString();
        this.savePaymentOption = in.readByte() != 0;
    }
}

