/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.classes;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.citrus.sdk.classes.Amount;
import com.google.gson.annotations.SerializedName;
import org.json.JSONException;
import org.json.JSONObject;

public class CashoutInfo
implements Parcelable {
    private Amount amount = null;
    @SerializedName(value="account")
    private String accountNo = null;
    @SerializedName(value="owner")
    private String accountHolderName = null;
    @SerializedName(value="ifsc")
    private String ifscCode = null;
    public static final Parcelable.Creator<CashoutInfo> CREATOR = new Parcelable.Creator<CashoutInfo>(){

        public CashoutInfo createFromParcel(Parcel source) {
            return new CashoutInfo(source);
        }

        public CashoutInfo[] newArray(int size) {
            return new CashoutInfo[size];
        }
    };

    public CashoutInfo(@NonNull Amount amount, @NonNull String accountNo, @NonNull String accountHolderName, @NonNull String ifscCode) {
        this.amount = amount;
        this.accountNo = accountNo;
        this.accountHolderName = accountHolderName;
        this.ifscCode = ifscCode;
    }

    private CashoutInfo(String accountNo, String accountHolderName, String ifscCode) {
        this.accountNo = accountNo;
        this.accountHolderName = accountHolderName;
        this.ifscCode = ifscCode;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public String getAccountNo() {
        return this.accountNo;
    }

    public String getAccountHolderName() {
        return this.accountHolderName;
    }

    public String getIfscCode() {
        return this.ifscCode;
    }

    public boolean validate() {
        return this.amount != null && !TextUtils.isEmpty((CharSequence)this.accountNo) && !TextUtils.isEmpty((CharSequence)this.accountHolderName) && !TextUtils.isEmpty((CharSequence)this.ifscCode);
    }

    public static CashoutInfo fromJSON(String json) {
        CashoutInfo cashoutInfo = null;
        if (json != null) {
            try {
                JSONObject cashoutObject = new JSONObject(json);
                JSONObject cashoutAccount = cashoutObject.getJSONObject("cashoutAccount");
                String accountNo = cashoutAccount.getString("number");
                String accountHolderName = cashoutAccount.getString("owner");
                String branch = cashoutAccount.getString("branch");
                cashoutInfo = new CashoutInfo(accountNo, accountHolderName, branch);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return cashoutInfo;
    }

    public static String toJSON(CashoutInfo cashoutInfo) {
        String json = null;
        if (cashoutInfo != null && cashoutInfo.validate()) {
            try {
                JSONObject cashoutObject = new JSONObject();
                JSONObject cashoutAccount = new JSONObject();
                String accountNo = cashoutInfo.getAccountNo();
                String accountHolderName = cashoutInfo.getAccountHolderName();
                String branch = cashoutInfo.getIfscCode();
                cashoutAccount.put("number", (Object)accountNo);
                cashoutAccount.put("owner", (Object)accountHolderName);
                cashoutAccount.put("branch", (Object)branch);
                cashoutObject.put("cashoutAccount", (Object)cashoutAccount);
                cashoutObject.put("type", (Object)"prepaid");
                cashoutObject.put("currency", (Object)cashoutInfo.getAmount().getCurrency());
                json = cashoutObject.toString();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return json;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.amount, 0);
        dest.writeString(this.accountNo);
        dest.writeString(this.accountHolderName);
        dest.writeString(this.ifscCode);
    }

    private CashoutInfo(Parcel in) {
        this.amount = (Amount)in.readParcelable(Amount.class.getClassLoader());
        this.accountNo = in.readString();
        this.accountHolderName = in.readString();
        this.ifscCode = in.readString();
    }

    public String toString() {
        return "CashoutInfo{amount=" + this.amount + ", accountNo='" + this.accountNo + '\'' + ", accountHolderName='" + this.accountHolderName + '\'' + ", ifscCode='" + this.ifscCode + '\'' + '}';
    }
}

