/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.content.LocalBroadcastManager;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebView;
import com.citrus.card.TextUtils;
import com.citrus.cash.PersistentConfig;
import com.citrus.citrususer.RandomPassword;
import com.citrus.mobile.Config;
import com.citrus.mobile.OAuth2GrantType;
import com.citrus.mobile.OauthToken;
import com.citrus.mobile.User;
import com.citrus.retrofit.API;
import com.citrus.retrofit.RetroFitClient;
import com.citrus.sdk.Callback;
import com.citrus.sdk.CitrusActivity;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.Environment;
import com.citrus.sdk.GetJSONBill;
import com.citrus.sdk.TransactionResponse;
import com.citrus.sdk.classes.AccessToken;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.BinServiceResponse;
import com.citrus.sdk.classes.BindPOJO;
import com.citrus.sdk.classes.CashoutInfo;
import com.citrus.sdk.classes.CitrusException;
import com.citrus.sdk.classes.MemberInfo;
import com.citrus.sdk.classes.PGHealth;
import com.citrus.sdk.classes.PGHealthResponse;
import com.citrus.sdk.dynamicPricing.DynamicPricingRequest;
import com.citrus.sdk.dynamicPricing.DynamicPricingRequestType;
import com.citrus.sdk.dynamicPricing.DynamicPricingResponse;
import com.citrus.sdk.otp.NetBankForOTP;
import com.citrus.sdk.payment.CardOption;
import com.citrus.sdk.payment.CreditCardOption;
import com.citrus.sdk.payment.DebitCardOption;
import com.citrus.sdk.payment.MerchantPaymentOption;
import com.citrus.sdk.payment.NetbankingOption;
import com.citrus.sdk.payment.PaymentBill;
import com.citrus.sdk.payment.PaymentOption;
import com.citrus.sdk.payment.PaymentType;
import com.citrus.sdk.response.BindUserResponse;
import com.citrus.sdk.response.CitrusError;
import com.citrus.sdk.response.CitrusLogger;
import com.citrus.sdk.response.CitrusResponse;
import com.citrus.sdk.response.PaymentResponse;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.orhanobut.logger.Logger;
import de.greenrobot.event.EventBus;
import eventbus.CookieEvents;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit.ResponseCallback;
import retrofit.RetrofitError;
import retrofit.client.Response;
import retrofit.mime.TypedByteArray;
import retrofit.mime.TypedString;

public class CitrusClient {
    private static final String SIGNIN_TOKEN = "signin_token";
    private static final String SIGNUP_TOKEN = "signup_token";
    private static final String PREPAID_TOKEN = "prepaid_token";
    private String signinId;
    private String signinSecret;
    private String signupId;
    private String signupSecret;
    private String vanity;
    private String merchantName;
    private Environment environment = Environment.SANDBOX;
    private Amount balanceAmount;
    private static CitrusClient instance;
    private final Context mContext;
    private SharedPreferences mSharedPreferences;
    private MerchantPaymentOption merchantPaymentOption = null;
    private API retrofitClient;
    private API citrusBaseUrlClient;
    private API dynamicPricingClient;
    private String prepaidCookie = null;
    private OauthToken oauthToken = null;
    private CookieManager cookieManager;
    private BroadcastReceiver paymentEventReceiver = null;
    private Map<String, PGHealth> pgHealthMap = null;
    private boolean initialized = false;
    private CitrusUser citrusUser = null;
    private boolean showDummyScreen = false;
    private boolean prepaymentTokenValid = false;
    private boolean autoOtpReading = false;
    private NetBankForOTP netBankForOTP = NetBankForOTP.UNKNOWN;

    private CitrusClient(Context context) {
        this.mContext = context;
        this.initRetrofitClient();
        this.oauthToken = new OauthToken(context);
    }

    public void enableLog(boolean enable) {
        if (enable) {
            CitrusLogger.enableLogs();
        } else {
            CitrusLogger.disableLogs();
        }
    }

    public void showDummyScreenWhilePayments(boolean showDummyScreen) {
        this.showDummyScreen = showDummyScreen;
    }

    public boolean isShowDummyScreenWhilePayments() {
        return this.showDummyScreen;
    }

    public boolean isAutoOtpReading() {
        return this.autoOtpReading;
    }

    public void enableAutoOtpReading(boolean enable) {
        this.autoOtpReading = enable;
    }

    public void init(@NonNull String signupId, @NonNull String signupSecret, @NonNull String signinId, @NonNull String signinSecret, @NonNull String vanity, @NonNull Environment environment) {
        if (!this.initialized) {
            this.signupId = signupId;
            this.signupSecret = signupSecret;
            this.signinId = signinId;
            this.signinSecret = signinSecret;
            this.vanity = vanity;
            if (!CitrusLogger.isEnableLogs()) {
                CitrusLogger.disableLogs();
            }
            if (environment == null) {
                this.environment = Environment.SANDBOX;
            }
            this.environment = environment;
            this.saveSDKEnvironment();
            if (this.validate()) {
                this.initRetrofitClient();
                this.initCitrusBaseUrlClient();
                this.initDynamicPricingClient();
            }
            Config.setupSignupId(signupId);
            Config.setupSignupSecret(signupSecret);
            Config.setSigninId(signinId);
            Config.setSigninSecret(signinSecret);
            Config.setVanity(vanity);
            Config.setEnv(environment.toString().toLowerCase());
            Logger.d((String)("VANITY*** " + vanity), (Object[])new Object[0]);
            this.getMerchantPaymentOptions(null);
            this.isUserSignedIn(new Callback<Boolean>(){

                @Override
                public void success(Boolean signedIn) {
                    if (signedIn.booleanValue()) {
                        CitrusClient.this.getProfileInfo(null);
                        CitrusClient.this.checkPrepaymentTokenValidity(new Callback<Boolean>(){

                            @Override
                            public void success(Boolean valid) {
                                CitrusClient.this.prepaymentTokenValid = valid;
                            }

                            @Override
                            public void error(CitrusError error) {
                                CitrusClient.this.prepaymentTokenValid = false;
                            }
                        });
                    }
                }

                @Override
                public void error(CitrusError error) {
                }
            });
            this.initialized = true;
        }
    }

    private void fetchPGHealthForAllBanks() {
        this.citrusBaseUrlClient.getPGHealthForAllBanks(this.vanity, "ALLBANKS", new retrofit.Callback<JsonElement>(){

            public void success(JsonElement jsonElement, Response response) {
                try {
                    JSONObject jsonObject = new JSONObject(jsonElement.toString());
                    Iterator keys = jsonObject.keys();
                    while (keys.hasNext()) {
                        if (CitrusClient.this.pgHealthMap == null) {
                            CitrusClient.this.pgHealthMap = new HashMap();
                        }
                        String key = (String)keys.next();
                        String health = jsonObject.optString(key);
                        CitrusClient.this.pgHealthMap.put(key, PGHealth.getPGHealth(health));
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            public void failure(RetrofitError error) {
            }
        });
    }

    private void saveSDKEnvironment() {
        if (this.oauthToken.getCurrentEnvironment() == Environment.NONE) {
            this.oauthToken.saveEnvironment(this.environment);
            Logger.d((String)"NO ENVIRONMENT EXISTS earlier", (Object[])new Object[0]);
        } else if (this.oauthToken.getCurrentEnvironment() == this.environment) {
            Logger.d((String)"PREVIOUS AND CURRENT ENVIRONMENT IS SAME", (Object[])new Object[0]);
        } else {
            this.signOut(new Callback<CitrusResponse>(){

                @Override
                public void success(CitrusResponse citrusResponse) {
                    CitrusClient.this.oauthToken.saveEnvironment(CitrusClient.this.environment);
                    Logger.d((String)"ENVIRONMMENT MISMATCH ***user Logging out", (Object[])new Object[0]);
                }

                @Override
                public void error(CitrusError error) {
                    CitrusClient.this.oauthToken.saveEnvironment(CitrusClient.this.environment);
                }
            });
        }
    }

    private void initRetrofitClient() {
        RetroFitClient.initRetroFitClient(this.environment);
        this.retrofitClient = RetroFitClient.getCitrusRetroFitClient();
    }

    private void initCitrusBaseUrlClient() {
        this.citrusBaseUrlClient = RetroFitClient.getClientWithUrl(this.environment.getBaseCitrusUrl());
    }

    private void initDynamicPricingClient() {
        this.dynamicPricingClient = RetroFitClient.getClientWithUrl(this.environment.getDynamicPricingBaseUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CitrusClient getInstance(Context context) {
        if (instance != null) return instance;
        Class<CitrusClient> clazz = CitrusClient.class;
        synchronized (CitrusClient.class) {
            if (instance != null) return instance;
            instance = new CitrusClient(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized void isCitrusMember(final String emailId, final String mobileNo, final Callback<Boolean> callback) {
        this.bindUser(emailId, mobileNo, new Callback<String>(){

            @Override
            public void success(String s) {
                if ("User Bind Successfully.".equalsIgnoreCase(s)) {
                    RandomPassword pwd = new RandomPassword();
                    String random_pass = pwd.generate(emailId, mobileNo);
                    CitrusClient.this.retrofitClient.getSignInWithPasswordResponse(CitrusClient.this.signinId, CitrusClient.this.signinSecret, emailId, random_pass, OAuth2GrantType.password.toString(), new retrofit.Callback<AccessToken>(){

                        public void success(AccessToken accessToken, Response response) {
                            Logger.d((String)"User Not A Citrus Member. Please Sign Up User.", (Object[])new Object[0]);
                            CitrusClient.this.sendResponse(callback, false);
                        }

                        public void failure(RetrofitError error) {
                            Logger.d((String)"User Already A Citrus Member. Please Sign In User.", (Object[])new Object[0]);
                            CitrusClient.this.sendResponse(callback, true);
                        }
                    });
                } else {
                    CitrusClient.this.sendError(callback, new CitrusError("Failed to bind User!!!", CitrusResponse.Status.FAILED));
                }
            }

            @Override
            public void error(CitrusError error) {
                CitrusClient.this.sendError(callback, error);
            }
        });
    }

    public synchronized void getMemberInfo(final String emailId, final String mobileNo, final Callback<MemberInfo> callback) {
        if (this.validate()) {
            this.retrofitClient.getSignUpToken(this.signupId, this.signupSecret, OAuth2GrantType.implicit.toString(), new retrofit.Callback<AccessToken>(){

                public void success(AccessToken accessToken, Response response) {
                    if (accessToken != null && accessToken.getHeaderAccessToken() != null) {
                        JSONObject jsonObject = new JSONObject();
                        try {
                            jsonObject.put("email", (Object)emailId);
                            jsonObject.put("mobile", (Object)mobileNo);
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                        CitrusClient.this.retrofitClient.getMemberInfo(accessToken.getHeaderAccessToken(), new TypedString(jsonObject.toString()), new retrofit.Callback<JsonElement>(){

                            public void success(JsonElement jsonElement, Response response) {
                                MemberInfo memberInfo = MemberInfo.fromJSON(jsonElement.toString());
                                if (memberInfo != null) {
                                    CitrusClient.this.sendResponse(callback, memberInfo);
                                } else {
                                    CitrusClient.this.sendError(callback, new CitrusError("Unable to fetch member info", CitrusResponse.Status.FAILED));
                                }
                            }

                            public void failure(RetrofitError error) {
                                CitrusClient.this.sendError(callback, error);
                            }
                        });
                    } else {
                        CitrusClient.this.sendError(callback, new CitrusError("ERROR: Unable to fetch Signup token.", CitrusResponse.Status.FAILED));
                    }
                }

                public void failure(RetrofitError error) {
                    CitrusClient.this.sendError(callback, error);
                }
            });
        }
    }

    public synchronized void bindUser(final String emailId, final String mobileNo, final Callback<String> callback) {
        if (this.validate()) {
            this.retrofitClient.getSignUpToken(this.signupId, this.signupSecret, OAuth2GrantType.implicit.toString(), new retrofit.Callback<AccessToken>(){

                public void success(AccessToken accessToken, Response response) {
                    Logger.d((String)("accessToken " + accessToken.getJSON().toString()), (Object[])new Object[0]);
                    if (accessToken.getHeaderAccessToken() != null) {
                        OauthToken signuptoken = new OauthToken(CitrusClient.this.mContext, CitrusClient.SIGNUP_TOKEN);
                        signuptoken.createToken(accessToken.getJSON());
                        CitrusClient.this.retrofitClient.getBindResponse(accessToken.getHeaderAccessToken(), emailId, mobileNo, new retrofit.Callback<BindPOJO>(){

                            public void success(BindPOJO bindPOJO, Response response) {
                                Logger.d((String)("BIND RESPONSE " + bindPOJO.getUsername()), (Object[])new Object[0]);
                                CitrusClient.this.retrofitClient.getSignInToken(CitrusClient.this.signinId, CitrusClient.this.signinSecret, emailId, OAuth2GrantType.username.toString(), new retrofit.Callback<AccessToken>(){

                                    public void success(AccessToken accessToken, Response response) {
                                        Logger.d((String)("SIGNIN accessToken" + accessToken.getJSON().toString()), (Object[])new Object[0]);
                                        if (accessToken.getHeaderAccessToken() != null) {
                                            OauthToken token = new OauthToken(CitrusClient.this.mContext, CitrusClient.SIGNIN_TOKEN);
                                            token.createToken(accessToken.getJSON());
                                            token.saveUserDetails(emailId, mobileNo);
                                            Logger.d((String)"USER BIND SUCCESSFULLY***", (Object[])new Object[0]);
                                            CitrusClient.this.sendResponse(callback, "User Bind Successfully.");
                                        }
                                    }

                                    public void failure(RetrofitError error) {
                                        CitrusClient.this.sendError(callback, error);
                                    }
                                });
                            }

                            public void failure(RetrofitError error) {
                                CitrusClient.this.sendError(callback, error);
                            }
                        });
                    } else {
                        CitrusClient.this.sendError(callback, new CitrusError("ERROR: Unable to Link User", CitrusResponse.Status.FAILED));
                    }
                }

                public void failure(RetrofitError error) {
                    CitrusClient.this.sendError(callback, error);
                }
            });
        }
    }

    public synchronized void bindUserByMobile(final String emailId, final String mobileNo, final Callback<BindUserResponse> callback) {
        if (this.validate()) {
            this.getMemberInfo(emailId, mobileNo, new Callback<MemberInfo>(){

                @Override
                public void success(final MemberInfo memberInfo) {
                    CitrusClient.this.retrofitClient.getSignUpToken(CitrusClient.this.signupId, CitrusClient.this.signupSecret, OAuth2GrantType.implicit.toString(), new retrofit.Callback<AccessToken>(){

                        public void success(AccessToken accessToken, Response response) {
                            Logger.d((String)("accessToken " + accessToken.getJSON().toString()), (Object[])new Object[0]);
                            if (accessToken.getHeaderAccessToken() != null) {
                                OauthToken signuptoken = new OauthToken(CitrusClient.this.mContext, CitrusClient.SIGNUP_TOKEN);
                                signuptoken.createToken(accessToken.getJSON());
                                CitrusClient.this.retrofitClient.bindUserByMobile(accessToken.getHeaderAccessToken(), emailId, mobileNo, new retrofit.Callback<BindPOJO>(){

                                    public void success(BindPOJO bindPOJO, Response response) {
                                        BindUserResponse bindUserResponse;
                                        Logger.d((String)("BIND BY MOBILE RESPONSE " + bindPOJO.getUsername()), (Object[])new Object[0]);
                                        if (memberInfo.getProfileByMobile() == null && memberInfo.getProfileByEmail() == null) {
                                            bindUserResponse = new BindUserResponse(BindUserResponse.RESPONSE_CODE_NEW_USER_BOUND);
                                            CitrusClient.this.resetPassword(emailId, new Callback<CitrusResponse>(){

                                                @Override
                                                public void success(CitrusResponse citrusResponse) {
                                                }

                                                @Override
                                                public void error(CitrusError error) {
                                                }
                                            });
                                        } else {
                                            bindUserResponse = new BindUserResponse(BindUserResponse.RESPONSE_CODE_EXISTING_USER_BOUND);
                                        }
                                        CitrusClient.this.retrofitClient.getSignInToken(CitrusClient.this.signinId, CitrusClient.this.signinSecret, bindPOJO.getUsername(), OAuth2GrantType.username.toString(), new retrofit.Callback<AccessToken>(){

                                            public void success(AccessToken accessToken, Response response) {
                                                Logger.d((String)("SIGNIN accessToken" + accessToken.getJSON().toString()), (Object[])new Object[0]);
                                                if (accessToken.getHeaderAccessToken() != null) {
                                                    OauthToken token = new OauthToken(CitrusClient.this.mContext, CitrusClient.SIGNIN_TOKEN);
                                                    token.createToken(accessToken.getJSON());
                                                    token.saveUserDetails(emailId, mobileNo);
                                                    Logger.d((String)"USER BIND BY MOBILE SUCCESSFULLY***", (Object[])new Object[0]);
                                                    CitrusClient.this.sendResponse(callback, bindUserResponse);
                                                }
                                            }

                                            public void failure(RetrofitError error) {
                                                CitrusClient.this.sendError(callback, error);
                                            }
                                        });
                                    }

                                    public void failure(RetrofitError error) {
                                        CitrusClient.this.sendError(callback, error);
                                    }
                                });
                            } else {
                                CitrusClient.this.sendError(callback, new CitrusError("ERROR: Unable to fetch Signup token.", CitrusResponse.Status.FAILED));
                            }
                        }

                        public void failure(RetrofitError error) {
                            CitrusClient.this.sendError(callback, error);
                        }
                    });
                }

                @Override
                public void error(CitrusError error) {
                    CitrusClient.this.sendError(callback, error);
                }
            });
        }
    }

    public synchronized void signIn(final String emailId, final String password, final Callback<CitrusResponse> callback) {
        this.retrofitClient.getSignInToken(this.signinId, this.signinSecret, emailId, OAuth2GrantType.username.toString(), new retrofit.Callback<AccessToken>(){

            public void success(AccessToken accessToken, Response response) {
                if (accessToken.getHeaderAccessToken() != null) {
                    OauthToken token = new OauthToken(CitrusClient.this.mContext, CitrusClient.SIGNIN_TOKEN);
                    token.createToken(accessToken.getJSON());
                    CitrusClient.this.retrofitClient.getSignInWithPasswordResponse(CitrusClient.this.signinId, CitrusClient.this.signinSecret, emailId, password, OAuth2GrantType.password.toString(), new retrofit.Callback<AccessToken>(){

                        public void success(AccessToken accessToken, Response response) {
                            Logger.d((String)("SIGN IN RESPONSE " + accessToken.getJSON().toString()), (Object[])new Object[0]);
                            if (accessToken.getHeaderAccessToken() != null) {
                                CitrusClient.this.getProfileInfo(null);
                                OauthToken token = new OauthToken(CitrusClient.this.mContext, CitrusClient.PREPAID_TOKEN);
                                token.createToken(accessToken.getJSON());
                                token.saveUserDetails(emailId, null);
                                CitrusClient.this.activatePrepaidUser(new Callback<Amount>(){

                                    @Override
                                    public void success(Amount amount) {
                                        RetroFitClient.setInterCeptor();
                                        EventBus.getDefault().register((Object)CitrusClient.this);
                                        CitrusClient.this.retrofitClient.getCookie(emailId, password, "true", new retrofit.Callback<String>(){

                                            public void success(String s, Response response) {
                                            }

                                            public void failure(RetrofitError error) {
                                                if (CitrusClient.this.prepaidCookie != null) {
                                                    CitrusClient.this.cookieManager = CookieManager.getInstance();
                                                    PersistentConfig config = new PersistentConfig(CitrusClient.this.mContext);
                                                    if (config.getCookieString() != null) {
                                                        CitrusClient.this.cookieManager;
                                                        CookieManager.getInstance().removeSessionCookie();
                                                    }
                                                    CookieSyncManager.createInstance((Context)CitrusClient.this.mContext);
                                                    config.setCookie(CitrusClient.this.prepaidCookie);
                                                } else {
                                                    Logger.d((String)"PREPAID LOGIN UNSUCCESSFUL", (Object[])new Object[0]);
                                                }
                                                EventBus.getDefault().unregister((Object)CitrusClient.this);
                                                CitrusClient.this.checkPrepaymentTokenValidity(new Callback<Boolean>(){

                                                    @Override
                                                    public void success(Boolean valid) {
                                                        CitrusClient.this.prepaymentTokenValid = valid;
                                                    }

                                                    @Override
                                                    public void error(CitrusError error) {
                                                        CitrusClient.this.prepaymentTokenValid = false;
                                                    }
                                                });
                                                CitrusClient.this.sendResponse(callback, new CitrusResponse("User Signed In Successfully.", CitrusResponse.Status.SUCCESSFUL));
                                            }
                                        });
                                    }

                                    @Override
                                    public void error(CitrusError error) {
                                        CitrusClient.this.sendError(callback, error);
                                    }
                                });
                            }
                        }

                        public void failure(RetrofitError error) {
                            Logger.d((String)("SIGN IN RESPONSE ERROR **" + error.getMessage()), (Object[])new Object[0]);
                            CitrusClient.this.sendError(callback, error);
                        }
                    });
                }
            }

            public void failure(RetrofitError error) {
                CitrusClient.this.sendError(callback, error);
            }
        });
    }

    public synchronized void signInWithMobileNo(final String mobileNo, final String password, final Callback<CitrusResponse> callback) {
        this.retrofitClient.getSignInToken(this.signinId, this.signinSecret, mobileNo, OAuth2GrantType.username.toString(), new retrofit.Callback<AccessToken>(){

            public void success(AccessToken accessToken, Response response) {
                if (accessToken.getHeaderAccessToken() != null) {
                    OauthToken token = new OauthToken(CitrusClient.this.mContext, CitrusClient.SIGNIN_TOKEN);
                    token.createToken(accessToken.getJSON());
                    CitrusClient.this.retrofitClient.getSignInWithPasswordResponse(CitrusClient.this.signinId, CitrusClient.this.signinSecret, mobileNo, password, OAuth2GrantType.password.toString(), new retrofit.Callback<AccessToken>(){

                        public void success(AccessToken accessToken, Response response) {
                            CitrusClient.this.getProfileInfo(null);
                            Logger.d((String)("SIGN IN RESPONSE " + accessToken.getJSON().toString()), (Object[])new Object[0]);
                            if (accessToken.getHeaderAccessToken() != null) {
                                final OauthToken token = new OauthToken(CitrusClient.this.mContext, CitrusClient.PREPAID_TOKEN);
                                token.createToken(accessToken.getJSON());
                                CitrusClient.this.getMemberInfo(null, mobileNo, new Callback<MemberInfo>(){

                                    @Override
                                    public void success(MemberInfo memberInfo) {
                                        if (memberInfo != null && memberInfo.getProfileByMobile() != null) {
                                            token.saveUserDetails(memberInfo.getProfileByMobile().getEmailId(), mobileNo);
                                        }
                                    }

                                    @Override
                                    public void error(CitrusError error) {
                                    }
                                });
                                CitrusClient.this.activatePrepaidUser(new Callback<Amount>(){

                                    @Override
                                    public void success(Amount amount) {
                                        RetroFitClient.setInterCeptor();
                                        EventBus.getDefault().register((Object)CitrusClient.this);
                                        CitrusClient.this.retrofitClient.getCookie(mobileNo, password, "true", new retrofit.Callback<String>(){

                                            public void success(String s, Response response) {
                                            }

                                            public void failure(RetrofitError error) {
                                                if (CitrusClient.this.prepaidCookie != null) {
                                                    CitrusClient.this.cookieManager = CookieManager.getInstance();
                                                    PersistentConfig config = new PersistentConfig(CitrusClient.this.mContext);
                                                    if (config.getCookieString() != null) {
                                                        CitrusClient.this.cookieManager;
                                                        CookieManager.getInstance().removeSessionCookie();
                                                    }
                                                    CookieSyncManager.createInstance((Context)CitrusClient.this.mContext);
                                                    config.setCookie(CitrusClient.this.prepaidCookie);
                                                } else {
                                                    Logger.d((String)"PREPAID LOGIN UNSUCCESSFUL", (Object[])new Object[0]);
                                                }
                                                EventBus.getDefault().unregister((Object)CitrusClient.this);
                                                CitrusClient.this.checkPrepaymentTokenValidity(new Callback<Boolean>(){

                                                    @Override
                                                    public void success(Boolean valid) {
                                                        CitrusClient.this.prepaymentTokenValid = valid;
                                                    }

                                                    @Override
                                                    public void error(CitrusError error) {
                                                        CitrusClient.this.prepaymentTokenValid = false;
                                                    }
                                                });
                                                CitrusClient.this.sendResponse(callback, new CitrusResponse("User Signed In Successfully.", CitrusResponse.Status.SUCCESSFUL));
                                            }
                                        });
                                    }

                                    @Override
                                    public void error(CitrusError error) {
                                        CitrusClient.this.sendError(callback, error);
                                    }
                                });
                            }
                        }

                        public void failure(RetrofitError error) {
                            Logger.d((String)("SIGN IN RESPONSE ERROR **" + error.getMessage()), (Object[])new Object[0]);
                            CitrusClient.this.sendError(callback, error);
                        }
                    });
                }
            }

            public void failure(RetrofitError error) {
                CitrusClient.this.sendError(callback, error);
            }
        });
    }

    public synchronized void getCookie(String email, String password, final Callback<CitrusResponse> callback) {
        RetroFitClient.setInterCeptor();
        EventBus.getDefault().register((Object)this);
        this.retrofitClient.getCookie(email, password, "true", new retrofit.Callback<String>(){

            public void success(String s, Response response) {
            }

            public void failure(RetrofitError error) {
                EventBus.getDefault().unregister((Object)CitrusClient.this);
                if (error.getResponse().getStatus() == 500) {
                    CitrusError citrusError = new CitrusError("Invalid Credentials!!! Please check your passsword.", CitrusResponse.Status.FAILED);
                    callback.error(citrusError);
                } else {
                    if (CitrusClient.this.prepaidCookie != null) {
                        CitrusClient.this.cookieManager = CookieManager.getInstance();
                        PersistentConfig config = new PersistentConfig(CitrusClient.this.mContext);
                        if (config.getCookieString() != null) {
                            CitrusClient.this.cookieManager;
                            CookieManager.getInstance().removeSessionCookie();
                        }
                        CookieSyncManager.createInstance((Context)CitrusClient.this.mContext);
                        config.setCookie(CitrusClient.this.prepaidCookie);
                    } else {
                        Logger.d((String)"PREPAID LOGIN UNSUCCESSFUL", (Object[])new Object[0]);
                    }
                    CitrusClient.this.sendResponse(callback, new CitrusResponse("User Cookie Sign In Suceesfully.", CitrusResponse.Status.SUCCESSFUL));
                }
            }
        });
    }

    public synchronized void signOut(Callback<CitrusResponse> callback) {
        if (User.logoutUser(this.mContext)) {
            this.prepaymentTokenValid = false;
            CitrusResponse citrusResponse = new CitrusResponse("User Logged Out Successfully.", CitrusResponse.Status.SUCCESSFUL);
            this.sendResponse(callback, citrusResponse);
        } else {
            CitrusError citrusError = new CitrusError("Failed to logout.", CitrusResponse.Status.FAILED);
            callback.error(citrusError);
        }
        this.citrusUser = null;
    }

    public synchronized void signUp(final String emailId, String mobileNo, final String password, final Callback<CitrusResponse> callback) {
        if (this.validate()) {
            OauthToken token = new OauthToken(this.mContext, SIGNIN_TOKEN);
            JSONObject jsontoken = token.getuserToken();
            try {
                String header = "Bearer " + jsontoken.getString("access_token");
                RandomPassword pwd = new RandomPassword();
                String random_pass = pwd.generate(emailId, mobileNo);
                this.retrofitClient.setPasswordResponse(header, random_pass, password, new retrofit.Callback<ResponseCallback>(){

                    public void success(ResponseCallback responseCallback, Response response) {
                        Logger.d((String)("SIGNUP PASSWORD RESPONSE **" + String.valueOf(response.getStatus())), (Object[])new Object[0]);
                        CitrusClient.this.signIn(emailId, password, new Callback<CitrusResponse>(){

                            @Override
                            public void success(CitrusResponse citrusResponse) {
                                CitrusClient.this.activatePrepaidUser(new Callback<Amount>(){

                                    @Override
                                    public void success(Amount amount) {
                                        CitrusClient.this.sendResponse(callback, new CitrusResponse("User is signed up successfully.", CitrusResponse.Status.SUCCESSFUL));
                                    }

                                    @Override
                                    public void error(CitrusError error) {
                                        CitrusClient.this.sendError(callback, error);
                                    }
                                });
                            }

                            @Override
                            public void error(CitrusError error) {
                                CitrusClient.this.sendError(callback, error);
                            }
                        });
                    }

                    public void failure(RetrofitError error) {
                        Logger.d((String)("SIGNUP PASSWORD ERROR **" + error.getMessage()), (Object[])new Object[0]);
                        CitrusClient.this.sendError(callback, error);
                    }
                });
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void resetPassword(final String emailId, final @NonNull Callback<CitrusResponse> callback) {
        this.oauthToken.getSignUpToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                if (accessToken != null) {
                    CitrusClient.this.retrofitClient.resetPassword(accessToken.getHeaderAccessToken(), emailId, new retrofit.Callback<JsonElement>(){

                        public void success(JsonElement element, Response response) {
                            CitrusClient.this.sendResponse(callback, new CitrusResponse("Reset password link has been on your email.", CitrusResponse.Status.SUCCESSFUL));
                        }

                        public void failure(RetrofitError error) {
                            CitrusClient.this.sendError(callback, error);
                        }
                    });
                } else {
                    CitrusClient.this.sendError(callback, new CitrusError("Error: Reset password failed", CitrusResponse.Status.FAILED));
                }
            }

            @Override
            public void error(CitrusError error) {
                CitrusClient.this.sendError(callback, error);
            }
        });
    }

    public synchronized void getWallet(final Callback<List<PaymentOption>> callback) {
        if (this.validate()) {
            this.oauthToken.getSignInToken(new Callback<AccessToken>(){

                @Override
                public void success(AccessToken accessToken) {
                    CitrusClient.this.retrofitClient.getWallet(accessToken.getHeaderAccessToken(), new retrofit.Callback<JsonElement>(){

                        public void success(JsonElement element, Response response) {
                            if (element != null) {
                                ArrayList<PaymentOption> walletList = new ArrayList<PaymentOption>();
                                try {
                                    JSONObject jsonObject = new JSONObject(element.toString());
                                    JSONArray paymentOptions = jsonObject.optJSONArray("paymentOptions");
                                    if (paymentOptions != null) {
                                        if (CitrusClient.this.merchantPaymentOption != null) {
                                            Set<CardOption.CardScheme> creditCardSchemeSet = CitrusClient.this.merchantPaymentOption.getCreditCardSchemeSet();
                                            Set<CardOption.CardScheme> debitCardSchemeSet = CitrusClient.this.merchantPaymentOption.getDebitCardSchemeSet();
                                            ArrayList<NetbankingOption> netbankingOptionList = CitrusClient.this.merchantPaymentOption.getNetbankingOptionList();
                                            for (int i = 0; i < paymentOptions.length(); ++i) {
                                                PaymentOption option = PaymentOption.fromJSONObject(paymentOptions.getJSONObject(i));
                                                if ((creditCardSchemeSet == null || debitCardSchemeSet == null) && option instanceof CardOption) {
                                                    walletList.add(option);
                                                    continue;
                                                }
                                                if (option instanceof CreditCardOption && creditCardSchemeSet != null && creditCardSchemeSet.contains((Object)((CreditCardOption)option).getCardScheme())) {
                                                    walletList.add(option);
                                                    continue;
                                                }
                                                if (option instanceof DebitCardOption && debitCardSchemeSet != null && debitCardSchemeSet.contains((Object)((DebitCardOption)option).getCardScheme())) {
                                                    walletList.add(option);
                                                    continue;
                                                }
                                                if (!(option instanceof NetbankingOption) || netbankingOptionList == null || !netbankingOptionList.contains(option)) continue;
                                                NetbankingOption netbankingOption = (NetbankingOption)option;
                                                if (CitrusClient.this.pgHealthMap != null) {
                                                    netbankingOption.setPgHealth((PGHealth)((Object)CitrusClient.this.pgHealthMap.get(netbankingOption.getBankCID())));
                                                }
                                                walletList.add(netbankingOption);
                                            }
                                        } else {
                                            for (int i = 0; i < paymentOptions.length(); ++i) {
                                                PaymentOption option = PaymentOption.fromJSONObject(paymentOptions.getJSONObject(i));
                                                walletList.add(option);
                                            }
                                        }
                                    }
                                    CitrusClient.this.sendResponse(callback, walletList);
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                    CitrusClient.this.sendError(callback, new CitrusError("ERROR: Invalid json received.", CitrusResponse.Status.FAILED));
                                }
                            } else {
                                CitrusClient.this.sendError(callback, new CitrusError("ERROR: Invalid json received.", CitrusResponse.Status.FAILED));
                            }
                        }

                        public void failure(RetrofitError error) {
                            CitrusClient.this.sendError(callback, new CitrusError(error.getMessage(), CitrusResponse.Status.FAILED));
                        }
                    });
                }

                @Override
                public void error(CitrusError error) {
                    CitrusClient.this.sendError(callback, error);
                }
            });
        }
    }

    private synchronized void activatePrepaidUser(final Callback<Amount> callback) {
        if (this.validate()) {
            this.oauthToken.getPrepaidToken(new Callback<AccessToken>(){

                @Override
                public void success(AccessToken accessToken) {
                    CitrusClient.this.retrofitClient.activatePrepaidUser(accessToken.getHeaderAccessToken(), new retrofit.Callback<Amount>(){

                        public void success(Amount amount, Response response) {
                            CitrusClient.this.sendResponse(callback, amount);
                        }

                        public void failure(RetrofitError error) {
                            CitrusClient.this.sendError(callback, error);
                        }
                    });
                }

                @Override
                public void error(CitrusError error) {
                    CitrusClient.this.sendError(callback, error);
                }
            });
        }
    }

    public synchronized void getProfileInfo(final Callback<CitrusUser> callback) {
        if (this.validate() && this.citrusUser == null) {
            this.getPrepaidToken(new Callback<AccessToken>(){

                @Override
                public void success(AccessToken accessToken) {
                    CitrusClient.this.retrofitClient.getProfileInfo(accessToken.getHeaderAccessToken(), new retrofit.Callback<JsonElement>(){

                        public void success(JsonElement jsonElement, Response response) {
                            String profileInfo = jsonElement.toString();
                            CitrusClient.this.citrusUser = CitrusUser.fromJSON(profileInfo);
                            CitrusClient.this.sendResponse(callback, CitrusClient.this.citrusUser);
                        }

                        public void failure(RetrofitError error) {
                            CitrusClient.this.sendError(callback, error);
                        }
                    });
                }

                @Override
                public void error(CitrusError error) {
                    CitrusClient.this.sendError(callback, error);
                }
            });
        }
    }

    public synchronized void getBalance(final Callback<Amount> callback) {
        if (this.validate()) {
            this.oauthToken.getSignInToken(new Callback<AccessToken>(){

                @Override
                public void success(AccessToken accessToken) {
                    new GetBalanceAsync(accessToken.getHeaderAccessToken(), new GetBalanceListener(){

                        @Override
                        public void success(Amount amount) {
                            CitrusClient.this.sendResponse(callback, amount);
                        }

                        @Override
                        public void error(CitrusError error) {
                            CitrusClient.this.sendError(callback, error);
                        }
                    }).execute(new String[0]);
                }

                @Override
                public void error(CitrusError error) {
                    CitrusClient.this.sendError(callback, error);
                }
            });
        }
    }

    public synchronized void savePaymentOption(final PaymentOption paymentOption, final Callback<CitrusResponse> callback) {
        if (this.validate()) {
            if (paymentOption != null) {
                if (paymentOption instanceof CardOption && !((CardOption)paymentOption).validateForSaveCard()) {
                    StringBuilder builder = new StringBuilder();
                    if (!((CardOption)paymentOption).validateCardNumber()) {
                        builder.append(" Invalid Card Number. ");
                    }
                    if (!((CardOption)paymentOption).validateExpiryDate()) {
                        builder.append(" Invalid Expiry Date. ");
                    }
                    this.sendError(callback, new CitrusError(builder.toString(), CitrusResponse.Status.FAILED));
                    return;
                }
                this.oauthToken.getSignInToken(new Callback<AccessToken>(){

                    @Override
                    public void success(AccessToken accessToken) {
                        CitrusClient.this.retrofitClient.savePaymentOption(accessToken.getHeaderAccessToken(), new TypedString(paymentOption.getSavePaymentOptionObject()), new retrofit.Callback<CitrusResponse>(){

                            public void success(CitrusResponse citrusResponse, Response response) {
                                CitrusClient.this.sendResponse(callback, new CitrusResponse("Payment Option Saved Successfully.", CitrusResponse.Status.SUCCESSFUL));
                            }

                            public void failure(RetrofitError error) {
                                CitrusClient.this.sendError(callback, error);
                            }
                        });
                    }

                    @Override
                    public void error(CitrusError error) {
                        CitrusClient.this.sendError(callback, error);
                    }
                });
            } else {
                this.sendError(callback, new CitrusError("PaymentOption is null.", CitrusResponse.Status.FAILED));
            }
        }
    }

    public synchronized void deletePaymentOption(final PaymentOption paymentOption, final Callback<CitrusResponse> callback) {
        if (this.validate()) {
            if (paymentOption != null) {
                this.oauthToken.getSignInToken(new Callback<AccessToken>(){

                    @Override
                    public void success(AccessToken accessToken) {
                        CitrusClient.this.retrofitClient.deletePaymentOption(accessToken.getHeaderAccessToken(), paymentOption.getToken(), new retrofit.Callback<Response>(){

                            public void success(Response r, Response response) {
                                CitrusClient.this.sendResponse(callback, new CitrusResponse("Payment Option Deleted Successfully.", CitrusResponse.Status.SUCCESSFUL));
                            }

                            public void failure(RetrofitError error) {
                                CitrusClient.this.sendError(callback, error);
                            }
                        });
                    }

                    @Override
                    public void error(CitrusError error) {
                        CitrusClient.this.sendError(callback, error);
                    }
                });
            } else {
                this.sendError(callback, new CitrusError("PaymentOption is null.", CitrusResponse.Status.FAILED));
            }
        }
    }

    public synchronized void getBill(String billUrl, Amount amount, final Callback<PaymentBill> callback) {
        new GetJSONBill(billUrl, amount, new retrofit.Callback<JsonElement>(){

            public void success(JsonElement jsonElement, Response response) {
                Logger.d((String)("GETBILL RESPONSE **" + jsonElement.toString()), (Object[])new Object[0]);
                PaymentBill paymentBill = PaymentBill.fromJSON(jsonElement.toString());
                if (paymentBill != null) {
                    CitrusClient.this.sendResponse(callback, paymentBill);
                } else {
                    CitrusClient.this.sendError(callback, new CitrusError("Invalid bill received from server.", CitrusResponse.Status.FAILED));
                }
            }

            public void failure(RetrofitError error) {
                CitrusClient.this.sendError(callback, error);
            }
        }).getJSONBill();
    }

    private synchronized void performDynamicPricing(final @NonNull DynamicPricingRequestType dynamicPricingRequestType, @NonNull String billUrl, final @NonNull Callback<DynamicPricingResponse> callback) {
        if (this.validate()) {
            if (dynamicPricingRequestType != null && !android.text.TextUtils.isEmpty((CharSequence)billUrl)) {
                Amount originalAmount = dynamicPricingRequestType.getOriginalAmount();
                String format = "#.00";
                String url = billUrl.contains("?") ? billUrl + "&amount=" + originalAmount.getValueAsFormattedDouble("#.00") : billUrl + "?amount=" + originalAmount.getValueAsFormattedDouble("#.00");
                String dpOperation = "&dpOperation=" + dynamicPricingRequestType.getDPOperationName();
                if (dynamicPricingRequestType instanceof DynamicPricingRequestType.SearchAndApplyRule) {
                    url = url + dpOperation;
                } else if (dynamicPricingRequestType instanceof DynamicPricingRequestType.CalculatePrice) {
                    String ruleName = "&ruleName=" + ((DynamicPricingRequestType.CalculatePrice)dynamicPricingRequestType).getRuleName();
                    url = url + dpOperation + ruleName;
                } else if (dynamicPricingRequestType instanceof DynamicPricingRequestType.ValidateRule) {
                    String ruleName = "&ruleName=" + ((DynamicPricingRequestType.ValidateRule)dynamicPricingRequestType).getRuleName();
                    Amount alteredAmount = ((DynamicPricingRequestType.ValidateRule)dynamicPricingRequestType).getAlteredAmount();
                    String alteredAmountValue = "&alteredAmount=" + alteredAmount.getValueAsFormattedDouble("#.00");
                    url = url + dpOperation + ruleName + alteredAmountValue;
                }
                this.getBill(url, originalAmount, new Callback<PaymentBill>(){

                    @Override
                    public void success(PaymentBill paymentBill) {
                        CitrusClient.this.performDynamicPricing(dynamicPricingRequestType, paymentBill, (Callback<DynamicPricingResponse>)new Callback<DynamicPricingResponse>(){

                            @Override
                            public void success(DynamicPricingResponse dynamicPricingResponse) {
                                CitrusClient.this.sendResponse(callback, dynamicPricingResponse);
                            }

                            @Override
                            public void error(CitrusError error) {
                                CitrusClient.this.sendError(callback, error);
                            }
                        });
                    }

                    @Override
                    public void error(CitrusError error) {
                        CitrusClient.this.sendError(callback, error);
                    }
                });
            }
        } else {
            this.sendError(callback, new CitrusError("DynamicPriceRequestType, Bill Url or PaymentBill should not be null", CitrusResponse.Status.FAILED));
        }
    }

    private synchronized void performDynamicPricing(@NonNull DynamicPricingRequestType dynamicPricingRequestType, final @NonNull PaymentBill paymentBill, final @NonNull Callback<DynamicPricingResponse> callback) {
        if (this.validate()) {
            if (dynamicPricingRequestType != null && paymentBill != null) {
                final PaymentOption paymentOption = dynamicPricingRequestType.getPaymentOption();
                final CitrusUser citrusUser = dynamicPricingRequestType.getCitrusUser();
                DynamicPricingRequest request = new DynamicPricingRequest(dynamicPricingRequestType, paymentBill);
                this.dynamicPricingClient.performDynamicPricing(new TypedString(DynamicPricingRequest.toJSON(request)), new retrofit.Callback<JsonElement>(){

                    public void success(JsonElement jsonElement, Response response) {
                        DynamicPricingResponse dynamicPricingResponse = DynamicPricingResponse.fromJSON(jsonElement.toString());
                        dynamicPricingResponse.setPaymentBill(paymentBill);
                        dynamicPricingResponse.setPaymentOption(paymentOption);
                        dynamicPricingResponse.setCitrusUser(citrusUser);
                        CitrusClient.this.sendResponse(callback, dynamicPricingResponse);
                    }

                    public void failure(RetrofitError error) {
                        CitrusClient.this.sendError(callback, error);
                    }
                });
            } else {
                this.sendError(callback, new CitrusError("DynamicPriceRequestType, Bill Url or PaymentBill should not be null", CitrusResponse.Status.FAILED));
            }
        }
    }

    public synchronized void sendMoney(final Amount amount, final CitrusUser toUser, final String message, final Callback<PaymentResponse> callback) {
        if (this.validate()) {
            if (amount == null || android.text.TextUtils.isEmpty((CharSequence)amount.getValue())) {
                this.sendError(callback, new CitrusError("Please enter the amount to be sent.", CitrusResponse.Status.FAILED));
                return;
            }
            if (toUser == null || android.text.TextUtils.isEmpty((CharSequence)toUser.getEmailId()) && android.text.TextUtils.isEmpty((CharSequence)toUser.getMobileNo())) {
                this.sendError(callback, new CitrusError("Please enter emaild id or the mobile no of your friend to send the money", CitrusResponse.Status.FAILED));
                return;
            }
            retrofit.Callback<PaymentResponse> callbackSendMoney = new retrofit.Callback<PaymentResponse>(){

                public void success(PaymentResponse paymentResponse, Response response) {
                    CitrusClient.this.sendResponse(callback, paymentResponse);
                }

                public void failure(RetrofitError error) {
                    CitrusClient.this.sendError(callback, error);
                }
            };
            this.getPrepaidToken(new Callback<AccessToken>((retrofit.Callback)callbackSendMoney, callback){
                final /* synthetic */ retrofit.Callback val$callbackSendMoney;
                final /* synthetic */ Callback val$callback;
                {
                    this.val$callbackSendMoney = callback;
                    this.val$callback = callback2;
                }

                @Override
                public void success(AccessToken accessToken) {
                    if (!android.text.TextUtils.isEmpty((CharSequence)toUser.getEmailId())) {
                        CitrusClient.this.retrofitClient.sendMoneyByEmail(accessToken.getHeaderAccessToken(), amount.getValue(), amount.getCurrency(), message, toUser.getEmailId(), (retrofit.Callback<PaymentResponse>)this.val$callbackSendMoney);
                    } else {
                        long mobileNo = TextUtils.isValidMobileNumber(toUser.getMobileNo());
                        if (mobileNo != -1L) {
                            CitrusClient.this.retrofitClient.sendMoneyByMobile(accessToken.getHeaderAccessToken(), amount.getValue(), amount.getCurrency(), message, String.valueOf(mobileNo), (retrofit.Callback<PaymentResponse>)this.val$callbackSendMoney);
                        } else {
                            CitrusClient.this.sendError(this.val$callback, new CitrusError("Invalid Mobile No", CitrusResponse.Status.FAILED));
                        }
                    }
                }

                @Override
                public void error(CitrusError error) {
                    CitrusClient.this.sendError(this.val$callback, error);
                }
            });
        }
    }

    public synchronized void sendMoneyToMoblieNo(final Amount amount, final String mobileNo, final String message, final Callback<PaymentResponse> callback) {
        if (this.validate()) {
            if (amount == null || android.text.TextUtils.isEmpty((CharSequence)amount.getValue())) {
                this.sendError(callback, new CitrusError("Please enter the amount to be sent.", CitrusResponse.Status.FAILED));
                return;
            }
            if (android.text.TextUtils.isEmpty((CharSequence)mobileNo)) {
                this.sendError(callback, new CitrusError("Please enter the mobile no of your friend to send the money", CitrusResponse.Status.FAILED));
                return;
            }
            this.getPrepaidToken(new Callback<AccessToken>(){

                @Override
                public void success(AccessToken accessToken) {
                    long validMobileNo = TextUtils.isValidMobileNumber(mobileNo);
                    if (validMobileNo != -1L) {
                        CitrusClient.this.retrofitClient.sendMoneyByMobile(accessToken.getHeaderAccessToken(), amount.getValue(), amount.getCurrency(), message, String.valueOf(validMobileNo), new retrofit.Callback<PaymentResponse>(){

                            public void success(PaymentResponse paymentResponse, Response response) {
                                CitrusClient.this.sendResponse(callback, paymentResponse);
                            }

                            public void failure(RetrofitError error) {
                                CitrusClient.this.sendError(callback, error);
                            }
                        });
                    } else {
                        CitrusClient.this.sendError(callback, new CitrusError("Invalid Mobile No", CitrusResponse.Status.FAILED));
                    }
                }

                @Override
                public void error(CitrusError error) {
                    CitrusClient.this.sendError(callback, error);
                }
            });
        }
    }

    public void getPrepaidToken(final Callback<AccessToken> callback) {
        this.oauthToken.getPrepaidToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                CitrusClient.this.sendResponse(callback, accessToken);
            }

            @Override
            public void error(CitrusError error) {
                CitrusClient.this.sendError(callback, error);
            }
        });
    }

    public synchronized void getMerchantPaymentOptions(final Callback<MerchantPaymentOption> callback) {
        if (this.validate()) {
            if (this.merchantPaymentOption == null) {
                this.retrofitClient.getMerchantPaymentOptions(this.vanity, new retrofit.Callback<JsonElement>(){

                    public void success(JsonElement element, Response response) {
                        if (element.isJsonObject()) {
                            JsonObject paymentOptionObj = element.getAsJsonObject();
                            if (paymentOptionObj != null) {
                                MerchantPaymentOption merchantPaymentOption = MerchantPaymentOption.getMerchantPaymentOptions(paymentOptionObj);
                                CitrusClient.this.setMerchantPaymentOption(merchantPaymentOption);
                                CitrusClient.this.sendResponse(callback, merchantPaymentOption);
                            } else {
                                CitrusClient.this.sendError(callback, new CitrusError("ERROR: Unable to fetch merchant payment options", CitrusResponse.Status.FAILED));
                            }
                        } else {
                            CitrusClient.this.sendError(callback, new CitrusError("ERROR: Invalid json received.", CitrusResponse.Status.FAILED));
                        }
                    }

                    public void failure(RetrofitError error) {
                        CitrusClient.this.sendError(callback, error);
                    }
                });
            } else {
                this.sendResponse(callback, this.merchantPaymentOption);
            }
        }
    }

    public synchronized void getLoadMoneyPaymentOptions(final Callback<MerchantPaymentOption> callback) {
        if (this.validate()) {
            this.retrofitClient.getMerchantPaymentOptions("prepaid", new retrofit.Callback<JsonElement>(){

                public void success(JsonElement element, Response response) {
                    if (element.isJsonObject()) {
                        JsonObject paymentOptionObj = element.getAsJsonObject();
                        if (paymentOptionObj != null) {
                            MerchantPaymentOption merchantPaymentOption = MerchantPaymentOption.getMerchantPaymentOptions(paymentOptionObj);
                            CitrusClient.this.sendResponse(callback, merchantPaymentOption);
                        } else {
                            CitrusClient.this.sendError(callback, new CitrusError("ERROR: Unable to fetch merchant payment options", CitrusResponse.Status.FAILED));
                        }
                    } else {
                        CitrusClient.this.sendError(callback, new CitrusError("ERROR: Invalid json received.", CitrusResponse.Status.FAILED));
                    }
                }

                public void failure(RetrofitError error) {
                    CitrusClient.this.sendError(callback, error);
                }
            });
        }
    }

    public synchronized void isUserSignedIn(final Callback<Boolean> callback) {
        this.oauthToken.getPrepaidToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                CitrusClient.this.sendResponse(callback, true);
            }

            @Override
            public void error(CitrusError error) {
                CitrusClient.this.sendResponse(callback, false);
            }
        });
    }

    public synchronized void loadMoney(PaymentType.LoadMoney loadMoney, Callback<TransactionResponse> callback) {
        PaymentOption paymentOption;
        if (loadMoney != null && (paymentOption = loadMoney.getPaymentOption()) instanceof CardOption && !((CardOption)paymentOption).validateCard()) {
            this.sendError(callback, new CitrusError(((CardOption)paymentOption).getCardValidityFailureReasons(), CitrusResponse.Status.FAILED));
            return;
        }
        this.registerReceiver(callback, new IntentFilter(loadMoney.getIntentAction()));
        this.startCitrusActivity(loadMoney, false);
    }

    public synchronized void pgPayment(PaymentType.PGPayment pgPayment, Callback<TransactionResponse> callback) {
        PaymentOption paymentOption;
        if (pgPayment != null && (paymentOption = pgPayment.getPaymentOption()) instanceof CardOption && !((CardOption)paymentOption).validateCard()) {
            this.sendError(callback, new CitrusError(((CardOption)paymentOption).getCardValidityFailureReasons(), CitrusResponse.Status.FAILED));
            return;
        }
        this.registerReceiver(callback, new IntentFilter(pgPayment.getIntentAction()));
        this.startCitrusActivity(pgPayment, false);
    }

    public synchronized void makePayment(PaymentType.PGPayment pgPayment, Callback<TransactionResponse> callback) {
        PaymentOption paymentOption;
        if (pgPayment != null && (paymentOption = pgPayment.getPaymentOption()) instanceof CardOption && !((CardOption)paymentOption).validateCard()) {
            this.sendError(callback, new CitrusError(((CardOption)paymentOption).getCardValidityFailureReasons(), CitrusResponse.Status.FAILED));
            return;
        }
        this.registerReceiver(callback, new IntentFilter(pgPayment.getIntentAction()));
        this.startCitrusActivity(pgPayment, true);
    }

    public synchronized void pgPayment(DynamicPricingResponse dynamicPricingResponse, Callback<TransactionResponse> callback) {
        if (dynamicPricingResponse != null) {
            PaymentBill paymentBill = dynamicPricingResponse.getPaymentBill();
            try {
                PaymentType.PGPayment pgPayment = new PaymentType.PGPayment(paymentBill, dynamicPricingResponse.getPaymentOption(), dynamicPricingResponse.getCitrusUser());
                this.registerReceiver(callback, new IntentFilter(pgPayment.getIntentAction()));
                this.startCitrusActivity(pgPayment, dynamicPricingResponse, false);
            }
            catch (CitrusException e) {
                e.printStackTrace();
                this.sendError(callback, new CitrusError(e.getMessage(), CitrusResponse.Status.FAILED));
            }
        } else {
            this.sendError(callback, new CitrusError("Dynamic Pricing Response can not be null", CitrusResponse.Status.FAILED));
        }
    }

    public synchronized void payUsingCitrusCash(final PaymentType.CitrusCash citrusCash, final Callback<TransactionResponse> callback) {
        String cookieExpiryDate = "";
        PersistentConfig persistentConfig = new PersistentConfig(this.mContext);
        String sessionCookie = persistentConfig.getCookieString();
        int start = sessionCookie.indexOf("Expires=");
        int end = sessionCookie.indexOf("GMT;");
        if (start != -1 && end != -1 && sessionCookie.length() > start + 13 && sessionCookie.length() > end) {
            cookieExpiryDate = sessionCookie.substring(start + 13, end);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy hh:mm:ss");
        Date expiryDate = new Date();
        Date currentDate = new Date(System.currentTimeMillis());
        try {
            expiryDate = dateFormat.parse(cookieExpiryDate);
            Logger.d((String)"Expiry date : %s, Current Date : %s", (Object[])new Object[]{expiryDate, currentDate});
            if (currentDate.before(expiryDate)) {
                this.getBalance(new Callback<Amount>(){

                    @Override
                    public void success(Amount balanceAmount) {
                        if (balanceAmount.getValueAsDouble() >= citrusCash.getAmount().getValueAsDouble()) {
                            CitrusClient.this.registerReceiver(callback, new IntentFilter(citrusCash.getIntentAction()));
                            CitrusClient.this.startCitrusActivity(citrusCash, false);
                        } else {
                            CitrusClient.this.sendError(callback, new CitrusError("The balance in your Citrus Cash account is insufficient. Please load money.", CitrusResponse.Status.FAILED));
                        }
                    }

                    @Override
                    public void error(CitrusError error) {
                        CitrusClient.this.sendError(callback, error);
                    }
                });
            } else {
                Logger.d((String)"User's cookie has expired. Please signin", (Object[])new Object[0]);
                this.sendError(callback, new CitrusError("User's cookie has expired. Please signin.", CitrusResponse.Status.FAILED));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            this.getBalance(new Callback<Amount>(){

                @Override
                public void success(Amount balanceAmount) {
                    if (balanceAmount.getValueAsDouble() >= citrusCash.getAmount().getValueAsDouble()) {
                        CitrusClient.this.registerReceiver(callback, new IntentFilter(citrusCash.getIntentAction()));
                        CitrusClient.this.startCitrusActivity(citrusCash, false);
                    } else {
                        CitrusClient.this.sendError(callback, new CitrusError("The balance in your Citrus Cash account is insufficient. Please load money.", CitrusResponse.Status.FAILED));
                    }
                }

                @Override
                public void error(CitrusError error) {
                    CitrusClient.this.sendError(callback, error);
                }
            });
        }
    }

    private synchronized void prepaidPay(final PaymentType.CitrusCash citrusCash, final Callback<PaymentResponse> callback) {
        final String billUrl = citrusCash.getUrl().contains("?") ? citrusCash.getUrl() + "&amount=" + citrusCash.getAmount().getValue() : citrusCash.getUrl() + "?amount=" + citrusCash.getAmount().getValue();
        if (this.prepaymentTokenValid) {
            this.getBalance(new Callback<Amount>(){

                @Override
                public void success(Amount balanceAmount) {
                    if (balanceAmount.getValueAsDouble() >= citrusCash.getAmount().getValueAsDouble()) {
                        CitrusClient.this.getBill(billUrl, citrusCash.getAmount(), new Callback<PaymentBill>(){

                            @Override
                            public void success(final PaymentBill paymentBill) {
                                final String returnUrl = paymentBill.getReturnUrl();
                                CitrusClient.this.oauthToken.getPrepaidToken(new Callback<AccessToken>(){

                                    @Override
                                    public void success(AccessToken accessToken) {
                                        citrusCash.setPaymentBill(paymentBill);
                                        CitrusUser citrusUser = CitrusClient.this.getCitrusUser();
                                        if (citrusCash.getCitrusUser() == null) {
                                            if (citrusUser == null) {
                                                citrusUser = new CitrusUser(CitrusClient.this.getUserEmailId(), CitrusClient.this.getUserMobileNumber());
                                            }
                                            citrusCash.setCitrusUser(citrusUser);
                                        }
                                        CitrusClient.this.retrofitClient.payUsingCitrusCash(accessToken.getPrepaidPayToken().getHeaderAccessToken(), new TypedString(citrusCash.getPaymentJSON()), new retrofit.Callback<JsonElement>(){

                                            public void success(JsonElement jsonElement, Response response) {
                                                if (jsonElement != null) {
                                                    PaymentResponse paymentResponse = PaymentResponse.fromJSON(jsonElement.toString());
                                                    CitrusClient.this.sendResponse(callback, paymentResponse);
                                                    CitrusClient.this.sendResponseToReturnUrlAsync(returnUrl, paymentResponse);
                                                } else {
                                                    CitrusClient.this.sendError(callback, new CitrusError("Error while making payment", CitrusResponse.Status.FAILED));
                                                }
                                            }

                                            public void failure(RetrofitError error) {
                                                CitrusClient.this.sendError(callback, error);
                                            }
                                        });
                                    }

                                    @Override
                                    public void error(CitrusError error) {
                                        CitrusClient.this.sendError(callback, error);
                                    }
                                });
                            }

                            @Override
                            public void error(CitrusError error) {
                                CitrusClient.this.sendError(callback, error);
                            }
                        });
                    } else {
                        CitrusClient.this.sendError(callback, new CitrusError("The balance in your Citrus Cash account is insufficient. Please load money.", CitrusResponse.Status.FAILED));
                    }
                }

                @Override
                public void error(CitrusError error) {
                    CitrusClient.this.sendError(callback, error);
                }
            });
        } else {
            Logger.d((String)"User's cookie has expired. Please signin", (Object[])new Object[0]);
            this.sendError(callback, new CitrusError("User's cookie has expired. Please signin.", CitrusResponse.Status.FAILED));
        }
    }

    private void checkPrepaymentTokenValidity(final Callback<Boolean> callback) {
        this.oauthToken.getSignUpToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                final String signupToken = accessToken.getHeaderAccessToken();
                CitrusClient.this.getPrepaidToken(new Callback<AccessToken>(){

                    @Override
                    public void success(AccessToken accessToken) {
                        String prepaymentToken = "";
                        if (accessToken.getPrepaidPayToken() != null) {
                            prepaymentToken = accessToken.getPrepaidPayToken().getHeaderAccessToken();
                        }
                        CitrusClient.this.retrofitClient.getPrepaymentTokenValidity(signupToken, prepaymentToken, "prepaid_merchant_pay", new retrofit.Callback<JsonElement>(){

                            public void success(JsonElement jsonElement, Response response) {
                                boolean valid = false;
                                if (jsonElement != null && !android.text.TextUtils.isEmpty((CharSequence)jsonElement.toString())) {
                                    try {
                                        JSONObject jsonObject = new JSONObject(jsonElement.toString());
                                        String validity = jsonObject.optString("expiration");
                                        valid = CitrusClient.this.isTokenValid(validity);
                                    }
                                    catch (JSONException e) {
                                        e.printStackTrace();
                                    }
                                }
                                CitrusClient.this.sendResponse(callback, valid);
                            }

                            public void failure(RetrofitError error) {
                                CitrusClient.this.sendResponse(callback, false);
                            }
                        });
                    }

                    @Override
                    public void error(CitrusError error) {
                        CitrusClient.this.sendResponse(callback, false);
                    }
                });
            }

            @Override
            public void error(CitrusError error) {
                CitrusClient.this.sendResponse(callback, false);
            }
        });
    }

    private synchronized boolean isTokenValid(String expiryDateStr) {
        boolean valid = false;
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd hh:mm:ss z yyyy");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date currentDate = new Date(System.currentTimeMillis());
        try {
            Date expiryDate = dateFormat.parse(expiryDateStr);
            Logger.d((String)"Expiry date : %s, Current Date : %s", (Object[])new Object[]{expiryDate, currentDate});
            if (currentDate.before(expiryDate)) {
                valid = true;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            valid = true;
        }
        return valid;
    }

    private synchronized void sendResponseToReturnUrlAsync(String returnUrl, PaymentResponse paymentResponse) {
        WebView webView = new WebView(this.mContext);
        webView.getSettings().setJavaScriptEnabled(true);
        byte[] data = paymentResponse != null ? paymentResponse.getURLEncodedParams().getBytes() : null;
        webView.postUrl(returnUrl, data);
    }

    public synchronized void cashout(final @NonNull CashoutInfo cashoutInfo, final Callback<PaymentResponse> callback) {
        if (cashoutInfo != null && cashoutInfo.validate()) {
            this.getBalance(new Callback<Amount>(){

                @Override
                public void success(Amount balanceAmount) {
                    if (balanceAmount.getValueAsDouble() >= cashoutInfo.getAmount().getValueAsDouble()) {
                        CitrusClient.this.oauthToken.getPrepaidToken(new Callback<AccessToken>(){

                            @Override
                            public void success(AccessToken accessToken) {
                                CitrusClient.this.retrofitClient.cashout(accessToken.getHeaderAccessToken(), cashoutInfo.getAmount().getValue(), cashoutInfo.getAmount().getCurrency(), cashoutInfo.getAccountHolderName(), cashoutInfo.getAccountNo(), cashoutInfo.getIfscCode(), new retrofit.Callback<PaymentResponse>(){

                                    public void success(PaymentResponse paymentResponse, Response response) {
                                        CitrusClient.this.sendResponse(callback, paymentResponse);
                                    }

                                    public void failure(RetrofitError error) {
                                        CitrusClient.this.sendError(callback, error);
                                    }
                                });
                            }

                            @Override
                            public void error(CitrusError error) {
                                CitrusClient.this.sendError(callback, error);
                            }
                        });
                    } else {
                        CitrusClient.this.sendError(callback, new CitrusError("The balance in your Citrus Cash account is insufficient. Please load money.", CitrusResponse.Status.FAILED));
                    }
                }

                @Override
                public void error(CitrusError error) {
                    CitrusClient.this.sendError(callback, error);
                }
            });
        } else {
            this.sendError(callback, new CitrusError("Please make sure amount, accoutNo, accountHolderName and ifscCode are not null or empty.", CitrusResponse.Status.FAILED));
        }
    }

    public synchronized void getCashoutInfo(final Callback<CashoutInfo> callback) {
        this.oauthToken.getPrepaidToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                CitrusClient.this.retrofitClient.getCashoutInfo(accessToken.getHeaderAccessToken(), new retrofit.Callback<JsonElement>(){

                    public void success(JsonElement jsonElement, Response response) {
                        CashoutInfo cashoutInfo = CashoutInfo.fromJSON(jsonElement.toString());
                        CitrusClient.this.sendResponse(callback, cashoutInfo);
                    }

                    public void failure(RetrofitError error) {
                        CitrusClient.this.sendError(callback, error);
                    }
                });
            }

            @Override
            public void error(CitrusError error) {
                CitrusClient.this.sendError(callback, error);
            }
        });
    }

    public synchronized void saveCashoutInfo(final CashoutInfo cashoutInfo, final Callback<CitrusResponse> callback) {
        this.oauthToken.getPrepaidToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                if (cashoutInfo != null) {
                    CitrusClient.this.retrofitClient.saveCashoutInfo(accessToken.getHeaderAccessToken(), new TypedString(CashoutInfo.toJSON(cashoutInfo)), new retrofit.Callback<CitrusResponse>(){

                        public void success(CitrusResponse citrusResponse, Response response) {
                            CitrusClient.this.sendResponse(callback, new CitrusResponse("Cashout Information Saved Successfully.", CitrusResponse.Status.SUCCESSFUL));
                        }

                        public void failure(RetrofitError error) {
                            CitrusClient.this.sendError(callback, error);
                        }
                    });
                } else {
                    CitrusClient.this.sendError(callback, new CitrusError("Please make sure amount, accoutNo, accountHolderName and ifscCode are not null or empty.", CitrusResponse.Status.FAILED));
                }
            }

            @Override
            public void error(CitrusError error) {
                CitrusClient.this.sendError(callback, error);
            }
        });
    }

    public synchronized void getPGHealth(PaymentOption paymentOption, final Callback<PGHealthResponse> callback) {
        if (!(paymentOption instanceof NetbankingOption)) {
            this.sendResponse(callback, new PGHealthResponse(PGHealth.GOOD, "All Good"));
        } else {
            this.citrusBaseUrlClient.getPGHealth(this.vanity, ((NetbankingOption)paymentOption).getBankCID(), new retrofit.Callback<PGHealthResponse>(){

                public void success(PGHealthResponse pgHealthResponse, Response response) {
                    CitrusClient.this.sendResponse(callback, pgHealthResponse);
                }

                public void failure(RetrofitError error) {
                    CitrusClient.this.sendError(callback, error);
                }
            });
        }
    }

    public void getBINDetails(CardOption cardOption, final Callback<BinServiceResponse> callback) {
        if (cardOption != null && !android.text.TextUtils.isEmpty((CharSequence)cardOption.getCardNumber())) {
            String cardNumber = cardOption.getCardNumber();
            String first6Digits = "";
            String token = "";
            if (!android.text.TextUtils.isEmpty((CharSequence)cardOption.getToken())) {
                token = cardOption.getToken();
            } else {
                first6Digits = cardNumber.length() > 6 ? cardNumber.substring(0, 6) : "";
            }
            retrofit.Callback<Response> responseCallback = new retrofit.Callback<Response>(){

                public void success(Response response, Response response2) {
                    String binServiceJSON = new String(((TypedByteArray)response.getBody()).getBytes());
                    BinServiceResponse binServiceResponse = BinServiceResponse.fromJSON(binServiceJSON);
                    if (binServiceResponse != null) {
                        CitrusClient.this.netBankForOTP = binServiceResponse.getNetBankForOTP();
                        CitrusClient.this.sendResponse(callback, binServiceResponse);
                    } else {
                        CitrusClient.this.sendError(callback, new CitrusError("Unable to get BIN Details", CitrusResponse.Status.FAILED));
                    }
                }

                public void failure(RetrofitError error) {
                    CitrusClient.this.sendError(callback, error);
                }
            };
            if (!android.text.TextUtils.isEmpty((CharSequence)first6Digits)) {
                API binServiceClient = RetroFitClient.getClientWithUrl("https://citrusapi.citruspay.com");
                binServiceClient.getBinInfo(first6Digits, responseCallback);
            } else if (!android.text.TextUtils.isEmpty((CharSequence)token)) {
                this.retrofitClient.getBinInfoUsingToken(token, responseCallback);
            } else {
                this.sendError(callback, new CitrusError("Unable to get BIN Details", CitrusResponse.Status.FAILED));
            }
        } else {
            this.sendError(callback, new CitrusError("Unable to get BIN Details", CitrusResponse.Status.FAILED));
        }
    }

    public NetBankForOTP getNetBankForOTP() {
        return this.netBankForOTP;
    }

    public synchronized String getUserEmailId() {
        return this.oauthToken.getEmailId();
    }

    public synchronized String getUserMobileNumber() {
        return this.oauthToken.getMobileNumber();
    }

    public synchronized CitrusUser getCitrusUser() {
        return this.citrusUser;
    }

    private void unregisterReceiver(BroadcastReceiver receiver) {
        LocalBroadcastManager.getInstance((Context)this.mContext).unregisterReceiver(receiver);
    }

    private void startCitrusActivity(PaymentType paymentType, DynamicPricingResponse dynamicPricingResponse, boolean useNewAPI) {
        Intent intent = new Intent(this.mContext, CitrusActivity.class);
        intent.setFlags(0x10000000);
        intent.putExtra("INTENT_EXTRA_PAYMENT_TYPE", (Parcelable)paymentType);
        intent.putExtra("INTENT_EXTRA_DYNAMIC_PRICING_RESPONSE", (Parcelable)dynamicPricingResponse);
        intent.putExtra("INTENT_EXTRA_USE_NEW_API", useNewAPI);
        this.mContext.startActivity(intent);
    }

    private void startCitrusActivity(PaymentType paymentType, boolean useNewAPI) {
        this.startCitrusActivity(paymentType, null, useNewAPI);
    }

    private <T> void registerReceiver(final Callback<T> callback, IntentFilter intentFilter) {
        this.paymentEventReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                CitrusClient.this.unregisterReceiver(this);
                CitrusClient.this.netBankForOTP = NetBankForOTP.UNKNOWN;
                TransactionResponse transactionResponse = (TransactionResponse)intent.getParcelableExtra("INTENT_EXTRA_TRANSACTION_RESPONSE");
                if (transactionResponse != null) {
                    TransactionResponse.TransactionStatus transactionStatus = transactionResponse.getTransactionStatus();
                    CitrusResponse.Status status = null;
                    if (transactionStatus != null) {
                        switch (transactionStatus) {
                            case SUCCESSFUL: {
                                status = CitrusResponse.Status.SUCCESSFUL;
                                break;
                            }
                            case FAILED: {
                                status = CitrusResponse.Status.FAILED;
                                break;
                            }
                            case CANCELLED: {
                                status = CitrusResponse.Status.CANCELLED;
                                break;
                            }
                            case PG_REJECTED: {
                                status = CitrusResponse.Status.PG_REJECTED;
                            }
                        }
                    }
                    if (transactionStatus == TransactionResponse.TransactionStatus.SUCCESSFUL) {
                        CitrusClient.this.sendResponse(callback, transactionResponse);
                    } else {
                        CitrusClient.this.sendError(callback, new CitrusError(transactionResponse.getMessage(), status));
                    }
                }
            }
        };
        LocalBroadcastManager.getInstance((Context)this.mContext).registerReceiver(this.paymentEventReceiver, intentFilter);
    }

    private synchronized boolean validate() {
        if (!(android.text.TextUtils.isEmpty((CharSequence)this.signinId) || android.text.TextUtils.isEmpty((CharSequence)this.signinSecret) || android.text.TextUtils.isEmpty((CharSequence)this.signupId) || android.text.TextUtils.isEmpty((CharSequence)this.signupSecret) || android.text.TextUtils.isEmpty((CharSequence)this.vanity))) {
            return true;
        }
        throw new IllegalArgumentException("Please make sure SignIn Id, SignIn Secret, SignUp Id, SignUp Secret & Vanity");
    }

    private <T> void sendResponse(Callback callback, T t) {
        if (callback != null) {
            callback.success(t);
        }
    }

    private void sendError(Callback callback, CitrusError error) {
        if (callback != null) {
            callback.error(error);
        }
    }

    private void sendError(Callback callback, RetrofitError error) {
        if (callback != null) {
            CitrusError citrusError;
            String message = null;
            if (error.getKind() == RetrofitError.Kind.NETWORK) {
                citrusError = new CitrusError("Please check your internet connection.", CitrusResponse.Status.FAILED);
            } else {
                if (error.getResponse() != null && error.getResponse().getBody() != null) {
                    message = new String(((TypedByteArray)error.getResponse().getBody()).getBytes());
                }
                if (message != null) {
                    try {
                        JSONObject jsonObject = new JSONObject(message);
                        String errorMessage = null;
                        errorMessage = !android.text.TextUtils.isEmpty((CharSequence)jsonObject.optString("error_description")) ? jsonObject.optString("error_description") : (!android.text.TextUtils.isEmpty((CharSequence)jsonObject.optString("errorMessage")) ? jsonObject.optString("errorMessage") : message);
                        citrusError = new CitrusError(errorMessage, CitrusResponse.Status.FAILED);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        citrusError = new CitrusError(message, CitrusResponse.Status.FAILED);
                    }
                } else {
                    citrusError = new CitrusError(error.getMessage(), CitrusResponse.Status.FAILED);
                }
            }
            this.sendError(callback, citrusError);
        }
    }

    public String getSigninId() {
        return this.signinId;
    }

    public void setSigninId(String signinId) {
        this.signinId = signinId;
    }

    public String getSigninSecret() {
        return this.signinSecret;
    }

    public void setSigninSecret(String signinSecret) {
        this.signinSecret = signinSecret;
    }

    public String getSignupId() {
        return this.signupId;
    }

    public void setSignupId(String signupId) {
        this.signupId = signupId;
    }

    public String getSignupSecret() {
        return this.signupSecret;
    }

    public void setSignupSecret(String signupSecret) {
        this.signupSecret = signupSecret;
    }

    public String getVanity() {
        return this.vanity;
    }

    public void setVanity(String vanity) {
        this.vanity = vanity;
    }

    public String getMerchantName() {
        return this.merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Amount getBalanceAmount() {
        return this.balanceAmount;
    }

    public void setBalanceAmount(Amount balanceAmount) {
        this.balanceAmount = balanceAmount;
    }

    public MerchantPaymentOption getMerchantPaymentOption() {
        return this.merchantPaymentOption;
    }

    public void setMerchantPaymentOption(MerchantPaymentOption merchantPaymentOption) {
        this.merchantPaymentOption = merchantPaymentOption;
    }

    public void onEvent(CookieEvents cookieEvents) {
        Logger.d((String)("COOKIE IN CITRUS CLIENT  ****" + cookieEvents.getCookie()), (Object[])new Object[0]);
        this.prepaidCookie = cookieEvents.getCookie();
    }

    private static interface GetBalanceListener {
        public void success(Amount var1);

        public void error(CitrusError var1);
    }

    private class GetBalanceAsync
    extends AsyncTask<String, Void, Amount> {
        private GetBalanceListener listener = null;
        private String accessToken = null;

        public GetBalanceAsync(String accessToken, GetBalanceListener listener) {
            this.accessToken = accessToken;
            this.listener = listener;
        }

        protected Amount doInBackground(String ... strings) {
            Amount amount = null;
            String getBalanceUrl = CitrusClient.this.environment.getBaseUrl() + "/service/v2/mycard/balance";
            try {
                String inputLine;
                URL url = new URL(getBalanceUrl);
                HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Authorization", this.accessToken);
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                amount = Amount.fromJSON(response.toString());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return amount;
        }

        protected void onPostExecute(Amount amount) {
            super.onPostExecute((Object)amount);
            if (amount != null) {
                this.listener.success(amount);
            } else {
                this.listener.error(new CitrusError("Failed to get the balance.", CitrusResponse.Status.FAILED));
            }
        }
    }
}

