/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.payment;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.citrus.card.Card;
import com.citrus.cash.LoadMoney;
import com.citrus.cash.Prepaid;
import com.citrus.mobile.OauthToken;
import com.citrus.netbank.Bank;
import com.citrus.netbank.BankPaymentType;
import com.citrus.payment.Bill;
import com.citrus.payment.UserDetails;
import com.citrus.retrofit.RetroFitClient;
import com.citrus.sdk.Callback;
import com.citrus.sdk.Environment;
import com.citrus.sdk.classes.AccessToken;
import com.citrus.sdk.classes.CitrusPrepaidBill;
import com.citrus.sdk.classes.StructResponsePOJO;
import com.citrus.sdk.dynamicPricing.DynamicPricingResponse;
import com.citrus.sdk.payment.CardOption;
import com.citrus.sdk.payment.NetbankingOption;
import com.citrus.sdk.payment.PaymentOption;
import com.citrus.sdk.response.CitrusError;
import com.orhanobut.logger.Logger;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit.RetrofitError;
import retrofit.client.Response;
import retrofit.mime.TypedByteArray;
import retrofit.mime.TypedString;

public class PG {
    Activity activity;
    private Card card;
    private Bill bill;
    private UserDetails userDetails;
    private com.citrus.mobile.Callback callback;
    private com.citrus.mobile.Callback internal;
    private JSONObject payment;
    private Bank bank;
    private Prepaid prepaid;
    private String paymenttype;
    private JSONObject customParameters = null;
    private LoadMoney loadmoney;
    ArrayList<String> mylist = new ArrayList();
    private DynamicPricingResponse dynamicPricingResponse = null;
    private Environment environment;

    public PG(Environment environment, PaymentOption paymentOption, Bill bill, UserDetails userDetails, DynamicPricingResponse dynamicPricingResponse) {
        if (paymentOption != null) {
            if (paymentOption instanceof CardOption) {
                CardOption cardOption = (CardOption)paymentOption;
                if (cardOption.getToken() != null) {
                    this.card = new Card(cardOption.getToken(), cardOption.getCardCVV());
                    this.paymenttype = "cardtoken";
                } else {
                    this.card = new Card(cardOption.getCardNumber(), cardOption.getCardExpiryMonth(), cardOption.getCardExpiryYear(), cardOption.getCardCVV(), cardOption.getCardHolderName(), cardOption.getCardType());
                    this.paymenttype = "card";
                }
            } else if (paymentOption instanceof NetbankingOption) {
                NetbankingOption netbankingOption = (NetbankingOption)paymentOption;
                if (netbankingOption.getToken() != null) {
                    this.bank = new Bank(netbankingOption.getToken(), BankPaymentType.TOKEN);
                    this.paymenttype = this.bank.getPaymentType().toString();
                } else {
                    this.bank = new Bank(netbankingOption.getBankCID());
                    this.paymenttype = "netbank";
                }
            }
        }
        this.environment = environment;
        this.bill = bill;
        this.userDetails = userDetails;
        this.customParameters = bill.getCustomParameters();
        this.dynamicPricingResponse = dynamicPricingResponse;
    }

    public PG(Environment environment, PaymentOption paymentOption, LoadMoney load, UserDetails userDetails) {
        if (paymentOption != null) {
            if (paymentOption instanceof CardOption) {
                CardOption cardOption = (CardOption)paymentOption;
                if (cardOption.getToken() != null) {
                    this.card = new Card(cardOption.getToken(), cardOption.getCardCVV());
                    this.paymenttype = "cardtoken";
                } else {
                    this.card = new Card(cardOption.getCardNumber(), cardOption.getCardExpiryMonth(), cardOption.getCardExpiryYear(), cardOption.getCardCVV(), cardOption.getCardHolderName(), cardOption.getCardType());
                    this.paymenttype = "card";
                }
            } else if (paymentOption instanceof NetbankingOption) {
                NetbankingOption netbankingOption = (NetbankingOption)paymentOption;
                if (netbankingOption.getToken() != null) {
                    this.bank = new Bank(netbankingOption.getToken(), BankPaymentType.TOKEN);
                    this.paymenttype = this.bank.getPaymentType().toString();
                } else {
                    this.bank = new Bank(netbankingOption.getBankCID());
                    this.paymenttype = "netbank";
                }
            }
        }
        this.environment = environment;
        this.loadmoney = load;
        this.userDetails = userDetails;
    }

    public PG(Environment environment, Prepaid prepaid, Bill bill, UserDetails userDetails) {
        this.bill = bill;
        this.userDetails = userDetails;
        this.prepaid = prepaid;
        this.paymenttype = "prepaid";
        this.environment = environment;
        this.customParameters = bill.getCustomParameters();
    }

    public void charge(com.citrus.mobile.Callback callback, boolean useNewMakePaymentAPI) {
        this.callback = callback;
        this.validate(useNewMakePaymentAPI);
    }

    public void load(Activity activity, com.citrus.mobile.Callback callback) {
        this.callback = callback;
        this.activity = activity;
        this.internal = new com.citrus.mobile.Callback(){

            @Override
            public void onTaskexecuted(String success, String error) {
                if (!TextUtils.isEmpty((CharSequence)success)) {
                    PG.this.formprepaidBill(success);
                } else {
                    PG.this.callback.onTaskexecuted("", error);
                }
            }
        };
        this.getPrepaidBill(this.loadmoney.getAmount(), this.loadmoney.getReturl());
    }

    private void formprepaidBill(String prepaid_bill) {
        this.bill = new Bill(prepaid_bill, "prepaid");
        this.validate(false);
    }

    public void setCustomParameters(JSONObject customParameters) {
        this.customParameters = customParameters;
    }

    private void validate(boolean useNewMakePaymentAPI) {
        if (TextUtils.equals((CharSequence)this.paymenttype.toString(), (CharSequence)"card") || TextUtils.equals((CharSequence)this.paymenttype.toString(), (CharSequence)"cardtoken")) {
            if (TextUtils.isEmpty((CharSequence)this.card.getCardNumber()) && TextUtils.isEmpty((CharSequence)this.card.getcardToken())) {
                this.callback.onTaskexecuted("", "Invalid Card or Card token!");
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)this.card.getCardNumber()) && !this.card.validateCard()) {
                this.callback.onTaskexecuted("", "Invalid Card!");
                return;
            }
        }
        String access_key = this.bill.getAccess_key();
        String txn_id = this.bill.getTxnId();
        String signature = this.bill.getSignature();
        String returnUrl = this.bill.getReturnurl();
        String email = this.userDetails.getEmail();
        String mobile = this.userDetails.getMobile();
        String firstname = this.userDetails.getFirstname();
        String lastname = this.userDetails.getLastname();
        this.mylist.add(access_key);
        this.mylist.add(txn_id);
        this.mylist.add(signature);
        this.mylist.add(returnUrl);
        this.mylist.add(email);
        this.mylist.add(mobile);
        this.mylist.add(firstname);
        this.mylist.add(lastname);
        this.checkifnull();
        this.formjson(useNewMakePaymentAPI);
    }

    private void checkifnull() {
        for (String param : this.mylist) {
            if (!TextUtils.isEmpty((CharSequence)param)) continue;
            this.callback.onTaskexecuted("", "Bill or userdetails can not contain empty parameters");
            return;
        }
    }

    private void formjson(boolean useNewMakePaymentAPI) {
        JSONObject paymentToken = new JSONObject();
        boolean isTokenizedPayment = false;
        if (TextUtils.equals((CharSequence)this.paymenttype.toString(), (CharSequence)"card")) {
            JSONObject paymentmode = new JSONObject();
            try {
                if (this.card.getCardType() != null && "MTRO".equalsIgnoreCase(this.card.getCardType().toString()) && TextUtils.isEmpty((CharSequence)this.card.getCvvNumber())) {
                    paymentmode.put("cvv", (Object)"123");
                } else {
                    paymentmode.put("cvv", (Object)this.card.getCvvNumber());
                }
                paymentmode.put("holder", (Object)this.card.getCardHolderName());
                paymentmode.put("number", (Object)this.card.getCardNumber());
                paymentmode.put("scheme", (Object)this.card.getCardType());
                paymentmode.put("type", (Object)this.card.getCrdr());
                if (this.card.getCardType() != null && "MTRO".equalsIgnoreCase(this.card.getCardType().toString()) && TextUtils.isEmpty((CharSequence)this.card.getExpiryMonth()) && TextUtils.isEmpty((CharSequence)this.card.getExpiryYear())) {
                    paymentmode.put("expiry", (Object)"11/2019");
                } else {
                    paymentmode.put("expiry", (Object)(this.card.getExpiryMonth() + "/" + this.card.getExpiryYear()));
                }
                paymentToken.put("type", (Object)"paymentOptionToken");
                paymentToken.put("paymentMode", (Object)paymentmode);
            }
            catch (JSONException e) {
                e.printStackTrace();
                this.callback.onTaskexecuted("", "Problem forming payment Json");
                return;
            }
        }
        if (TextUtils.equals((CharSequence)this.paymenttype.toString(), (CharSequence)"prepaid")) {
            isTokenizedPayment = true;
            JSONObject paymentmode = new JSONObject();
            try {
                paymentmode.put("cvv", (Object)"000");
                paymentmode.put("holder", (Object)this.prepaid.getUserEmail());
                paymentmode.put("number", (Object)"1234561234561234");
                paymentmode.put("scheme", (Object)"CPAY");
                paymentmode.put("type", (Object)"prepaid");
                paymentmode.put("expiry", (Object)"04/2030");
                paymentToken.put("type", (Object)"paymentOptionToken");
                paymentToken.put("paymentMode", (Object)paymentmode);
            }
            catch (JSONException e) {
                e.printStackTrace();
                this.callback.onTaskexecuted("", "Problem forming payment Json");
                return;
            }
        }
        if (TextUtils.equals((CharSequence)this.paymenttype.toString(), (CharSequence)"cardtoken")) {
            isTokenizedPayment = true;
            try {
                paymentToken.put("type", (Object)"paymentOptionIdToken");
                paymentToken.put("id", (Object)this.card.getcardToken());
                paymentToken.put("cvv", (Object)this.card.getCvvNumber());
                isTokenizedPayment = true;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            try {
                if (this.paymenttype != null && this.paymenttype.equalsIgnoreCase(BankPaymentType.TOKEN.toString())) {
                    isTokenizedPayment = true;
                    paymentToken.put("id", (Object)this.bank.getBankToken());
                    paymentToken.put("type", (Object)this.bank.getPaymentType().toString());
                } else {
                    JSONObject paymentmode = new JSONObject();
                    paymentmode.put("type", (Object)"netbanking");
                    paymentmode.put("code", (Object)this.bank.getCidnumber());
                    paymentToken.put("type", (Object)"paymentOptionToken");
                    paymentToken.put("paymentMode", (Object)paymentmode);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        JSONObject userdetails = new JSONObject();
        JSONObject address = new JSONObject();
        try {
            address.put("state", (Object)this.userDetails.getState());
            address.put("street1", (Object)this.userDetails.getStreet1());
            address.put("street2", (Object)this.userDetails.getStreet2());
            address.put("city", (Object)this.userDetails.getCity());
            address.put("country", (Object)this.userDetails.getCountry());
            address.put("zip", (Object)this.userDetails.getZip());
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.callback.onTaskexecuted("", "Problem forming in address Json");
            return;
        }
        try {
            userdetails.put("email", (Object)this.userDetails.getEmail());
            userdetails.put("mobileNo", (Object)this.userDetails.getMobile());
            userdetails.put("firstName", (Object)this.userDetails.getFirstname());
            userdetails.put("lastName", (Object)this.userDetails.getLastname());
            userdetails.put("address", (Object)address);
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.callback.onTaskexecuted("", "Problem forming in userdetails Json");
            return;
        }
        this.payment = new JSONObject();
        try {
            this.payment.put("returnUrl", (Object)this.bill.getReturnurl());
            if (this.bill.getNotifyurl() != null) {
                this.payment.put("notifyUrl", (Object)this.bill.getNotifyurl());
            }
            this.payment.put("amount", (Object)this.bill.getAmount());
            this.payment.put("merchantAccessKey", (Object)this.bill.getAccess_key());
            if (this.customParameters != null) {
                this.payment.put("customParameters", (Object)this.customParameters);
            }
            if (this.dynamicPricingResponse != null) {
                this.payment.put("offerToken", (Object)this.dynamicPricingResponse.getOfferToken());
            }
            this.payment.put("paymentToken", (Object)paymentToken);
            this.payment.put("merchantTxnId", (Object)this.bill.getTxnId());
            this.payment.put("requestSignature", (Object)this.bill.getSignature());
            if (isTokenizedPayment) {
                this.payment.put("requestOrigin", (Object)"MSDKW");
            } else {
                this.payment.put("requestOrigin", (Object)"MSDKG");
            }
            this.payment.put("userDetails", (Object)userdetails);
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.callback.onTaskexecuted("", "Problem forming in userdetails Json");
            return;
        }
        JSONObject headers = new JSONObject();
        try {
            headers.put("Content-Type", (Object)"application/json");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (useNewMakePaymentAPI) {
            this.newMakePayment();
        } else {
            this.retrofitCharge();
        }
    }

    private void newMakePayment() {
        RetroFitClient.getClientWithUrl(this.environment.getBaseCitrusUrl()).makePayment(new TypedString(this.payment.toString()), new retrofit.Callback<Response>(){

            public void success(Response response, Response response2) {
                String bankHTML = new String(((TypedByteArray)response.getBody()).getBytes());
                Logger.d((String)("MOTO SUCCESSFUL***" + bankHTML), (Object[])new Object[0]);
                PG.this.callback.onTaskexecuted(bankHTML, "");
            }

            public void failure(RetrofitError error) {
                Logger.d((String)("FAILED MOTO CALL**** " + error.getMessage()), (Object[])new Object[0]);
                if (error.getKind() == RetrofitError.Kind.NETWORK) {
                    PG.this.callback.onTaskexecuted("", "Please check your internet connection.");
                } else {
                    PG.this.callback.onTaskexecuted("", error.getMessage());
                }
            }
        });
    }

    private void retrofitCharge() {
        RetroFitClient.getCitrusRetroFitClient().getPaymentResponse(new TypedString(this.payment.toString()), new retrofit.Callback<StructResponsePOJO>(){

            public void success(StructResponsePOJO structResponse, Response response) {
                String motoResponse = structResponse.getJSON().toString();
                Logger.d((String)("MOTO SUCCESSFUL***" + motoResponse), (Object[])new Object[0]);
                PG.this.callback.onTaskexecuted(motoResponse, "");
            }

            public void failure(RetrofitError error) {
                Logger.d((String)("FAILED MOTO CALL**** " + error.getMessage()), (Object[])new Object[0]);
                if (error.getKind() == RetrofitError.Kind.NETWORK) {
                    PG.this.callback.onTaskexecuted("", "Please check your internet connection.");
                } else {
                    PG.this.callback.onTaskexecuted("", error.getMessage());
                }
            }
        });
    }

    void getPrepaidBill(final String amount, final String returnURL) {
        OauthToken token = new OauthToken((Context)this.activity);
        token.getPrepaidToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                String header = "Bearer " + accessToken.getAccessToken();
                RetroFitClient.getCitrusRetroFitClient().getPrepaidBill(header, amount, returnURL, "INR", new retrofit.Callback<CitrusPrepaidBill>(){

                    public void success(CitrusPrepaidBill citrusPrepaidBill, Response response) {
                        Logger.d((String)("PREPAID BILL RESONSE ***" + citrusPrepaidBill.toString()), (Object[])new Object[0]);
                        PG.this.internal.onTaskexecuted(citrusPrepaidBill.toString(), "");
                    }

                    public void failure(RetrofitError error) {
                        String json = null;
                        String message = null;
                        if (error != null && error.getResponse() != null && error.getResponse().getBody() != null) {
                            json = new String(((TypedByteArray)error.getResponse().getBody()).getBytes());
                        }
                        Logger.d((String)("Failed to get Prepaid Bill" + json), (Object[])new Object[0]);
                        if (json != null) {
                            try {
                                JSONObject jsonObject = new JSONObject(json);
                                message = jsonObject.optString("errorMessage");
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                        PG.this.internal.onTaskexecuted("", message);
                    }
                });
            }

            @Override
            public void error(CitrusError error) {
                Logger.d((String)"Failed to get Prepaid Token***", (Object[])new Object[0]);
                PG.this.internal.onTaskexecuted("", "{\"message\":\"Prepaid Oauth Token is missing - did you sign in the user?\",\"error\":\"600\"}");
            }
        });
    }
}

